/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.synth.TestHalt;
import org.h2.test.utils.SelfDestructor;

public class TestHaltApp
extends TestHalt {
    private int rowCount;

    public static void main(String ... args) throws Exception {
        SelfDestructor.startCountdown(60);
        TestHaltApp app = new TestHaltApp();
        if (args.length == 0) {
            app.controllerTest();
        } else {
            app.operations = Integer.parseInt(args[0]);
            app.flags = Integer.parseInt(args[1]);
            app.value = Integer.parseInt(args[2]);
            app.processRunRandom();
        }
    }

    @Override
    protected void execute(Statement stat, String sql) throws SQLException {
        this.traceOperation("execute: " + sql);
        super.execute(stat, sql);
    }

    @Override
    protected void controllerInit() throws SQLException {
        Statement stat = this.conn.createStatement();
        int i = 0;
        while (i < 20) {
            this.execute(stat, "DROP TABLE IF EXISTS TEST" + i);
            this.execute(stat, "CREATE TABLE TEST" + i + "(ID INT PRIMARY KEY, NAME VARCHAR(255))");
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.execute(stat, "DROP TABLE TEST" + i);
            i += 2;
        }
        this.execute(stat, "DROP TABLE IF EXISTS TEST");
        this.execute(stat, "CREATE TABLE TEST(ID BIGINT GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR(255), DATA CLOB)");
    }

    @Override
    protected void controllerWaitAfterAppStart() throws Exception {
        int sleep = 10 + this.random.nextInt(300);
        if ((this.flags & 1) == 0) {
            sleep += 1000;
        }
        Thread.sleep(sleep);
    }

    @Override
    protected void controllerCheckAfterCrash() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
        if (count % 2 != 0) {
            this.traceOperation("row count: " + count);
            throw new SQLException("Unexpected odd row count: " + count);
        }
    }

    @Override
    protected void processAppStart() throws SQLException {
        Statement stat = this.conn.createStatement();
        if ((this.flags & 1) != 0) {
            this.execute(stat, "SET WRITE_DELAY 0");
            this.execute(stat, "SET MAX_LOG_SIZE 1");
        }
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        this.rowCount = rs.getInt(1);
        this.traceOperation("rows: " + this.rowCount, null);
    }

    @Override
    protected void processAppRun() throws SQLException {
        this.conn.setAutoCommit(false);
        this.traceOperation("setAutoCommit false");
        int rows = 10000 + this.value;
        PreparedStatement prepInsert = this.conn.prepareStatement("INSERT INTO TEST(NAME, DATA) VALUES('Hello World', ?)");
        PreparedStatement prepUpdate = this.conn.prepareStatement("UPDATE TEST SET NAME = 'Hallo Welt', DATA = ? WHERE ID = ?");
        int i = 0;
        while (i < rows) {
            String s;
            Statement stat = this.conn.createStatement();
            if ((this.operations & 1) != 0) {
                if ((this.flags & 2) != 0) {
                    s = this.getRandomString(this.random.nextInt(200));
                    prepInsert.setString(1, s);
                    this.traceOperation("insert " + s);
                    prepInsert.execute();
                } else {
                    this.execute(stat, "INSERT INTO TEST(NAME) VALUES('Hello World')");
                }
                ResultSet rs = stat.getGeneratedKeys();
                rs.next();
                int key = rs.getInt(1);
                this.traceOperation("inserted key: " + key);
                ++this.rowCount;
            }
            if ((this.operations & 4) != 0) {
                if ((this.flags & 2) != 0) {
                    s = this.getRandomString(this.random.nextInt(200));
                    prepUpdate.setString(1, s);
                    int x = this.random.nextInt(this.rowCount + 1);
                    prepUpdate.setInt(2, x);
                    this.traceOperation("update " + s + " " + x);
                    prepUpdate.execute();
                } else {
                    int x = this.random.nextInt(this.rowCount + 1);
                    this.execute(stat, "UPDATE TEST SET VALUE = 'Hallo Welt' WHERE ID = " + x);
                }
            }
            if ((this.operations & 2) != 0) {
                int x = this.random.nextInt(this.rowCount + 1);
                this.traceOperation("deleting " + x);
                int uc = stat.executeUpdate("DELETE FROM TEST WHERE ID = " + x);
                this.traceOperation("updated: " + uc);
                this.rowCount -= uc;
            }
            this.traceOperation("rowCount " + this.rowCount);
            this.traceOperation("rows now: " + this.rowCount, null);
            if (this.rowCount % 2 == 0) {
                this.traceOperation("commit " + this.rowCount);
                this.conn.commit();
                this.traceOperation("committed: " + this.rowCount, null);
            }
            if ((this.flags & 1) != 0 && this.random.nextInt(10) == 0 && this.rowCount % 2 == 0) {
                this.execute(stat, "CHECKPOINT");
            }
            ++i;
        }
        this.traceOperation("rollback");
        this.conn.rollback();
    }
}

