/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.StringUtils;

public class TestJoin
extends TestDb {
    private final ArrayList<Connection> connections = new ArrayList();
    private Random random;
    private int paramCount;
    private StringBuilder buff;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testJoin();
    }

    private void testJoin() throws Exception {
        this.deleteDb("join");
        String shortestFailed = null;
        Connection c1 = this.getConnection("join");
        this.connections.add(c1);
        Class.forName("org.postgresql.Driver");
        Connection c2 = DriverManager.getConnection("jdbc:postgresql:test", "sa", "sa");
        this.connections.add(c2);
        this.execute("DROP TABLE ONE", null, true);
        this.execute("DROP TABLE TWO", null, true);
        this.execute("CREATE TABLE ONE(A INT PRIMARY KEY, B INT)", null);
        this.execute("INSERT INTO ONE VALUES(0, NULL)", null);
        this.execute("INSERT INTO ONE VALUES(1, 0)", null);
        this.execute("INSERT INTO ONE VALUES(2, 1)", null);
        this.execute("INSERT INTO ONE VALUES(3, 4)", null);
        this.execute("CREATE TABLE TWO(A INT PRIMARY KEY, B INT)", null);
        this.execute("INSERT INTO TWO VALUES(0, NULL)", null);
        this.execute("INSERT INTO TWO VALUES(1, 0)", null);
        this.execute("INSERT INTO TWO VALUES(2, 2)", null);
        this.execute("INSERT INTO TWO VALUES(3, 3)", null);
        this.execute("INSERT INTO TWO VALUES(4, NULL)", null);
        this.random = new Random();
        long startTime = System.nanoTime();
        int i = 0;
        while (true) {
            block11: {
                this.paramCount = 0;
                this.buff = new StringBuilder();
                long time = System.nanoTime();
                if (time - startTime > TimeUnit.SECONDS.toNanos(5L)) {
                    this.printTime("i:" + i);
                    startTime = time;
                }
                this.buff.append("SELECT ");
                int tables = 1 + this.random.nextInt(5);
                int j = 0;
                while (j < tables) {
                    if (j > 0) {
                        this.buff.append(", ");
                    }
                    this.buff.append("T" + (char)(48 + j) + ".A");
                    ++j;
                }
                this.buff.append(" FROM ");
                this.appendRandomTable();
                this.buff.append(" T0 ");
                j = 1;
                while (j < tables) {
                    if (this.random.nextBoolean()) {
                        this.buff.append("INNER");
                    } else {
                        this.buff.append("LEFT");
                    }
                    this.buff.append(" JOIN ");
                    this.appendRandomTable();
                    this.buff.append(" T");
                    this.buff.append((char)(48 + j));
                    this.buff.append(" ON ");
                    this.appendRandomCondition(j);
                    ++j;
                }
                if (this.random.nextBoolean()) {
                    this.buff.append("WHERE ");
                    this.appendRandomCondition(tables - 1);
                }
                String sql = this.buff.toString();
                Object[] params = new Object[this.paramCount];
                int j2 = 0;
                while (j2 < this.paramCount) {
                    params[j2] = this.random.nextInt(4) == 1 ? null : Integer.valueOf(this.random.nextInt(10) - 3);
                    ++j2;
                }
                try {
                    this.execute(sql, params);
                }
                catch (Exception e) {
                    if (shortestFailed != null && shortestFailed.length() <= sql.length()) break block11;
                    TestBase.logError("/*SHORT*/ " + sql, null);
                    shortestFailed = sql;
                }
            }
            ++i;
        }
    }

    private void appendRandomTable() {
        if (this.random.nextBoolean()) {
            this.buff.append("ONE");
        } else {
            this.buff.append("TWO");
        }
    }

    private void appendRandomCondition(int j) {
        if (this.random.nextInt(10) == 1) {
            this.buff.append("NOT ");
            this.appendRandomCondition(j);
        } else if (this.random.nextInt(5) == 1) {
            this.buff.append("(");
            this.appendRandomCondition(j);
            if (this.random.nextBoolean()) {
                this.buff.append(") OR (");
            } else {
                this.buff.append(") AND (");
            }
            this.appendRandomCondition(j);
            this.buff.append(")");
        } else if (j > 0 && this.random.nextBoolean()) {
            this.buff.append("T" + (char)(48 + j - 1) + ".A=T" + (char)(48 + j) + ".A ");
        } else {
            this.appendRandomConditionPart(j);
        }
    }

    private void appendRandomConditionPart(int j) {
        int t1 = j <= 1 ? 0 : this.random.nextInt(j + 1);
        int t2 = j <= 1 ? 0 : this.random.nextInt(j + 1);
        String c1 = this.random.nextBoolean() ? "A" : "B";
        String c2 = this.random.nextBoolean() ? "A" : "B";
        this.buff.append("T" + (char)(48 + t1));
        this.buff.append("." + c1);
        if (this.random.nextInt(4) == 1) {
            if (this.random.nextInt(5) == 1) {
                this.buff.append(" IS NOT NULL");
            } else {
                this.buff.append(" IS NULL");
            }
        } else {
            if (this.random.nextInt(5) == 1) {
                switch (this.random.nextInt(5)) {
                    case 0: {
                        this.buff.append(">");
                        break;
                    }
                    case 1: {
                        this.buff.append("<");
                        break;
                    }
                    case 2: {
                        this.buff.append("<=");
                        break;
                    }
                    case 3: {
                        this.buff.append(">=");
                        break;
                    }
                    case 4: {
                        this.buff.append("<>");
                    }
                }
            } else {
                this.buff.append("=");
            }
            if (this.random.nextBoolean()) {
                this.buff.append("T" + (char)(48 + t2));
                this.buff.append("." + c2);
            } else {
                this.buff.append(this.random.nextInt(5) - 1);
            }
        }
        this.buff.append(" ");
    }

    private void execute(String sql, Object[] params) {
        this.execute(sql, params, false);
    }

    private void execute(String sql, Object[] params, boolean ignoreDifference) {
        String first = null;
        int i = 0;
        while (i < this.connections.size()) {
            Object s;
            Connection conn = this.connections.get(i);
            try {
                boolean result;
                Statement stat;
                if (params == null || params.length == 0) {
                    stat = conn.createStatement();
                    result = stat.execute(sql);
                } else {
                    PreparedStatement prep = conn.prepareStatement(sql);
                    stat = prep;
                    int j = 0;
                    while (j < params.length) {
                        prep.setObject(j + 1, params[j]);
                        ++j;
                    }
                    result = prep.execute();
                }
                if (result) {
                    ResultSet rs = stat.getResultSet();
                    s = "rs: " + TestJoin.readResult(rs);
                } else {
                    s = "updateCount: " + stat.getUpdateCount();
                }
            }
            catch (SQLException e) {
                s = "exception";
            }
            if (i == 0) {
                first = s;
            } else if (!ignoreDifference && !((String)s).equals(first)) {
                this.fail("FAIL s:" + (String)s + " first:" + first + " sql:" + sql);
            }
            ++i;
        }
    }

    private static String readResult(ResultSet rs) throws SQLException {
        int i;
        StringBuilder b = new StringBuilder();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        int i2 = 0;
        while (i2 < columnCount) {
            if (i2 > 0) {
                b.append(",");
            }
            b.append(StringUtils.toUpperEnglish(meta.getColumnLabel(i2 + 1)));
            ++i2;
        }
        b.append(":\n");
        Object result = b.toString();
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            b = new StringBuilder();
            i = 0;
            while (i < columnCount) {
                if (i > 0) {
                    b.append(",");
                }
                b.append(rs.getString(i + 1));
                ++i;
            }
            list.add(b.toString());
        }
        Collections.sort(list);
        i = 0;
        while (i < list.size()) {
            result = (String)result + (String)list.get(i) + "\n";
            ++i;
        }
        return result;
    }
}

