/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestDb;
import org.h2.test.synth.OutputCatcher;
import org.h2.test.utils.SelfDestructor;

public class TestKillRestart
extends TestDb {
    @Override
    public boolean isEnabled() {
        if (this.config.networked) {
            return false;
        }
        return this.getBaseDir().indexOf(58) <= 0;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("killRestart");
        String url = this.getURL("killRestart", true);
        String user = this.getUser();
        String password = this.getPassword();
        String selfDestruct = SelfDestructor.getPropertyString(60);
        String[] procDef = new String[]{TestKillRestart.getJVM(), selfDestruct, "-cp", this.getClassPath(), "-ea", this.getClass().getName(), "-url", url, "-user", user, "-password", password};
        int len = this.getSize(2, 15);
        int i = 0;
        while (i < len) {
            Process p = new ProcessBuilder(new String[0]).redirectErrorStream(true).command(procDef).start();
            InputStream in = p.getInputStream();
            OutputCatcher catcher = new OutputCatcher(in);
            catcher.start();
            while (true) {
                String s;
                if ((s = catcher.readLine(60000L)) == null) {
                    this.fail("No reply from process");
                    continue;
                }
                if (!s.startsWith("#")) {
                    this.fail("Expected: #..., got: " + s);
                    continue;
                }
                if (s.startsWith("#Running")) break;
                if (!s.startsWith("#Fail")) continue;
                this.fail("Failed: " + s);
            }
            Thread.sleep(100L);
            this.printTime("killing: " + i);
            p.destroy();
            TestKillRestart.waitForTimeout(p);
            ++i;
        }
        this.deleteDb("killRestart");
    }

    private static void waitForTimeout(final Process p) throws InterruptedException, IOException {
        long pid = TestKillRestart.getPidOfProcess(p);
        if (pid == -1L) {
            p.waitFor();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread("waitForTimeout"){

            @Override
            public void run() {
                try {
                    p.waitFor();
                    latch.countDown();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
        if (!latch.await(2L, TimeUnit.MINUTES)) {
            String[] procDef = new String[]{"jstack", "-F", "-m", "-l", "" + pid};
            new ProcessBuilder(new String[0]).redirectErrorStream(true).command(procDef).start();
            OutputCatcher catcher = new OutputCatcher(p.getInputStream());
            catcher.start();
            Thread.sleep(500L);
            throw new IOException("timed out waiting for subprocess to die");
        }
    }

    private static long getPidOfProcess(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            pid = -1L;
        }
        return pid;
    }

    public static void main(String ... args) {
        SelfDestructor.startCountdown(60);
        String driver = "org.h2.Driver";
        String url = "jdbc:h2:mem:test";
        String user = "sa";
        String password = "sa";
        int i = 0;
        while (i < args.length) {
            if ("-url".equals(args[i])) {
                url = args[++i];
            } else if ("-driver".equals(args[i])) {
                driver = args[++i];
            } else if ("-user".equals(args[i])) {
                user = args[++i];
            } else if ("-password".equals(args[i])) {
                password = args[++i];
            }
            ++i;
        }
        System.out.println("#Started; driver: " + driver + " url: " + url + " user: " + user + " password: " + password);
        try {
            Class.forName(driver);
            System.out.println("#Opening...");
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID IDENTITY, NAME VARCHAR)");
            stat.execute("CREATE TABLE IF NOT EXISTS TEST2(ID IDENTITY, NAME VARCHAR)");
            ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
            while (rs.next()) {
                rs.getLong("ID");
                rs.getString("NAME");
            }
            rs = stat.executeQuery("SELECT * FROM TEST2");
            while (rs.next()) {
                rs.getLong("ID");
                rs.getString("NAME");
            }
            stat.execute("DROP ALL OBJECTS DELETE FILES");
            System.out.println("#Closing with delete...");
            conn.close();
            System.out.println("#Starting...");
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            stat.execute("DROP ALL OBJECTS");
            stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
            stat.execute("CREATE TABLE TEST2(ID IDENTITY, NAME VARCHAR)");
            stat.execute("CREATE TABLE TEST_META(ID INT)");
            PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(NAME) VALUES(?)");
            PreparedStatement prep2 = conn.prepareStatement("INSERT INTO TEST2(NAME) VALUES(?)");
            Random r = new Random(0L);
            int i2 = 0;
            while (i2 < 2000) {
                if (i2 == 100) {
                    System.out.println("#Running...");
                }
                if (r.nextInt(100) < 10) {
                    conn.createStatement().execute("ALTER TABLE TEST_META ALTER COLUMN ID INT DEFAULT 10");
                }
                if (r.nextBoolean()) {
                    if (r.nextBoolean()) {
                        prep.setString(1, new String(new char[r.nextInt(30) * 10]));
                        prep.execute();
                    } else {
                        prep2.setString(1, new String(new char[r.nextInt(30) * 10]));
                        prep2.execute();
                    }
                } else if (r.nextBoolean()) {
                    conn.createStatement().execute("UPDATE TEST SET NAME = NULL");
                } else {
                    conn.createStatement().execute("UPDATE TEST2 SET NAME = NULL");
                }
                ++i2;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
            System.out.println("#Fail: " + e.toString());
        }
    }
}

