/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.synth.OutputCatcher;
import org.h2.test.utils.SelfDestructor;
import org.h2.tools.Backup;

public class TestKillRestartMulti
extends TestDb {
    private static final int CHILD_READ_TIMEOUT_MS = 420000;
    private static final int CHILD_SELFDESTRUCT_TIMEOUT_MINS = 5;
    private String driver = "org.h2.Driver";
    private String url;
    private String user = "sa";
    private String password = "sa";
    private final ArrayList<Connection> connections = new ArrayList();
    private final ArrayList<String> tables = new ArrayList();
    private int openCount;

    public static void main(String ... args) throws Exception {
        if (args != null && args.length > 0) {
            SelfDestructor.startCountdown(5);
            new TestKillRestartMulti().test(args);
        } else {
            TestBase.createCaller().init().testFromMain();
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.config.networked) {
            return false;
        }
        return this.getBaseDir().indexOf(58) <= 0;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("killRestartMulti");
        this.url = this.getURL("killRestartMulti;RETENTION_TIME=0", true);
        this.user = this.getUser();
        this.password = this.getPassword();
        String selfDestruct = SelfDestructor.getPropertyString(60);
        ProcessBuilder pb = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.INHERIT).command(TestKillRestartMulti.getJVM(), selfDestruct, "-cp", this.getClassPath(), "-ea", this.getClass().getName(), "-url", this.url, "-user", this.user, "-password", this.password);
        this.deleteDb("killRestartMulti");
        int len = this.getSize(3, 10);
        Random random = new Random();
        int i = 0;
        while (i < len) {
            Process p = pb.start();
            InputStream in = p.getInputStream();
            OutputCatcher catcher = new OutputCatcher(in);
            catcher.start();
            while (true) {
                String a;
                String s;
                if ((s = catcher.readLine(420000L)) == null) {
                    this.fail("No reply from process");
                    continue;
                }
                if (!s.startsWith("#")) {
                    this.fail("Expected: #..., got: " + s);
                    continue;
                }
                if (s.startsWith("#Running")) break;
                if (s.startsWith("#Info") || !s.startsWith("#Fail")) continue;
                System.err.println(s);
                while ((a = catcher.readLine(420000L)) != null && !"#End".endsWith(a)) {
                    System.err.println("   " + a);
                }
                this.fail("Failed: " + s);
            }
            int sleep = 10 + random.nextInt(100);
            Thread.sleep(sleep);
            this.printTime("killing: " + i);
            p.destroy();
            this.printTime("killing, waiting for: " + i);
            p.waitFor();
            this.printTime("killing, dead: " + i);
            String backup = this.getBaseDir() + "/killRestartMulti-" + System.currentTimeMillis() + ".zip";
            try {
                Backup.execute(backup, this.getBaseDir(), "killRestartMulti", true);
                Connection conn = null;
                int j = 0;
                while (true) {
                    try {
                        conn = this.openConnection();
                    }
                    catch (SQLException e2) {
                        if (e2.getErrorCode() != 90020 || j >= 3) {
                            throw e2;
                        }
                        Thread.sleep(100L);
                        ++j;
                        continue;
                    }
                    break;
                }
                TestKillRestartMulti.testConsistent(conn);
                Statement stat = conn.createStatement();
                stat.execute("DROP ALL OBJECTS");
                conn.close();
                conn = this.openConnection();
                conn.close();
                FileUtils.delete(backup);
            }
            catch (SQLException e) {
                FileUtils.move(backup, backup + ".error");
                throw e;
            }
            ++i;
        }
        this.deleteDb("killRestartMulti");
    }

    private void test(String ... args) {
        int i = 0;
        while (i < args.length) {
            if ("-url".equals(args[i])) {
                this.url = args[++i];
            } else if ("-driver".equals(args[i])) {
                this.driver = args[++i];
            } else if ("-user".equals(args[i])) {
                this.user = args[++i];
            } else if ("-password".equals(args[i])) {
                this.password = args[++i];
            }
            ++i;
        }
        System.out.println("#Started; driver: " + this.driver + " url: " + this.url + " user: " + this.user + " password: " + this.password);
        try {
            System.out.println("#Starting...");
            Random random = new Random();
            boolean wasRunning = false;
            int i2 = 0;
            while (i2 < 3000) {
                String table;
                Statement stat;
                Connection conn;
                if (i2 > 1000 && this.connections.size() > 1 && this.tables.size() > 1) {
                    System.out.println("#Running connections: " + this.connections.size() + " tables: " + this.tables.size());
                    wasRunning = true;
                }
                if (this.connections.size() < 1) {
                    this.openConnection();
                }
                if (this.tables.size() < 1) {
                    this.createTable(random);
                }
                int p = random.nextInt(100);
                if ((p -= 2) <= 0) {
                    if (this.connections.size() < 5) {
                        this.openConnection();
                    }
                } else if (--p <= 0) {
                    if (this.connections.size() > 1) {
                        conn = this.connections.remove(random.nextInt(this.connections.size()));
                        if (random.nextBoolean()) {
                            conn.close();
                        }
                    }
                } else if ((p -= 10) <= 0) {
                    this.createTable(random);
                } else if ((p -= 20) <= 0) {
                    if (this.tables.size() > 0) {
                        conn = this.connections.get(random.nextInt(this.connections.size()));
                        stat = conn.createStatement();
                        table = this.tables.get(random.nextInt(this.tables.size()));
                        if (random.nextBoolean()) {
                            stat.execute("INSERT INTO " + table + "(NAME) SELECT 'Hello ' || X FROM SYSTEM_RANGE(0, 20)");
                        } else if (random.nextBoolean()) {
                            stat.execute("UPDATE " + table + " SET NAME='Hallo Welt'");
                        } else {
                            stat.execute("DELETE FROM " + table);
                        }
                    }
                } else if ((p -= 5) < 0) {
                    if (this.tables.size() > 0) {
                        conn = this.connections.get(random.nextInt(this.connections.size()));
                        stat = conn.createStatement();
                        table = this.tables.get(random.nextInt(this.tables.size()));
                        if (random.nextBoolean()) {
                            stat.execute("TRUNCATE TABLE " + table);
                        } else {
                            stat.execute("DROP TABLE " + table);
                            System.out.println("#Info table dropped: " + table);
                            this.tables.remove(table);
                        }
                    }
                } else if ((p -= 30) <= 0) {
                    if (this.tables.size() > 0) {
                        conn = this.connections.get(random.nextInt(this.connections.size()));
                        stat = conn.createStatement();
                        table = this.tables.get(random.nextInt(this.tables.size()));
                        stat.execute("INSERT INTO " + table + "(NAME) VALUES('Hello World')");
                    }
                } else if (this.tables.size() > 0) {
                    conn = this.connections.get(random.nextInt(this.connections.size()));
                    stat = conn.createStatement();
                    table = this.tables.get(random.nextInt(this.tables.size()));
                    stat.execute("DELETE FROM " + table + " WHERE ID = SELECT MIN(ID) FROM " + table);
                }
                ++i2;
            }
            System.out.println("#Fail: end " + wasRunning);
            System.out.println("#End");
        }
        catch (Throwable e) {
            System.out.println("#Fail: openCount=" + this.openCount + " url=" + this.url + " " + e.toString());
            e.printStackTrace(System.out);
            System.out.println("#End");
        }
    }

    private Connection openConnection() throws Exception {
        Class.forName(this.driver);
        ++this.openCount;
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        this.connections.add(conn);
        return conn;
    }

    private void createTable(Random random) throws SQLException {
        Connection conn = this.connections.get(random.nextInt(this.connections.size()));
        Statement stat = conn.createStatement();
        String table = "TEST" + random.nextInt(10);
        try {
            stat.execute("CREATE TABLE " + table + "(ID IDENTITY, NAME VARCHAR)");
            System.out.println("#Info table created: " + table);
            this.tables.add(table);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 42101) {
                System.out.println("#Info table already exists: " + table);
                if (!this.tables.contains(table)) {
                    this.tables.add(table);
                }
            }
            throw e;
        }
    }

    private static void testConsistent(Connection conn) throws SQLException {
        int i = 0;
        while (i < 20) {
            block5: {
                Statement stat = conn.createStatement();
                try {
                    ResultSet rs = stat.executeQuery("SELECT * FROM TEST" + i);
                    while (rs.next()) {
                        rs.getLong("ID");
                        rs.getString("NAME");
                    }
                    rs = stat.executeQuery("SELECT * FROM TEST" + i + " ORDER BY ID");
                    while (rs.next()) {
                        rs.getLong("ID");
                        rs.getString("NAME");
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102 || e.getErrorCode() == 42104 || e.getErrorCode() == 42103) break block5;
                    throw e;
                }
            }
            ++i;
        }
    }
}

