/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.FilePathDebug;

public class TestPowerOffFs2
extends TestDb {
    private static final String USER = "sa";
    private static final String PASSWORD = "sa";
    private FilePathDebug fs;
    private String url;
    private final ArrayList<Connection> connections = new ArrayList();
    private final ArrayList<String> tables = new ArrayList();

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.fs = FilePathDebug.register();
        this.url = "jdbc:h2:debug:memFS:powerOffFs;FILE_LOCK=NO;TRACE_LEVEL_FILE=0;WRITE_DELAY=0;CACHE_SIZE=32";
        int i = 0;
        while (true) {
            this.test(i);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void test(int x) throws SQLException {
        block8: {
            System.out.println("x:" + x);
            this.deleteDb("memFS:", null);
            try {
                this.testCrash(x);
                this.fail();
                break block8;
            }
            catch (SQLException e) {
                if (e.toString().indexOf("Simulated") < 0) {
                    throw e;
                }
                ** for (c : this.connections)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stat = c.createStatement();
                    stat.execute("shutdown immediately");
                }
                catch (Exception var5_7) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Exception var5_8) {
                    // empty catch block
                }
                continue;
            }
        }
        this.fs.setPowerOffCount(0);
        conn = this.openConnection();
        TestPowerOffFs2.testConsistent(conn);
        conn.close();
    }

    private void testCrash(int x) throws SQLException {
        this.connections.clear();
        this.tables.clear();
        Random random = new Random(x);
        int i = 0;
        while (true) {
            String table;
            Statement stat;
            Connection conn;
            if (i > 200 && this.connections.size() > 1 && this.tables.size() > 1) {
                this.fs.setPowerOffCount(100);
            }
            if (this.connections.size() < 1) {
                this.openConnection();
            }
            if (this.tables.size() < 1) {
                this.createTable(random);
            }
            int p = random.nextInt(100);
            if ((p -= 2) <= 0) {
                if (this.connections.size() < 5) {
                    this.openConnection();
                }
            } else if (--p <= 0) {
                if (this.connections.size() > 1) {
                    conn = this.connections.remove(random.nextInt(this.connections.size()));
                    conn.close();
                }
            } else if ((p -= 10) <= 0) {
                this.createTable(random);
            } else if ((p -= 20) <= 0) {
                if (this.tables.size() > 0) {
                    conn = this.connections.get(random.nextInt(this.connections.size()));
                    stat = conn.createStatement();
                    table = this.tables.get(random.nextInt(this.tables.size()));
                    if (random.nextBoolean()) {
                        stat.execute("INSERT INTO " + table + "(NAME) SELECT 'Hello ' || X FROM SYSTEM_RANGE(0, 20)");
                    } else if (random.nextBoolean()) {
                        stat.execute("UPDATE " + table + " SET NAME='Hallo Welt'");
                    } else {
                        stat.execute("DELETE FROM " + table);
                    }
                }
            } else if ((p -= 5) < 0) {
                if (this.tables.size() > 0) {
                    conn = this.connections.get(random.nextInt(this.connections.size()));
                    stat = conn.createStatement();
                    table = this.tables.get(random.nextInt(this.tables.size()));
                    if (random.nextBoolean()) {
                        stat.execute("TRUNCATE TABLE " + table);
                    } else {
                        stat.execute("DROP TABLE " + table);
                        this.tables.remove(table);
                    }
                }
            } else if ((p -= 30) <= 0) {
                if (this.tables.size() > 0) {
                    conn = this.connections.get(random.nextInt(this.connections.size()));
                    stat = conn.createStatement();
                    table = this.tables.get(random.nextInt(this.tables.size()));
                    int spaces = random.nextInt(4) * 30;
                    if (random.nextInt(15) == 2) {
                        spaces *= 100;
                    }
                    int name = random.nextInt(20);
                    stat.execute("INSERT INTO " + table + "(NAME) VALUES('" + name + "' || space( " + spaces + " ))");
                }
            } else if (this.tables.size() > 0) {
                conn = this.connections.get(random.nextInt(this.connections.size()));
                stat = conn.createStatement();
                table = this.tables.get(random.nextInt(this.tables.size()));
                stat.execute("DELETE FROM " + table + " WHERE ID = SELECT MIN(ID) FROM " + table);
            }
            ++i;
        }
    }

    private Connection openConnection() throws SQLException {
        Connection conn = DriverManager.getConnection(this.url, "sa", "sa");
        this.connections.add(conn);
        return conn;
    }

    private void createTable(Random random) throws SQLException {
        Connection conn = this.connections.get(random.nextInt(this.connections.size()));
        Statement stat = conn.createStatement();
        String table = "TEST" + random.nextInt(10);
        try {
            stat.execute("CREATE TABLE " + table + "(ID IDENTITY, NAME VARCHAR)");
            if (random.nextBoolean()) {
                stat.execute("CREATE INDEX IDX_" + table + " ON " + table + "(NAME)");
            }
            this.tables.add(table);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 42101) {
                if (!this.tables.contains(table)) {
                    this.tables.add(table);
                }
            }
            throw e;
        }
    }

    private static void testConsistent(Connection conn) throws SQLException {
        int i = 0;
        while (i < 20) {
            block5: {
                Statement stat = conn.createStatement();
                try {
                    ResultSet rs = stat.executeQuery("SELECT * FROM TEST" + i);
                    while (rs.next()) {
                        rs.getLong("ID");
                        rs.getString("NAME");
                    }
                    rs = stat.executeQuery("SELECT * FROM TEST" + i + " ORDER BY ID");
                    while (rs.next()) {
                        rs.getLong("ID");
                        rs.getString("NAME");
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102 || e.getErrorCode() == 42104 || e.getErrorCode() == 42103) break block5;
                    throw e;
                }
            }
            ++i;
        }
    }
}

