/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.synth.BnfRandom;
import org.h2.util.MathUtils;

public class TestRandomSQL
extends TestDb {
    private int success;
    private int total;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked;
    }

    @Override
    public void test() throws Exception {
        int len = this.getSize(2, 6);
        int a = 0;
        while (a < len) {
            int s = MathUtils.randomInt(Integer.MAX_VALUE);
            this.testCase(s);
            ++a;
        }
    }

    private void testWithSeed(int seed) throws Exception {
        block11: {
            Connection conn = null;
            try {
                conn = this.getConnection(this.getDatabaseName(seed));
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("HY000")) {
                    TestBase.logError("new TestRandomSQL().init(test).testCase(" + seed + ");  // FAIL: " + e.toString() + " sql: connect", e);
                }
                conn = this.getConnection(this.getDatabaseName(seed));
            }
            Statement stat = conn.createStatement();
            BnfRandom bnfRandom = new BnfRandom();
            bnfRandom.setSeed(seed);
            int i = 0;
            while (i < bnfRandom.getStatementCount()) {
                block10: {
                    String sql = bnfRandom.getRandomSQL();
                    if (sql != null) {
                        try {
                            Thread.yield();
                            ++this.total;
                            if (this.total % 100 == 0) {
                                this.printTime("total: " + this.total + " success: " + 100 * this.success / this.total + "%");
                            }
                            stat.execute(sql);
                            ++this.success;
                        }
                        catch (SQLException e) {
                            if (!e.getSQLState().equals("HY000")) break block10;
                            TestBase.logError("new TestRandomSQL().init(test).testCase(" + seed + ");  // FAIL: " + e.toString() + " sql: " + sql, e);
                        }
                    }
                }
                ++i;
            }
            try {
                conn.close();
                conn = this.getConnection(this.getDatabaseName(seed));
                conn.createStatement().execute("shutdown immediately");
                conn.close();
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("HY000")) break block11;
                TestBase.logError("new TestRandomSQL().init(test).testCase(" + seed + ");  // FAIL: " + e.toString() + " sql: conn.close", e);
            }
        }
    }

    private void testCase(int seed) throws Exception {
        String old = SysProperties.getScriptDirectory();
        try {
            System.setProperty("h2.scriptDirectory", this.getBaseDir() + "/" + this.getTestName());
            this.printTime("seed: " + seed);
            this.deleteDb(seed);
            this.testWithSeed(seed);
        }
        finally {
            System.setProperty("h2.scriptDirectory", old);
        }
        this.deleteDb(seed);
    }

    private String getDatabaseName(int seed) {
        return this.getTestName() + "/db" + seed;
    }

    private void deleteDb(int seed) {
        FileUtils.delete(this.getDatabaseName(seed));
    }
}

