/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestThreads
extends TestDb
implements Runnable {
    private static final int INSERT = 0;
    private static final int UPDATE = 1;
    private static final int DELETE = 2;
    private static final int SELECT_ONE = 3;
    private static final int SELECT_ALL = 4;
    private static final int CHECKPOINT = 5;
    private static final int RECONNECT = 6;
    private static final int OP_TYPES = 7;
    private int maxId = 1;
    private volatile boolean stop;
    private TestThreads master;
    private int type;
    private String table;
    private final Random random = new Random();

    public TestThreads() {
    }

    TestThreads(TestThreads master, int type, String table) {
        this.master = master;
        this.type = type;
        this.table = table;
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("threads");
        Connection conn = this.getConnection("threads;MAX_LOG_SIZE=1");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST_A(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE TABLE TEST_B(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE TABLE TEST_C(ID INT PRIMARY KEY, NAME VARCHAR)");
        int len = 1000;
        TestThreads.insertRows(conn, "TEST_A", len);
        TestThreads.insertRows(conn, "TEST_B", len);
        TestThreads.insertRows(conn, "TEST_C", len);
        this.maxId = len;
        int threadCount = 4;
        Thread[] threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            String t = this.random.nextBoolean() ? null : this.getRandomTable();
            int op = this.random.nextInt(7);
            op = i % 2 == 0 ? 6 : 5;
            threads[i] = new Thread(new TestThreads(this, op, t));
            ++i;
        }
        i = 0;
        while (i < threadCount) {
            threads[i].start();
            ++i;
        }
        Thread.sleep(10000L);
        this.stop = true;
        i = 0;
        while (i < threadCount) {
            threads[i].join();
            ++i;
        }
        conn.close();
        conn = this.getConnection("threads");
        TestThreads.checkTable(conn, "TEST_A");
        TestThreads.checkTable(conn, "TEST_B");
        TestThreads.checkTable(conn, "TEST_C");
        conn.close();
    }

    private static void insertRows(Connection conn, String tableName, int len) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?, 'Hi')");
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
    }

    private static void checkTable(Connection conn, String tableName) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM " + tableName + " ORDER BY ID");
        while (rs.next()) {
            int id = rs.getInt(1);
            String name = rs.getString(2);
            System.out.println("id=" + id + " name=" + name);
        }
    }

    private int getMaxId() {
        return this.maxId;
    }

    private synchronized int incrementMaxId() {
        return this.maxId++;
    }

    private String getRandomTable() {
        return "TEST_" + (char)(65 + this.random.nextInt(3));
    }

    @Override
    public void run() {
        try {
            String t = this.table == null ? this.getRandomTable() : this.table;
            Connection conn = this.master.getConnection("threads");
            Statement stat = conn.createStatement();
            int max = this.master.getMaxId();
            int rid = this.random.nextInt(max);
            while (!this.master.stop) {
                switch (this.type) {
                    case 0: {
                        max = this.master.incrementMaxId();
                        stat.execute("INSERT INTO " + t + "(ID, NAME) VALUES(" + max + ", 'Hello')");
                        break;
                    }
                    case 1: {
                        stat.execute("UPDATE " + t + " SET NAME='World " + rid + "' WHERE ID=" + rid);
                        break;
                    }
                    case 2: {
                        stat.execute("DELETE FROM " + t + " WHERE ID=" + rid);
                        break;
                    }
                    case 4: {
                        ResultSet rs = stat.executeQuery("SELECT * FROM " + t + " ORDER BY ID");
                        while (rs.next()) {
                        }
                        break;
                    }
                    case 3: {
                        ResultSet rs = stat.executeQuery("SELECT * FROM " + t + " WHERE ID=" + rid);
                        while (rs.next()) {
                        }
                        break;
                    }
                    case 5: {
                        stat.execute("CHECKPOINT");
                        break;
                    }
                    case 6: {
                        conn.close();
                        conn = this.master.getConnection("threads");
                    }
                }
            }
            conn.close();
        }
        catch (Exception e) {
            TestBase.logError("error", e);
        }
    }
}

