/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.thread;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.synth.thread.TestMulti;
import org.h2.test.synth.thread.TestMultiThread;

public class TestMultiNews
extends TestMultiThread {
    private static final String PREFIX_URL = "http://feeds.wizbangblog.com/WizbangFullFeed?m=";
    private static final int LEN = 10000;
    private Connection conn;

    TestMultiNews(TestMulti base) throws SQLException {
        super(base);
        this.conn = base.getConnection();
    }

    @Override
    void operation() throws SQLException {
        if (this.random.nextInt(10) == 0) {
            this.conn.close();
            this.conn = this.base.getConnection();
        } else if (this.random.nextInt(10) == 0) {
            if (this.random.nextBoolean()) {
                this.conn.commit();
            } else {
                this.conn.rollback();
            }
        } else if (this.random.nextInt(10) == 0) {
            this.conn.setAutoCommit(this.random.nextBoolean());
        } else if (this.random.nextBoolean()) {
            PreparedStatement prep = this.random.nextBoolean() ? this.conn.prepareStatement("SELECT * FROM NEWS WHERE LINK = ?") : this.conn.prepareStatement("SELECT * FROM NEWS WHERE VALUE = ?");
            prep.setString(1, PREFIX_URL + this.random.nextInt(10000));
            ResultSet rs = prep.executeQuery();
            if (!rs.next()) {
                throw new SQLException("expected one row, got none");
            }
            if (rs.next()) {
                throw new SQLException("expected one row, got more");
            }
        } else {
            PreparedStatement prep = this.conn.prepareStatement("UPDATE NEWS SET STATE = ? WHERE FID = ?");
            prep.setInt(1, this.random.nextInt(100));
            prep.setInt(2, this.random.nextInt(10000));
            int count = prep.executeUpdate();
            if (count != 1) {
                throw new SQLException("expected one row, got " + count);
            }
        }
    }

    @Override
    void begin() {
    }

    @Override
    void end() throws SQLException {
        this.conn.close();
    }

    @Override
    void finalTest() {
    }

    @Override
    void first() throws SQLException {
        Connection c = this.base.getConnection();
        Statement stat = c.createStatement();
        stat.execute("CREATE TABLE TEST (ID IDENTITY, NAME VARCHAR)");
        stat.execute("CREATE TABLE NEWS(FID NUMERIC(19) PRIMARY KEY, COMMENTS LONGVARCHAR, LINK VARCHAR(255), STATE INTEGER, VALUE VARCHAR(255))");
        stat.execute("CREATE INDEX IF NOT EXISTS NEWS_GUID_VALUE_INDEX ON NEWS(VALUE)");
        stat.execute("CREATE INDEX IF NOT EXISTS NEWS_LINK_INDEX ON NEWS(LINK)");
        stat.execute("CREATE INDEX IF NOT EXISTS NEWS_STATE_INDEX ON NEWS(STATE)");
        PreparedStatement prep = c.prepareStatement("INSERT INTO NEWS (FID, COMMENTS, LINK, STATE, VALUE) VALUES (?, ?, ?, ?, ?) ");
        PreparedStatement prep2 = c.prepareStatement("INSERT INTO TEST (NAME) VALUES (?)");
        int i = 0;
        while (i < 10000) {
            int x = this.random.nextInt(10) * 128;
            StringBuilder buff = new StringBuilder();
            while (buff.length() < x) {
                buff.append("Test ");
                buff.append(buff.length());
                buff.append(' ');
            }
            String comment = buff.toString();
            prep.setInt(1, i);
            prep.setString(2, comment);
            prep.setString(3, PREFIX_URL + i);
            prep.setInt(4, 0);
            prep.setString(5, PREFIX_URL + i);
            prep.execute();
            prep2.setString(1, comment);
            prep2.execute();
            ++i;
        }
    }
}

