/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.thread;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.test.synth.thread.TestMulti;
import org.h2.test.synth.thread.TestMultiThread;

public class TestMultiNewsSimple
extends TestMultiThread {
    private static int newsCount = 10000;
    private final Connection conn;

    TestMultiNewsSimple(TestMulti base) throws SQLException {
        super(base);
        this.conn = base.getConnection();
    }

    private static int getNewsCount() {
        return newsCount;
    }

    @Override
    void first() throws SQLException {
        Connection c = this.base.getConnection();
        c.createStatement().execute("create table news(id identity, state int default 0, text varchar default '')");
        PreparedStatement prep = c.prepareStatement("insert into news() values()");
        int i = 0;
        while (i < newsCount) {
            prep.executeUpdate();
            ++i;
        }
        c.createStatement().execute("update news set text = 'Text' || id");
        c.close();
    }

    @Override
    void begin() {
    }

    @Override
    void end() throws SQLException {
        this.conn.close();
    }

    @Override
    void operation() throws SQLException {
        if (this.random.nextInt(10) == 0) {
            this.conn.setAutoCommit(this.random.nextBoolean());
        } else if (this.random.nextInt(10) == 0) {
            if (this.random.nextBoolean()) {
                this.conn.commit();
            }
        } else if (this.random.nextBoolean()) {
            PreparedStatement prep = this.conn.prepareStatement("update news set state = ? where id = ?");
            prep.setInt(1, this.random.nextInt(TestMultiNewsSimple.getNewsCount()));
            prep.setInt(2, this.random.nextInt(10));
            prep.execute();
        } else {
            PreparedStatement prep = this.conn.prepareStatement("select * from news where id = ?");
            prep.setInt(1, this.random.nextInt(TestMultiNewsSimple.getNewsCount()));
            ResultSet rs = prep.executeQuery();
            if (!rs.next()) {
                System.out.println("No row found");
            }
            if (rs.next()) {
                System.out.println("Multiple rows found");
            }
        }
    }

    @Override
    void finalTest() {
    }
}

