/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.thread;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import org.h2.test.synth.thread.TestMulti;
import org.h2.test.synth.thread.TestMultiThread;

public class TestMultiOrder
extends TestMultiThread {
    private static int customerCount;
    private static int orderCount;
    private static int orderLineCount;
    private static final String[] ITEMS;
    private Connection conn;
    private PreparedStatement insertLine;

    static {
        ITEMS = new String[]{"Apples", "Oranges", "Bananas", "Coffee"};
    }

    TestMultiOrder(TestMulti base) throws SQLException {
        super(base);
        this.conn = base.getConnection();
    }

    @Override
    void begin() throws SQLException {
        this.insertLine = this.conn.prepareStatement("insert into orderLine(order_id, line_id, text, amount) values(?, ?, ?, ?)");
        this.insertCustomer();
    }

    @Override
    void end() throws SQLException {
        this.conn.close();
    }

    @Override
    void operation() throws SQLException {
        if (this.random.nextInt(10) == 0) {
            this.insertCustomer();
        } else {
            this.insertOrder();
        }
    }

    private void insertOrder() throws SQLException {
        PreparedStatement prep = this.conn.prepareStatement("insert into orders(customer_id , total) values(?, ?)");
        prep.setInt(1, this.random.nextInt(TestMultiOrder.getCustomerCount()));
        BigDecimal total = new BigDecimal("0");
        prep.setBigDecimal(2, total);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        rs.next();
        int orderId = rs.getInt(1);
        int lines = this.random.nextInt(20);
        int i = 0;
        while (i < lines) {
            this.insertLine.setInt(1, orderId);
            this.insertLine.setInt(2, i);
            this.insertLine.setString(3, ITEMS[this.random.nextInt(ITEMS.length)]);
            BigDecimal amount = new BigDecimal(this.random.nextInt(100) + "." + this.random.nextInt(10));
            this.insertLine.setBigDecimal(4, amount);
            total = total.add(amount);
            this.insertLine.addBatch();
            ++i;
        }
        this.insertLine.executeBatch();
        TestMultiOrder.increaseOrderLines(lines);
        prep = this.conn.prepareStatement("update orders set total = ? where id = ?");
        prep.setBigDecimal(1, total);
        prep.setInt(2, orderId);
        TestMultiOrder.increaseOrders();
        prep.execute();
    }

    private void insertCustomer() throws SQLException {
        PreparedStatement prep = this.conn.prepareStatement("insert into customer(id, name) values(?, ?)");
        int customerId = TestMultiOrder.getNextCustomerId();
        prep.setInt(1, customerId);
        prep.setString(2, TestMultiOrder.getString(customerId));
        prep.execute();
    }

    private static String getString(int id) {
        StringBuilder buff = new StringBuilder();
        Random rnd = new Random(id);
        int len = rnd.nextInt(40);
        int i = 0;
        while (i < len) {
            String s = "bcdfghklmnprstwz";
            char c = s.charAt(rnd.nextInt(s.length()));
            buff.append(i == 0 ? Character.toUpperCase(c) : c);
            s = "aeiou  ";
            buff.append(s.charAt(rnd.nextInt(s.length())));
            ++i;
        }
        return buff.toString();
    }

    private static synchronized int getNextCustomerId() {
        return customerCount++;
    }

    private static synchronized int increaseOrders() {
        return orderCount++;
    }

    private static synchronized int increaseOrderLines(int count) {
        return orderLineCount += count;
    }

    private static int getCustomerCount() {
        return customerCount;
    }

    @Override
    void first() throws SQLException {
        Connection c = this.base.getConnection();
        c.createStatement().execute("drop table customer if exists");
        c.createStatement().execute("drop table orders if exists");
        c.createStatement().execute("drop table orderLine if exists");
        c.createStatement().execute("create table customer(id int primary key, name varchar, account decimal)");
        c.createStatement().execute("create table orders(id int generated by default as identity primary key, customer_id int, total decimal)");
        c.createStatement().execute("create table orderLine(order_id int, line_id int, text varchar, amount decimal, primary key(order_id, line_id))");
        c.close();
    }

    @Override
    void finalTest() throws SQLException {
        this.conn = this.base.getConnection();
        ResultSet rs = this.conn.createStatement().executeQuery("select count(*) from customer");
        rs.next();
        this.base.assertEquals(customerCount, rs.getInt(1));
        rs = this.conn.createStatement().executeQuery("select count(*) from orders");
        rs.next();
        this.base.assertEquals(orderCount, rs.getInt(1));
        rs = this.conn.createStatement().executeQuery("select count(*) from orderLine");
        rs.next();
        this.base.assertEquals(orderLineCount, rs.getInt(1));
        this.conn.close();
    }
}

