/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.todo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.DeleteDbFiles;
import org.h2.util.Profiler;

public class TestDropTableLarge {
    public static void main(String ... args) throws Exception {
        TestDropTableLarge.test();
    }

    private static void test() throws SQLException {
        DeleteDbFiles.execute("data", "test", true);
        Connection conn = DriverManager.getConnection("jdbc:h2:data/test");
        Statement stat = conn.createStatement();
        stat.execute("create table test1(id identity, name varchar)");
        stat.execute("create table test2(id identity, name varchar)");
        conn.setAutoCommit(true);
        PreparedStatement prep1 = conn.prepareStatement("insert into test1(name) values(space(255))");
        PreparedStatement prep2 = conn.prepareStatement("insert into test2(name) values(space(255))");
        int i = 0;
        while (i < 50000) {
            if (i % 7 != 0) {
                prep1.execute();
            } else {
                prep2.execute();
            }
            ++i;
        }
        Profiler prof = new Profiler();
        prof.startCollecting();
        stat.execute("DROP TABLE test1");
        prof.stopCollecting();
        System.out.println(prof.getTop(3));
        conn.close();
    }
}

