/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.todo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.tools.DeleteDbFiles;

public class TestUndoLogLarge {
    public static void main(String ... args) throws Exception {
        TestUndoLogLarge.test();
    }

    private static void test() throws SQLException {
        DeleteDbFiles.execute("data", "test", true);
        Connection conn = DriverManager.getConnection("jdbc:h2:data/test");
        Statement stat = conn.createStatement();
        stat.execute("set max_operation_memory 100");
        stat.execute("set max_memory_undo 100");
        stat.execute("create table test(id identity, name varchar)");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("insert into test(name) values(space(1024*1024))");
        long time = System.nanoTime();
        int i = 0;
        while (i < 2500) {
            prep.execute();
            long now = System.nanoTime();
            if (now > time + TimeUnit.SECONDS.toNanos(5L)) {
                System.out.println(i);
                time = now + TimeUnit.SECONDS.toNanos(5L);
            }
            ++i;
        }
        conn.rollback();
        conn.close();
    }
}

