/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.trace;

import java.math.BigDecimal;
import org.h2.test.trace.Statement;
import org.h2.util.StringUtils;

class Arg {
    private Class<?> clazz;
    private Object obj;
    private Statement stat;

    Arg(Class<?> clazz, Object obj) {
        this.clazz = clazz;
        this.obj = obj;
    }

    Arg(Statement stat) {
        this.stat = stat;
    }

    public String toString() {
        if (this.stat != null) {
            return this.stat.toString();
        }
        return Arg.quote(this.clazz, this.getValue());
    }

    void execute() throws Exception {
        if (this.stat != null) {
            this.obj = this.stat.execute();
            this.clazz = this.stat.getReturnClass();
            this.stat = null;
        }
    }

    Class<?> getValueClass() {
        return this.clazz;
    }

    Object getValue() {
        return this.obj;
    }

    private static String quote(Class<?> valueClass, Object value) {
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return StringUtils.quoteJavaString(value.toString());
        }
        if (valueClass == BigDecimal.class) {
            return "new BigDecimal(\"" + value.toString() + "\")";
        }
        if (valueClass.isArray()) {
            if (valueClass == String[].class) {
                return StringUtils.quoteJavaStringArray((String[])value);
            }
            if (valueClass == int[].class) {
                return StringUtils.quoteJavaIntArray((int[])value);
            }
        }
        return value.toString();
    }
}

