/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.trace;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.h2.test.trace.Arg;
import org.h2.test.trace.Player;
import org.h2.test.trace.Statement;
import org.h2.util.StringUtils;

class Parser {
    private static final int STRING = 0;
    private static final int NAME = 1;
    private static final int NUMBER = 2;
    private static final int SPECIAL = 3;
    private final Player player;
    private Statement stat;
    private final String line;
    private String token;
    private int tokenType;
    private int pos;

    private Parser(Player player, String line) {
        this.player = player;
        this.line = line;
        this.read();
    }

    static Statement parseStatement(Player player, String line) {
        Parser p = new Parser(player, line);
        p.parseStatement();
        return p.stat;
    }

    private Statement parseStatement() {
        this.stat = new Statement(this.player);
        String name = this.readToken();
        Object o = this.player.getObject(name);
        if (o == null) {
            if (this.readIf(".")) {
                this.parseStaticCall(name);
            } else {
                this.stat.setAssign(name, this.readToken());
                this.read("=");
                name = this.readToken();
                o = this.player.getObject(name);
                if (o != null) {
                    this.read(".");
                    this.parseCall(name, o, this.readToken());
                } else if (this.readIf(".")) {
                    this.parseStaticCall(name);
                }
            }
        } else {
            this.read(".");
            String methodName = this.readToken();
            this.parseCall(name, o, methodName);
        }
        return this.stat;
    }

    private void read() {
        while (this.line.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        int start = this.pos;
        char ch = this.line.charAt(this.pos);
        block0 : switch (ch) {
            case '\"': {
                this.tokenType = 0;
                ++this.pos;
                while (this.pos < this.line.length()) {
                    ch = this.line.charAt(this.pos);
                    if (ch == '\\') {
                        this.pos += 2;
                        continue;
                    }
                    if (ch == '\"') {
                        ++this.pos;
                        break block0;
                    }
                    ++this.pos;
                }
                break;
            }
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ';': 
            case '=': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this.tokenType = 3;
                ++this.pos;
                break;
            }
            default: {
                if (Character.isLetter(ch) || ch == '_') {
                    this.tokenType = 1;
                    ++this.pos;
                    while (Character.isLetterOrDigit(ch = this.line.charAt(this.pos)) || ch == '_') {
                        ++this.pos;
                    }
                } else {
                    if (ch != '-' && !Character.isDigit(ch)) break;
                    this.tokenType = 2;
                    ++this.pos;
                    while (Character.isDigit(ch = this.line.charAt(this.pos)) || ".+-eElLxabcdefABCDEF".indexOf(ch) >= 0) {
                        ++this.pos;
                    }
                    break block0;
                }
            }
        }
        this.token = this.line.substring(start, this.pos);
    }

    private boolean readIf(String s) {
        if (this.token.equals(s)) {
            this.read();
            return true;
        }
        return false;
    }

    private String readToken() {
        String s = this.token;
        this.read();
        return s;
    }

    private void read(String s) {
        if (!this.readIf(s)) {
            throw new RuntimeException("Expected: " + s + " got: " + this.token + " in " + this.line);
        }
    }

    private Arg parseValue() {
        if (this.tokenType == 0) {
            String s = this.readToken();
            s = StringUtils.javaDecode(s.substring(1, s.length() - 1));
            return new Arg(String.class, s);
        }
        if (this.tokenType == 2) {
            String number = this.readToken().toLowerCase();
            if (number.endsWith("f")) {
                Float v = Float.valueOf(Float.parseFloat(number));
                return new Arg(Float.TYPE, v);
            }
            if (number.endsWith("d") || number.indexOf(101) >= 0 || number.indexOf(46) >= 0) {
                Double v = Double.parseDouble(number);
                return new Arg(Double.TYPE, v);
            }
            if (number.endsWith("l")) {
                Long v = Long.parseLong(number.substring(0, number.length() - 1));
                return new Arg(Long.TYPE, v);
            }
            Integer v = Integer.parseInt(number);
            return new Arg(Integer.TYPE, v);
        }
        if (this.tokenType == 1) {
            if (this.readIf("true")) {
                return new Arg(Boolean.TYPE, Boolean.TRUE);
            }
            if (this.readIf("false")) {
                return new Arg(Boolean.TYPE, Boolean.FALSE);
            }
            if (this.readIf("null")) {
                throw new RuntimeException("Null: class not specified. Example: (java.lang.String)null");
            }
            if (this.readIf("new")) {
                if (this.readIf("String")) {
                    this.read("[");
                    this.read("]");
                    this.read("{");
                    ArrayList<Object> values = new ArrayList<Object>();
                    do {
                        values.add(this.parseValue().getValue());
                    } while (this.readIf(","));
                    this.read("}");
                    String[] list = values.toArray(new String[0]);
                    return new Arg(String[].class, list);
                }
                if (this.readIf("BigDecimal")) {
                    this.read("(");
                    BigDecimal value = new BigDecimal((String)this.parseValue().getValue());
                    this.read(")");
                    return new Arg(BigDecimal.class, value);
                }
                throw new RuntimeException("Unsupported constructor: " + this.readToken());
            }
            String name = this.readToken();
            Object obj = this.player.getObject(name);
            if (obj != null) {
                return new Arg(obj.getClass(), obj);
            }
            this.read(".");
            Statement outer = this.stat;
            this.stat = new Statement(this.player);
            this.parseStaticCall(name);
            Arg s = new Arg(this.stat);
            this.stat = outer;
            return s;
        }
        if (this.readIf("(")) {
            this.read("short");
            this.read(")");
            String number = this.readToken();
            return new Arg(Short.TYPE, Short.parseShort(number));
        }
        throw new RuntimeException("Value expected, got: " + this.readToken() + " in " + this.line);
    }

    private void parseCall(String objectName, Object o, String methodName) {
        this.stat.setMethodCall(objectName, o, methodName);
        ArrayList<Arg> args = new ArrayList<Arg>();
        this.read("(");
        while (!this.readIf(")")) {
            Arg p = this.parseValue();
            args.add(p);
            if (this.readIf(")")) break;
            this.read(",");
        }
        this.stat.setArgs(args);
    }

    private void parseStaticCall(String clazz) {
        String last = this.readToken();
        while (this.readIf(".")) {
            clazz = (String)clazz + (String)(last == null ? "" : "." + last);
            last = this.readToken();
        }
        String methodName = last;
        this.stat.setStaticCall((String)clazz);
        this.parseCall(null, null, methodName);
    }
}

