/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.trace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import org.h2.store.fs.FileUtils;
import org.h2.test.trace.Parser;
import org.h2.test.trace.Statement;

public class Player {
    private static final String[] IMPORTED_PACKAGES = new String[]{"", "java.lang.", "java.sql.", "javax.sql."};
    private boolean trace;
    private final HashMap<String, Object> objects = new HashMap();

    public static void main(String ... args) throws IOException {
        new Player().run(args);
    }

    public static void execute(String fileName, boolean trace) throws IOException {
        Player player = new Player();
        player.trace = trace;
        player.runFile(fileName);
    }

    private void run(String ... args) throws IOException {
        String fileName = "test.log.db";
        try {
            fileName = args[args.length - 1];
            int i = 0;
            while (i < args.length - 1) {
                if (!"-trace".equals(args[i])) {
                    throw new RuntimeException("Unknown setting: " + args[i]);
                }
                this.trace = true;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Usage: java " + this.getClass().getName() + " [-trace] <fileName>");
            return;
        }
        this.runFile(fileName);
    }

    private void runFile(String fileName) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader(FileUtils.newInputStream(fileName))));
        while ((line = reader.readLine()) != null) {
            this.runLine(line.trim());
        }
        reader.close();
    }

    void trace(String s) {
        if (this.trace) {
            System.out.println(s);
        }
    }

    private void runLine(String line) {
        if (!((String)line).startsWith("/**/")) {
            return;
        }
        line = ((String)line).substring("/**/".length()) + ";";
        Statement s = Parser.parseStatement(this, (String)line);
        this.trace("> " + s.toString());
        try {
            s.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("error: " + e.toString());
        }
    }

    static Class<?> getClass(String className) {
        String[] stringArray = IMPORTED_PACKAGES;
        int n = IMPORTED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                return Class.forName(s + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        throw new RuntimeException("Class not found: " + className);
    }

    void assign(String variableName, Object obj) {
        this.objects.put(variableName, obj);
    }

    Object getObject(String name) {
        return this.objects.get(name);
    }
}

