/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.h2.dev.util.AnsCompression;
import org.h2.dev.util.BinaryArithmeticStream;
import org.h2.dev.util.BitStream;
import org.h2.test.TestBase;

public class TestAnsCompression
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testScaleFrequencies();
        this.testRandomized();
        this.testCompressionRate();
    }

    private void testCompressionRate() throws IOException {
        byte[] data = new byte[0x100000];
        Random r = new Random(1L);
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(r.nextInt(4) * r.nextInt(4));
            ++i;
        }
        int[] freq = new int[256];
        AnsCompression.countFrequencies(freq, data);
        int lenAns = AnsCompression.encode(freq, data).length;
        BitStream.Huffman huff = new BitStream.Huffman(freq);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BitStream.Out o = new BitStream.Out(out);
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            huff.write(o, x & 0xFF);
            ++n2;
        }
        o.flush();
        int lenHuff = out.toByteArray().length;
        BinaryArithmeticStream.Huffman aHuff = new BinaryArithmeticStream.Huffman(freq);
        out = new ByteArrayOutputStream();
        BinaryArithmeticStream.Out o2 = new BinaryArithmeticStream.Out(out);
        byte[] byArray2 = data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            byte x = byArray2[n4];
            aHuff.write(o2, x & 0xFF);
            ++n4;
        }
        o2.flush();
        int lenArithmetic = out.toByteArray().length;
        this.assertTrue(lenAns < lenArithmetic);
        this.assertTrue(lenArithmetic < lenHuff);
        this.assertTrue(lenHuff < data.length);
    }

    private void testScaleFrequencies() {
        Random r = new Random(1L);
        int j = 0;
        while (j < 100) {
            int symbolCount = r.nextInt(200) + 1;
            int[] freq = new int[symbolCount];
            int total = symbolCount * 2;
            while (total < 10000) {
                int i = 0;
                while (i < freq.length) {
                    freq[i] = r.nextInt(1000) + 1;
                    ++i;
                }
                AnsCompression.scaleFrequencies(freq, total);
                total *= 2;
            }
            ++j;
        }
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1000;
        int[] freq = nArray;
        AnsCompression.scaleFrequencies(freq, 100);
        this.assertEquals("[0, 1, 1, 98]", Arrays.toString(freq));
    }

    private void testRandomized() {
        Random r = new Random(1L);
        int symbolCount = r.nextInt(200) + 1;
        int[] freq = new int[symbolCount];
        int i = 0;
        while (i < freq.length) {
            freq[i] = r.nextInt(1000) + 1;
            ++i;
        }
        int seed = r.nextInt();
        r.setSeed(seed);
        int len = 10000;
        byte[] data = new byte[len];
        r.nextBytes(data);
        freq = new int[256];
        AnsCompression.countFrequencies(freq, data);
        byte[] encoded = AnsCompression.encode(freq, data);
        byte[] decoded = AnsCompression.decode(freq, encoded, data.length);
        int i2 = 0;
        while (i2 < len) {
            byte expected = data[i2];
            this.assertEquals(expected, decoded[i2]);
            ++i2;
        }
    }
}

