/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Server;

public class TestAutoReconnect
extends TestDb {
    private String url;
    private boolean autoServer;
    private Server server;
    private Connection connServer;
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    private void restart() throws SQLException, InterruptedException {
        if (this.autoServer) {
            if (this.connServer != null) {
                this.connServer.createStatement().execute("SHUTDOWN");
                this.connServer.close();
            }
            Driver.load();
            this.connServer = this.getConnection(this.url);
        } else {
            this.server.stop();
            Thread.sleep(100L);
            this.server.start();
        }
    }

    @Override
    public void test() throws Exception {
        this.testWrongUrl();
        this.autoServer = true;
        this.testReconnect();
        this.autoServer = false;
        this.testReconnect();
        this.deleteDb(this.getTestName());
    }

    private void testWrongUrl() throws Exception {
        this.deleteDb(this.getTestName());
        Server tcp = null;
        try {
            tcp = Server.createTcpServer(new String[0]).start();
            this.conn = this.getConnection("jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName() + ";AUTO_SERVER=TRUE");
            this.assertThrows(90020, () -> this.getConnection("jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName() + ";OPEN_NEW=TRUE"));
            this.assertThrows(90020, () -> this.getConnection("jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName() + ";OPEN_NEW=TRUE"));
            this.conn.close();
            this.conn = this.getConnection("jdbc:h2:tcp://localhost:" + tcp.getPort() + "/" + this.getBaseDir() + "/" + this.getTestName());
            this.assertThrows(90020, () -> this.getConnection("jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName() + ";AUTO_SERVER=TRUE;OPEN_NEW=TRUE"));
            this.conn.close();
        }
        finally {
            if (tcp != null) {
                tcp.stop();
            }
        }
    }

    private void testReconnect() throws Exception {
        this.deleteDb(this.getTestName());
        if (this.autoServer) {
            this.url = "jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName() + ";FILE_LOCK=SOCKET;AUTO_SERVER=TRUE;OPEN_NEW=TRUE";
            this.restart();
        } else {
            this.server = Server.createTcpServer("-ifNotExists").start();
            int port = this.server.getPort();
            this.url = "jdbc:h2:tcp://localhost:" + port + "/" + this.getBaseDir() + "/" + this.getTestName() + ";FILE_LOCK=SOCKET;AUTO_RECONNECT=TRUE";
        }
        this.conn = this.getConnection(this.url + ";DATABASE_EVENT_LISTENER='" + MyDatabaseEventListener.class.getName() + "'");
        this.conn.close();
        this.conn = this.getConnection(this.url);
        this.restart();
        Statement stat = this.conn.createStatement();
        this.restart();
        stat.execute("create table test(id identity, name varchar)");
        this.restart();
        PreparedStatement prep = this.conn.prepareStatement("insert into test(name) values(?)");
        this.restart();
        prep.setString(1, "Hello");
        this.restart();
        prep.execute();
        this.restart();
        prep.setString(1, "World");
        this.restart();
        prep.execute();
        this.restart();
        ResultSet rs = stat.executeQuery("select * from test order by id");
        this.restart();
        this.assertTrue(rs.next());
        this.restart();
        this.assertEquals(1, rs.getInt(1));
        this.restart();
        this.assertEquals("Hello", rs.getString(2));
        this.restart();
        this.assertTrue(rs.next());
        this.restart();
        this.assertEquals(2, rs.getInt(1));
        this.restart();
        this.assertEquals("World", rs.getString(2));
        this.restart();
        this.assertFalse(rs.next());
        this.restart();
        stat.execute("SET @TEST 10");
        this.restart();
        rs = stat.executeQuery("CALL @TEST");
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        stat.setFetchSize(10);
        this.restart();
        rs = stat.executeQuery("select * from system_range(1, 20)");
        this.restart();
        int i = 0;
        while (true) {
            try {
                boolean more = rs.next();
                if (!more) {
                    this.assertEquals(i, 20);
                    break;
                }
                this.restart();
                int x = rs.getInt(1);
                this.assertEquals(x, i + 1);
                if (i > 10) {
                    this.fail();
                }
            }
            catch (SQLException e) {
                if (i >= 10) break;
                throw e;
            }
            ++i;
        }
        this.restart();
        rs.close();
        this.conn.setAutoCommit(false);
        this.restart();
        this.assertThrows(90067, this.conn.createStatement()).execute("select * from test");
        this.conn.close();
        if (this.autoServer) {
            this.connServer.close();
        } else {
            this.server.stop();
        }
    }

    public static final class MyDatabaseEventListener
    implements DatabaseEventListener {
    }
}

