/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import org.h2.dev.util.BitStream;
import org.h2.test.TestBase;

public class TestBitStream
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testHuffmanRandomized();
        this.testHuffman();
        this.testBitStream();
        this.testGolomb("11110010", 10, 42);
        this.testGolomb("00", 3, 0);
        this.testGolomb("010", 3, 1);
        this.testGolomb("011", 3, 2);
        this.testGolomb("100", 3, 3);
        this.testGolomb("1010", 3, 4);
        this.testGolombRandomized();
    }

    private void testHuffmanRandomized() {
        Random r = new Random(1L);
        int[] freq = new int[r.nextInt(200) + 1];
        int i = 0;
        while (i < freq.length) {
            freq[i] = r.nextInt(1000) + 1;
            ++i;
        }
        int seed = r.nextInt();
        r.setSeed(seed);
        BitStream.Huffman huff = new BitStream.Huffman(freq);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BitStream.Out out = new BitStream.Out(byteOut);
        int i2 = 0;
        while (i2 < 10000) {
            huff.write(out, r.nextInt(freq.length));
            ++i2;
        }
        out.close();
        BitStream.In in = new BitStream.In(new ByteArrayInputStream(byteOut.toByteArray()));
        r.setSeed(seed);
        int i3 = 0;
        while (i3 < 10000) {
            int expected = r.nextInt(freq.length);
            this.assertEquals(expected, huff.read(in));
            ++i3;
        }
    }

    private void testHuffman() {
        int[] freq = new int[]{36, 18, 12, 9, 7, 6, 5, 4};
        BitStream.Huffman huff = new BitStream.Huffman(freq);
        final StringBuilder buff = new StringBuilder();
        BitStream.Out o = new BitStream.Out(null){

            @Override
            public void writeBit(int bit) {
                buff.append(bit == 0 ? (char)'0' : '1');
            }
        };
        int i = 0;
        while (i < freq.length) {
            buff.append(i + ": ");
            huff.write(o, i);
            buff.append("\n");
            ++i;
        }
        this.assertEquals("0: 0\n1: 110\n2: 100\n3: 1110\n4: 1011\n5: 1010\n6: 11111\n7: 11110\n", buff.toString());
    }

    private void testGolomb(String expected, int div, int value) {
        final StringBuilder buff = new StringBuilder();
        BitStream.Out o = new BitStream.Out(null){

            @Override
            public void writeBit(int bit) {
                buff.append(bit == 0 ? (char)'0' : '1');
            }
        };
        o.writeGolomb(div, value);
        int size = BitStream.Out.getGolombSize(div, value);
        String got = buff.toString();
        this.assertEquals(size, got.length());
        this.assertEquals(expected, got);
    }

    private void testGolombRandomized() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BitStream.Out bitOut = new BitStream.Out(out);
        Random r = new Random(1L);
        int len = 1000;
        int i = 0;
        while (i < len) {
            int div = r.nextInt(100) + 1;
            int value = r.nextInt(1000000);
            bitOut.writeGolomb(div, value);
            ++i;
        }
        bitOut.flush();
        bitOut.close();
        byte[] data = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BitStream.In bitIn = new BitStream.In(in);
        r.setSeed(1L);
        int i2 = 0;
        while (i2 < len) {
            int div = r.nextInt(100) + 1;
            int value = r.nextInt(1000000);
            int v = bitIn.readGolomb(div);
            this.assertEquals("i=" + i2 + " div=" + div, value, v);
            ++i2;
        }
    }

    private void testBitStream() {
        Random r = new Random();
        int test = 0;
        while (test < 10000) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            int len = r.nextInt(40);
            BitStream.Out out = new BitStream.Out(buff);
            long seed = r.nextLong();
            Random r2 = new Random(seed);
            int i = 0;
            while (i < len) {
                out.writeBit(r2.nextBoolean() ? 1 : 0);
                ++i;
            }
            out.close();
            BitStream.In in = new BitStream.In(new ByteArrayInputStream(buff.toByteArray()));
            r2 = new Random(seed);
            int i2 = 0;
            while (i2 < len) {
                int expected = r2.nextBoolean() ? 1 : 0;
                this.assertEquals(expected, in.readBit());
                ++i2;
            }
            while (i2 % 8 != 0) {
                this.assertEquals(0, in.readBit());
                ++i2;
            }
            this.assertEquals(-1, in.readBit());
            ++test;
        }
    }
}

