/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.message.Trace;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Cache;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;

public class TestCache
extends TestDb
implements CacheWriter {
    private String out;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testMemoryUsage();
        this.testCache();
        this.testCacheDb(false);
        this.testCacheDb(true);
    }

    private void testMemoryUsage() throws SQLException {
        if (!this.config.traceTest) {
            return;
        }
        if (this.config.memory) {
            return;
        }
        this.deleteDb("cache");
        Connection conn = this.getConnection("cache;CACHE_SIZE=16384");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data varchar)");
        stat.execute("set max_memory_undo 10000");
        conn.close();
        stat = null;
        conn = null;
        long before = TestCache.getRealMemory();
        conn = this.getConnection("cache;CACHE_SIZE=16384;DB_CLOSE_ON_EXIT=FALSE");
        stat = conn.createStatement();
        stat.execute("insert into test select x, random_uuid() || space(1) from system_range(1, 10000)");
        ResultSet rs = stat.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'info.CACHE_SIZE'");
        rs.next();
        int calculated = rs.getInt(1);
        rs = null;
        long afterInsert = TestCache.getRealMemory();
        conn.close();
        stat = null;
        conn = null;
        long afterClose = TestCache.getRealMemory();
        this.trace("Used memory: " + (afterInsert - afterClose) + " calculated cache size: " + calculated);
        this.trace("Before: " + before + " after: " + afterInsert + " after closing: " + afterClose);
    }

    private static long getRealMemory() {
        StringUtils.clearCache();
        Value.clearCache();
        return Utils.getMemoryUsed();
    }

    private void testCache() {
        this.out = "";
        Cache c = CacheLRU.getCache(this, "LRU", 16);
        int i = 0;
        while (i < 20) {
            c.put(new Obj(i));
            ++i;
        }
        this.assertEquals("flush 0 flush 1 flush 2 flush 3 ", this.out);
    }

    @Override
    public void flushLog() {
        this.out = String.valueOf(this.out) + "flush ";
    }

    @Override
    public Trace getTrace() {
        return null;
    }

    @Override
    public void writeBack(CacheObject entry) {
        this.out = String.valueOf(this.out) + entry.getPos() + " ";
    }

    private void testCacheDb(boolean lru) throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("cache");
        Connection conn = this.getConnection("cache;CACHE_TYPE=" + (lru ? "LRU" : "SOFT_LRU"));
        Statement stat = conn.createStatement();
        stat.execute("SET CACHE_SIZE 1024");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE TABLE MAIN(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        PreparedStatement prep2 = conn.prepareStatement("INSERT INTO MAIN VALUES(?, ?)");
        int max = 10000;
        int i = 0;
        while (i < max) {
            prep.setInt(1, i);
            prep.setString(2, "Hello " + i);
            prep.execute();
            prep2.setInt(1, i);
            prep2.setString(2, "World " + i);
            prep2.execute();
            ++i;
        }
        conn.close();
        conn = this.getConnection("cache");
        stat = conn.createStatement();
        stat.execute("SET CACHE_SIZE 1024");
        Random random = new Random(1L);
        int i2 = 0;
        while (i2 < 100) {
            stat.executeQuery("SELECT * FROM MAIN WHERE ID BETWEEN 40 AND 50");
            stat.executeQuery("SELECT * FROM MAIN WHERE ID = " + random.nextInt(max));
            if (i2 % 10 == 0) {
                stat.executeQuery("SELECT * FROM TEST");
            }
            ++i2;
        }
        conn.close();
        this.deleteDb("cache");
    }

    static class Obj
    extends CacheObject {
        Obj(int pos) {
            this.setPos(pos);
        }

        @Override
        public int getMemory() {
            return 1024;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public boolean isChanged() {
            return true;
        }

        public String toString() {
            return "[" + this.getPos() + "]";
        }
    }
}

