/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.Collator;
import org.h2.test.TestBase;
import org.h2.value.CharsetCollator;
import org.h2.value.CompareMode;

public class TestCharsetCollator
extends TestBase {
    private CharsetCollator cp500Collator = new CharsetCollator(Charset.forName("cp500"));
    private CharsetCollator utf8Collator = new CharsetCollator(StandardCharsets.UTF_8);

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testBasicComparison();
        this.testNumberToCharacterComparison();
        this.testLengthComparison();
        this.testCreationFromCompareMode();
        this.testCreationFromCompareModeWithInvalidCharset();
        this.testCaseInsensitive();
    }

    private void testCreationFromCompareModeWithInvalidCharset() {
        this.assertThrows(UnsupportedCharsetException.class, () -> CompareMode.getCollator("CHARSET_INVALID"));
    }

    private void testCreationFromCompareMode() {
        Collator utf8Col = CompareMode.getCollator("CHARSET_UTF-8");
        this.assertTrue(utf8Col instanceof CharsetCollator);
        this.assertEquals(((CharsetCollator)utf8Col).getCharset(), StandardCharsets.UTF_8);
    }

    private void testBasicComparison() {
        this.assertTrue(this.cp500Collator.compare("A", "B") < 0);
        this.assertTrue(this.cp500Collator.compare("AA", "AB") < 0);
    }

    private void testLengthComparison() {
        this.assertTrue(this.utf8Collator.compare("AA", "A") > 0);
    }

    private void testNumberToCharacterComparison() {
        this.assertTrue(this.cp500Collator.compare("A", "1") < 0);
        this.assertTrue(this.utf8Collator.compare("A", "1") > 0);
    }

    private void testCaseInsensitive() {
        CharsetCollator c = new CharsetCollator(StandardCharsets.UTF_8);
        c.setStrength(1);
        this.assertEquals(0, c.compare("a", "A"));
    }
}

