/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import org.h2.test.TestBase;

public class TestClassLoaderLeak
extends TestBase {
    static final String CLASS_NAME = TestClassLoaderLeak.class.getName();

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        WeakReference<ClassLoader> ref = TestClassLoaderLeak.createClassLoader();
        int i = 0;
        while (i < 10) {
            System.gc();
            Thread.sleep(10L);
            ++i;
        }
        ClassLoader cl = (ClassLoader)ref.get();
        this.assertNull(cl);
        boolean fillMemory = false;
        if (fillMemory) {
            ArrayList<byte[]> memory = new ArrayList<byte[]>();
            int i2 = 0;
            while (i2 < Integer.MAX_VALUE) {
                memory.add(new byte[1024]);
                ++i2;
            }
        }
        DriverManager.registerDriver((Driver)Class.forName("org.h2.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        DriverManager.registerDriver((Driver)Class.forName("org.h2.upgrade.v1_1.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private static WeakReference<ClassLoader> createClassLoader() throws Exception {
        TestClassLoader cl = new TestClassLoader();
        Class<?> h2ConnectionTestClass = Class.forName(CLASS_NAME, true, cl);
        Method testMethod = h2ConnectionTestClass.getDeclaredMethod("runTest", new Class[0]);
        testMethod.setAccessible(true);
        testMethod.invoke(null, new Object[0]);
        return new WeakReference<ClassLoader>(cl);
    }

    static void runTest() throws Exception {
        Class.forName("org.h2.Driver");
        Class.forName("org.h2.upgrade.v1_1.Driver");
        Driver d1 = DriverManager.getDriver("jdbc:h2:mem:test");
        Driver d2 = DriverManager.getDriver("jdbc:h2v1_1:mem:test");
        Connection connection = DriverManager.getConnection("jdbc:h2:mem:test");
        DriverManager.deregisterDriver(d1);
        DriverManager.deregisterDriver(d2);
        connection.close();
        connection = null;
    }

    private static class TestClassLoader
    extends URLClassLoader {
        public TestClassLoader() {
            super(((URLClassLoader)TestClassLoader.class.getClassLoader()).getURLs(), ClassLoader.getSystemClassLoader());
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.contains(CLASS_NAME) && !name.startsWith("org.h2.")) {
                return super.loadClass(name, resolve);
            }
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException | SecurityException e) {
                    return super.loadClass(name, resolve);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
            }
            return c;
        }
    }
}

