/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import org.h2.test.TestBase;
import org.h2.util.Task;

public class TestConcurrentJdbc
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        String url = "jdbc:h2:mem:";
        int i = 0;
        while (i < 50) {
            final int x = i % 4;
            final Connection conn = DriverManager.getConnection(url);
            final Statement stat = conn.createStatement();
            stat.execute("create table test(id int primary key)");
            String sql = "";
            switch (x % 6) {
                case 0: {
                    sql = "select 1";
                    break;
                }
                case 1: 
                case 2: {
                    sql = "delete from test";
                }
            }
            final PreparedStatement prep = conn.prepareStatement(sql);
            final CountDownLatch executedUpdate = new CountDownLatch(1);
            Task t = new Task(){

                @Override
                public void call() throws SQLException {
                    while (!conn.isClosed()) {
                        executedUpdate.countDown();
                        switch (x % 6) {
                            case 0: {
                                prep.executeQuery();
                                break;
                            }
                            case 1: {
                                prep.execute();
                                break;
                            }
                            case 2: {
                                prep.executeUpdate();
                                break;
                            }
                            case 3: {
                                stat.executeQuery("select 1");
                                break;
                            }
                            case 4: {
                                stat.execute("select 1");
                                break;
                            }
                            case 5: {
                                stat.execute("delete from test");
                            }
                        }
                    }
                }
            };
            t.execute();
            try {
                executedUpdate.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            conn.close();
            SQLException e = (SQLException)t.getException();
            if (e != null && 90007 != e.getErrorCode() && 90098 != e.getErrorCode() && 57014 != e.getErrorCode() && 90121 != e.getErrorCode()) {
                throw e;
            }
            ++i;
        }
    }
}

