/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.test.TestBase;
import org.h2.test.unit.TestDateTimeUtils;
import org.h2.util.DateTimeUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class TestDate
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testValueDate();
        this.testValueTime();
        this.testValueTimestamp();
        this.testValueTimestampWithTimezone();
        this.testValidDate();
        this.testAbsoluteDay();
        TestDate.testCalculateLocalMillis();
        this.testDateTimeUtils();
    }

    private void testValueDate() {
        this.assertEquals("2000-01-01", LegacyDateTimeUtils.fromDate(null, null, Date.valueOf("2000-01-01")).getString());
        this.assertEquals("0000-00-00", ValueDate.fromDateValue(0L).getString());
        this.assertEquals("9999-12-31", ValueDate.parse("9999-12-31").getString());
        this.assertEquals("-9999-12-31", ValueDate.parse("-9999-12-31").getString());
        ValueDate d1 = ValueDate.parse("2001-01-01");
        this.assertEquals("2001-01-01", LegacyDateTimeUtils.toDate(null, null, d1).toString());
        this.assertEquals("DATE '2001-01-01'", d1.getTraceSQL());
        this.assertEquals("DATE '2001-01-01'", d1.toString());
        this.assertEquals(17, d1.getValueType());
        long dv = d1.getDateValue();
        this.assertEquals((int)(dv >>> 32 ^ dv), d1.hashCode());
        TypeInfo type = d1.getType();
        this.assertEquals(d1.getString().length(), type.getDisplaySize());
        this.assertEquals(10L, type.getPrecision());
        ValueDate d1b = ValueDate.parse("2001-01-01");
        this.assertTrue(d1 == d1b);
        Value.clearCache();
        d1b = ValueDate.parse("2001-01-01");
        this.assertFalse(d1 == d1b);
        this.assertTrue(d1.equals(d1));
        this.assertTrue(d1.equals(d1b));
        this.assertTrue(d1b.equals(d1));
        this.assertEquals(0, d1.compareTo(d1b, null, null));
        this.assertEquals(0, d1b.compareTo(d1, null, null));
        ValueDate d2 = ValueDate.parse("2002-02-02");
        this.assertFalse(d1.equals(d2));
        this.assertFalse(d2.equals(d1));
        this.assertEquals(-1, d1.compareTo(d2, null, null));
        this.assertEquals(1, d2.compareTo(d1, null, null));
    }

    private void testValueTime() {
        this.assertEquals("10:20:30", LegacyDateTimeUtils.fromTime(null, null, Time.valueOf("10:20:30")).getString());
        this.assertEquals("00:00:00", ValueTime.fromNanos(0L).getString());
        this.assertEquals("23:59:59", ValueTime.parse("23:59:59", null).getString());
        this.assertEquals("11:22:33.444555666", ValueTime.parse("11:22:33.444555666", null).getString());
        this.assertThrows(22007, () -> ValueTime.parse("-00:00:00.000000001", null));
        this.assertThrows(22007, () -> ValueTime.parse("24:00:00", null));
        ValueTime t1 = ValueTime.parse("11:11:11", null);
        this.assertEquals("11:11:11", LegacyDateTimeUtils.toTime(null, null, t1).toString());
        this.assertEquals("TIME '11:11:11'", t1.getTraceSQL());
        this.assertEquals("TIME '11:11:11'", t1.toString());
        this.assertEquals("05:35:35.5", t1.multiply(ValueDouble.get(0.5)).getString());
        this.assertEquals("22:22:22", t1.divide(ValueDouble.get(0.5), TypeInfo.TYPE_TIME).getString());
        this.assertEquals(18, t1.getValueType());
        long nanos = t1.getNanos();
        this.assertEquals((int)(nanos >>> 32 ^ nanos), t1.hashCode());
        TypeInfo type = t1.getType();
        this.assertEquals(18, type.getDisplaySize());
        this.assertEquals(18L, type.getPrecision());
        ValueTime t1b = ValueTime.parse("11:11:11", null);
        this.assertTrue(t1 == t1b);
        Value.clearCache();
        t1b = ValueTime.parse("11:11:11", null);
        this.assertFalse(t1 == t1b);
        this.assertTrue(t1.equals(t1));
        this.assertTrue(t1.equals(t1b));
        this.assertTrue(t1b.equals(t1));
        this.assertEquals(0, t1.compareTo(t1b, null, null));
        this.assertEquals(0, t1b.compareTo(t1, null, null));
        ValueTime t2 = ValueTime.parse("22:22:22", null);
        this.assertFalse(t1.equals(t2));
        this.assertFalse(t2.equals(t1));
        this.assertEquals(-1, t1.compareTo(t2, null, null));
        this.assertEquals(1, t2.compareTo(t1, null, null));
    }

    private void testValueTimestampWithTimezone() {
        int m = 1;
        while (m <= 12) {
            int d = 1;
            while (d <= 28) {
                int h = 0;
                while (h <= 23) {
                    String s = "2011-" + (m < 10 ? "0" : "") + m + "-" + (d < 10 ? "0" : "") + d + " " + (h < 10 ? "0" : "") + h + ":00:00";
                    ValueTimestamp ts = ValueTimestamp.parse(s + "Z", null);
                    String s2 = ts.getString();
                    ValueTimestamp ts2 = ValueTimestamp.parse(s2, null);
                    this.assertEquals(ts.getString(), ts2.getString());
                    ++h;
                }
                ++d;
            }
            ++m;
        }
    }

    private void testValueTimestamp() {
        this.assertEquals("2001-02-03 04:05:06", LegacyDateTimeUtils.fromTimestamp(null, null, Timestamp.valueOf("2001-02-03 04:05:06")).getString());
        this.assertEquals("2001-02-03 04:05:06.001002003", LegacyDateTimeUtils.fromTimestamp(null, null, Timestamp.valueOf("2001-02-03 04:05:06.001002003")).getString());
        this.assertEquals("0000-00-00 00:00:00", ValueTimestamp.fromDateValueAndNanos(0L, 0L).getString());
        this.assertEquals("9999-12-31 23:59:59", ValueTimestamp.parse("9999-12-31 23:59:59", null).getString());
        ValueTimestamp t1 = ValueTimestamp.parse("2001-01-01 01:01:01.111", null);
        this.assertEquals("2001-01-01 01:01:01.111", LegacyDateTimeUtils.toTimestamp(null, null, t1).toString());
        this.assertEquals("2001-01-01", LegacyDateTimeUtils.toDate(null, null, t1).toString());
        this.assertEquals("01:01:01", LegacyDateTimeUtils.toTime(null, null, t1).toString());
        this.assertEquals("TIMESTAMP '2001-01-01 01:01:01.111'", t1.getTraceSQL());
        this.assertEquals("TIMESTAMP '2001-01-01 01:01:01.111'", t1.toString());
        this.assertEquals(20, t1.getValueType());
        long dateValue = t1.getDateValue();
        long nanos = t1.getTimeNanos();
        this.assertEquals((int)(dateValue >>> 32 ^ dateValue ^ nanos >>> 32 ^ nanos), t1.hashCode());
        TypeInfo type = t1.getType();
        this.assertEquals(29, type.getDisplaySize());
        this.assertEquals(29L, type.getPrecision());
        this.assertEquals(9, type.getScale());
        ValueTimestamp t1b = ValueTimestamp.parse("2001-01-01 01:01:01.111", null);
        this.assertTrue(t1 == t1b);
        Value.clearCache();
        t1b = ValueTimestamp.parse("2001-01-01 01:01:01.111", null);
        this.assertFalse(t1 == t1b);
        this.assertTrue(t1.equals(t1));
        this.assertTrue(t1.equals(t1b));
        this.assertTrue(t1b.equals(t1));
        this.assertEquals(0, t1.compareTo(t1b, null, null));
        this.assertEquals(0, t1b.compareTo(t1, null, null));
        ValueTimestamp t2 = ValueTimestamp.parse("2002-02-02 02:02:02.222", null);
        this.assertFalse(t1.equals(t2));
        this.assertFalse(t2.equals(t1));
        this.assertEquals(-1, t1.compareTo(t2, null, null));
        this.assertEquals(1, t2.compareTo(t1, null, null));
        SimpleCastDataProvider provider = new SimpleCastDataProvider();
        t1 = ValueTimestamp.parse("2001-01-01 01:01:01.123456789", null);
        this.assertEquals("2001-01-01 01:01:01.123456789", t1.getString());
        this.assertEquals("2001-01-01 01:01:01.123456789", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 9, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.12345679", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 8, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.1234568", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 7, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.123457", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 6, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.12346", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 5, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.1235", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 4, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.123", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 3, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.12", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 2, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01.1", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 1, null), provider).getString());
        this.assertEquals("2001-01-01 01:01:01", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 0, null), provider).getString());
        t1 = ValueTimestamp.parse("-2001-01-01 01:01:01.123456789", null);
        this.assertEquals("-2001-01-01 01:01:01.123457", t1.castTo(TypeInfo.getTypeInfo(20, 0L, 6, null), provider).getString());
        this.assertFalse(ValueTimestamp.parse("2001-01-01", null).equals(ValueDate.parse("2001-01-01")));
        provider.currentTimestamp = ValueTimestampTimeZone.fromDateValueAndNanos(1008673L, 0L, provider.currentTimeZone.getTimeZoneOffsetUTC(0L));
        this.assertEquals("2001-01-01 01:01:01", ValueTimestamp.parse("2001-01-01", null).add(ValueTime.parse("01:01:01", null).convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)provider)).getString());
        this.assertEquals("1010-10-10 00:00:00", ValueTimestamp.parse("1010-10-10 10:10:10", null).subtract(ValueTime.parse("10:10:10", null).convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)provider)).getString());
        this.assertEquals("-2001-01-01 01:01:01", ValueTimestamp.parse("-2001-01-01", null).add(ValueTime.parse("01:01:01", null).convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)provider)).getString());
        this.assertEquals("-1010-10-10 00:00:00", ValueTimestamp.parse("-1010-10-10 10:10:10", null).subtract(ValueTime.parse("10:10:10", null).convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)provider)).getString());
        this.assertEquals(0L, DateTimeUtils.absoluteDayFromDateValue(ValueTimestamp.parse("1970-01-01", null).getDateValue()));
        this.assertEquals(0L, ValueTimestamp.parse("1970-01-01", null).getTimeNanos());
        this.assertEquals(0L, LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("1970-01-01 00:00:00.000 UTC", null)).getTime());
        this.assertEquals(0L, LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("+1970-01-01T00:00:00.000Z", null)).getTime());
        this.assertEquals(0L, LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("1970-01-01T00:00:00.000+00:00", null)).getTime());
        this.assertEquals(0L, LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("1970-01-01T00:00:00.000-00:00", null)).getTime());
        this.assertThrows(22007, () -> ValueTimestamp.parse("1970-01-01 00:00:00.000 ABC", null));
        this.assertThrows(22007, () -> ValueTimestamp.parse("1970-01-01T00:00:00.000+ABC", null));
    }

    private void testAbsoluteDay() {
        long next = Long.MIN_VALUE;
        int y = -2000;
        while (y < 3000) {
            int m = -3;
            while (m <= 14) {
                int d = -2;
                while (d <= 35) {
                    if (DateTimeUtils.isValidDate(y, m, d)) {
                        long date = DateTimeUtils.dateValue(y, m, d);
                        long abs = DateTimeUtils.absoluteDayFromDateValue(date);
                        if (abs != next && next != Long.MIN_VALUE) {
                            this.assertEquals(abs, next);
                        }
                        if (m == 1 && d == 1) {
                            this.assertEquals(abs, DateTimeUtils.absoluteDayFromYear(y));
                        }
                        next = abs + 1L;
                        long d2 = DateTimeUtils.dateValueFromAbsoluteDay(abs);
                        this.assertEquals(date, d2);
                        this.assertEquals(y, DateTimeUtils.yearFromDateValue(date));
                        this.assertEquals(m, DateTimeUtils.monthFromDateValue(date));
                        this.assertEquals(d, DateTimeUtils.dayFromDateValue(date));
                        long nextDateValue = DateTimeUtils.dateValueFromAbsoluteDay(next);
                        this.assertEquals(nextDateValue, DateTimeUtils.incrementDateValue(date));
                        this.assertEquals(date, DateTimeUtils.decrementDateValue(nextDateValue));
                    }
                    ++d;
                }
                ++m;
            }
            ++y;
        }
    }

    private void testValidDate() {
        GregorianCalendar c = TestDateTimeUtils.createGregorianCalendar(LegacyDateTimeUtils.UTC);
        c.setLenient(false);
        int y = -2000;
        while (y < 3000) {
            int m = -3;
            while (m <= 14) {
                int d = -2;
                while (d <= 35) {
                    boolean valid = DateTimeUtils.isValidDate(y, m, d);
                    if (m < 1 || m > 12) {
                        this.assertFalse(valid);
                    } else if (d < 1 || d > 31) {
                        this.assertFalse(valid);
                    } else if (d <= 27) {
                        this.assertTrue(valid);
                    } else {
                        if (y <= 0) {
                            c.set(0, 0);
                            c.set(1, 1 - y);
                        } else {
                            c.set(0, 1);
                            c.set(1, y);
                        }
                        c.set(2, m - 1);
                        c.set(5, d);
                        boolean expected = true;
                        try {
                            c.getTimeInMillis();
                        }
                        catch (Exception e) {
                            expected = false;
                        }
                        if (expected != valid) {
                            this.fail(y + "-" + m + "-" + d + " expected: " + expected + " got: " + valid);
                        }
                    }
                    ++d;
                }
                ++m;
            }
            ++y;
        }
    }

    private static void testCalculateLocalMillis() {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            for (TimeZone tz : TestDate.getDistinctTimeZones()) {
                TimeZone.setDefault(tz);
                int y = 1900;
                while (y < 2039) {
                    if (y != 1993) {
                        // empty if block
                    }
                    int m = 1;
                    while (m <= 12) {
                        if (m == 3 || m == 4 || m == 10 || m == 11) {
                            int day = 1;
                            while (day < 29) {
                                TestDate.testDate(y, m, day);
                                ++day;
                            }
                        }
                        ++m;
                    }
                    y += 10;
                }
            }
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    private static void testDate(int y, int m, int day) {
        long millis = LegacyDateTimeUtils.getMillis(null, TimeZone.getDefault(), DateTimeUtils.dateValue(y, m, day), 0L);
        String st = new Date(millis).toString();
        int y2 = Integer.parseInt(st.substring(0, 4));
        int m2 = Integer.parseInt(st.substring(5, 7));
        int d2 = Integer.parseInt(st.substring(8, 10));
        if (y != y2 || m != m2 || day != d2) {
            String s = y + "-" + String.valueOf(m < 10 ? "0" + m : Integer.valueOf(m)) + "-" + String.valueOf(day < 10 ? "0" + day : Integer.valueOf(day));
            System.out.println(s + "<>" + st + " " + TimeZone.getDefault().getID());
        }
    }

    public static ArrayList<TimeZone> getDistinctTimeZones() {
        ArrayList<TimeZone> distinct = new ArrayList<TimeZone>();
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TimeZone t = TimeZone.getTimeZone(id);
            for (TimeZone d : distinct) {
                if (!t.hasSameRules(d)) continue;
                t = null;
                break;
            }
            if (t != null) {
                distinct.add(t);
            }
            ++n2;
        }
        return distinct;
    }

    private void testDateTimeUtils() {
        TimeZone old = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+01"));
        DateTimeUtils.resetCalendar();
        try {
            ValueTimestamp ts1 = ValueTimestamp.parse("-999-08-07 13:14:15.16", null);
            ValueTimestamp ts2 = ValueTimestamp.parse("19999-08-07 13:14:15.16", null);
            ValueTime t1 = (ValueTime)ts1.convertTo(TypeInfo.TYPE_TIME);
            ValueTime t2 = (ValueTime)ts2.convertTo(TypeInfo.TYPE_TIME);
            ValueDate d1 = ts1.convertToDate(null);
            ValueDate d2 = ts2.convertToDate(null);
            this.assertEquals("-0999-08-07 13:14:15.16", ts1.getString());
            this.assertEquals("-0999-08-07", d1.getString());
            this.assertEquals("13:14:15.16", t1.getString());
            this.assertEquals("19999-08-07 13:14:15.16", ts2.getString());
            this.assertEquals("19999-08-07", d2.getString());
            this.assertEquals("13:14:15.16", t2.getString());
            TimeZone timeZone = TimeZone.getDefault();
            ValueTimestamp ts1a = LegacyDateTimeUtils.fromTimestamp(null, timeZone, LegacyDateTimeUtils.toTimestamp(null, null, ts1));
            ValueTimestamp ts2a = LegacyDateTimeUtils.fromTimestamp(null, timeZone, LegacyDateTimeUtils.toTimestamp(null, null, ts2));
            this.assertEquals("-0999-08-07 13:14:15.16", ts1a.getString());
            this.assertEquals("19999-08-07 13:14:15.16", ts2a.getString());
        }
        finally {
            TimeZone.setDefault(old);
            DateTimeUtils.resetCalendar();
        }
    }

    static class SimpleCastDataProvider
    implements CastDataProvider {
        TimeZoneProvider currentTimeZone = DateTimeUtils.getTimeZone();
        ValueTimestampTimeZone currentTimestamp = DateTimeUtils.currentTimestamp(this.currentTimeZone);

        SimpleCastDataProvider() {
        }

        @Override
        public Mode getMode() {
            return Mode.getRegular();
        }

        @Override
        public ValueTimestampTimeZone currentTimestamp() {
            return this.currentTimestamp;
        }

        @Override
        public TimeZoneProvider currentTimeZone() {
            return this.currentTimeZone;
        }

        @Override
        public JavaObjectSerializer getJavaObjectSerializer() {
            return null;
        }

        @Override
        public boolean zeroBasedEnums() {
            return false;
        }
    }
}

