/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.h2.api.IntervalQualifier;
import org.h2.test.TestBase;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.value.ValueInterval;
import org.h2.value.ValueTimestamp;

public class TestDateTimeUtils
extends TestBase {
    public static GregorianCalendar createGregorianCalendar(TimeZone tz) {
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setGregorianChange(LegacyDateTimeUtils.PROLEPTIC_GREGORIAN_CHANGE);
        return c;
    }

    public static void main(String ... a) throws Exception {
        if (a.length == 1 && "testUtc2Value".equals(a[0])) {
            new TestDateTimeUtils().testUTC2Value(true);
            return;
        }
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testParseTimeNanosDB2Format();
        this.testDayOfWeek();
        this.testWeekOfYear();
        this.testDateValueFromDenormalizedDate();
        this.testUTC2Value(false);
        this.testConvertScale();
        this.testParseInterval();
        this.testGetTimeZoneOffset();
    }

    private void testParseTimeNanosDB2Format() {
        this.assertEquals(3723004000000L, DateTimeUtils.parseTimeNanos("01:02:03.004", 0, 12));
        this.assertEquals(3723004000000L, DateTimeUtils.parseTimeNanos("01.02.03.004", 0, 12));
        this.assertEquals(3723000000000L, DateTimeUtils.parseTimeNanos("01:02:03", 0, 8));
        this.assertEquals(3723000000000L, DateTimeUtils.parseTimeNanos("01.02.03", 0, 8));
    }

    private void testDayOfWeek() {
        GregorianCalendar gc = TestDateTimeUtils.createGregorianCalendar(LegacyDateTimeUtils.UTC);
        int i = -1000000;
        while (i <= 1000000) {
            gc.clear();
            gc.setTimeInMillis((long)i * 86400000L);
            int year = gc.get(1);
            if (gc.get(0) == 0) {
                year = 1 - year;
            }
            long expectedDateValue = DateTimeUtils.dateValue(year, gc.get(2) + 1, gc.get(5));
            long dateValue = DateTimeUtils.dateValueFromAbsoluteDay(i);
            this.assertEquals(expectedDateValue, dateValue);
            this.assertEquals((long)i, DateTimeUtils.absoluteDayFromDateValue(dateValue));
            int dow = gc.get(7);
            this.assertEquals(dow, DateTimeUtils.getSundayDayOfWeek(dateValue));
            int isoDow = (dow + 5) % 7 + 1;
            this.assertEquals(isoDow, DateTimeUtils.getIsoDayOfWeek(dateValue));
            this.assertEquals(gc.get(3), DateTimeUtils.getWeekOfYear(dateValue, gc.getFirstDayOfWeek() - 1, gc.getMinimalDaysInFirstWeek()));
            ++i;
        }
    }

    private void testWeekOfYear() {
        GregorianCalendar gc = new GregorianCalendar(LegacyDateTimeUtils.UTC);
        int firstDay = 1;
        while (firstDay <= 7) {
            gc.setFirstDayOfWeek(firstDay);
            int minimalDays = 1;
            while (minimalDays <= 7) {
                gc.setMinimalDaysInFirstWeek(minimalDays);
                int i = 0;
                while (i < 150000) {
                    long dateValue = DateTimeUtils.dateValueFromAbsoluteDay(i);
                    gc.clear();
                    gc.setTimeInMillis((long)i * 86400000L);
                    this.assertEquals(gc.get(6), DateTimeUtils.getDayOfYear(dateValue));
                    this.assertEquals(gc.get(3), DateTimeUtils.getWeekOfYear(dateValue, firstDay - 1, minimalDays));
                    this.assertEquals(gc.getWeekYear(), DateTimeUtils.getWeekYear(dateValue, firstDay - 1, minimalDays));
                    ++i;
                }
                ++minimalDays;
            }
            ++firstDay;
        }
    }

    private void testDateValueFromDenormalizedDate() {
        this.assertEquals(DateTimeUtils.dateValue(2017L, 1, 1), DateTimeUtils.dateValueFromDenormalizedDate(2018L, -11L, 0));
        this.assertEquals(DateTimeUtils.dateValue(2001L, 2, 28), DateTimeUtils.dateValueFromDenormalizedDate(2000L, 14L, 29));
        this.assertEquals(DateTimeUtils.dateValue(1999L, 8, 1), DateTimeUtils.dateValueFromDenormalizedDate(2000L, -4L, -100));
        this.assertEquals(DateTimeUtils.dateValue(2100L, 12, 31), DateTimeUtils.dateValueFromDenormalizedDate(2100L, 12L, 2000));
        this.assertEquals(DateTimeUtils.dateValue(-100L, 2, 28), DateTimeUtils.dateValueFromDenormalizedDate(-100L, 2L, 30));
    }

    private void testUTC2Value(boolean allTimeZones) {
        String[] stringArray;
        TimeZone def = TimeZone.getDefault();
        GregorianCalendar gc = new GregorianCalendar();
        if (allTimeZones) {
            stringArray = TimeZone.getAvailableIDs();
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = def.getID();
            stringArray2[1] = "+10";
            stringArray = stringArray2;
            stringArray2[2] = "America/New_York";
        }
        String[] ids = stringArray;
        try {
            String[] stringArray3 = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray3[n2];
                if (allTimeZones) {
                    System.out.println(id);
                }
                TimeZone tz = TimeZone.getTimeZone(id);
                TimeZone.setDefault(tz);
                DateTimeUtils.resetCalendar();
                this.testUTC2ValueImpl(tz, gc);
                ++n2;
            }
        }
        finally {
            TimeZone.setDefault(def);
            DateTimeUtils.resetCalendar();
        }
    }

    private void testUTC2ValueImpl(TimeZone tz, GregorianCalendar gc) {
        gc.setTimeZone(tz);
        gc.set(14, 0);
        long absoluteStart = DateTimeUtils.absoluteDayFromDateValue(DateTimeUtils.dateValue(1950L, 1, 1));
        long absoluteEnd = DateTimeUtils.absoluteDayFromDateValue(DateTimeUtils.dateValue(2050L, 1, 1));
        long i = absoluteStart;
        while (i < absoluteEnd) {
            long dateValue = DateTimeUtils.dateValueFromAbsoluteDay(i);
            int year = DateTimeUtils.yearFromDateValue(dateValue);
            int month = DateTimeUtils.monthFromDateValue(dateValue);
            int day = DateTimeUtils.dayFromDateValue(dateValue);
            int j = 0;
            while (j < 48) {
                gc.set(year, month - 1, day, j / 2, (j & 1) * 30, 0);
                long timeMillis = gc.getTimeInMillis();
                ValueTimestamp ts = LegacyDateTimeUtils.fromTimestamp(null, null, new Timestamp(timeMillis));
                timeMillis += (long)LegacyDateTimeUtils.getTimeZoneOffsetMillis(null, timeMillis);
                this.assertEquals(ts.getDateValue(), LegacyDateTimeUtils.dateValueFromLocalMillis(timeMillis));
                this.assertEquals(ts.getTimeNanos(), LegacyDateTimeUtils.nanosFromLocalMillis(timeMillis));
                ++j;
            }
            ++i;
        }
    }

    private void testConvertScale() {
        this.assertEquals(555555555555L, DateTimeUtils.convertScale(555555555555L, 9, Long.MAX_VALUE));
        this.assertEquals(555555555550L, DateTimeUtils.convertScale(555555555554L, 8, Long.MAX_VALUE));
        this.assertEquals(555555555500L, DateTimeUtils.convertScale(555555555549L, 7, Long.MAX_VALUE));
        this.assertEquals(555555555000L, DateTimeUtils.convertScale(555555555499L, 6, Long.MAX_VALUE));
        this.assertEquals(555555550000L, DateTimeUtils.convertScale(555555554999L, 5, Long.MAX_VALUE));
        this.assertEquals(555555500000L, DateTimeUtils.convertScale(555555549999L, 4, Long.MAX_VALUE));
        this.assertEquals(555555000000L, DateTimeUtils.convertScale(555555499999L, 3, Long.MAX_VALUE));
        this.assertEquals(555550000000L, DateTimeUtils.convertScale(555554999999L, 2, Long.MAX_VALUE));
        this.assertEquals(555500000000L, DateTimeUtils.convertScale(555549999999L, 1, Long.MAX_VALUE));
        this.assertEquals(555000000000L, DateTimeUtils.convertScale(555499999999L, 0, Long.MAX_VALUE));
        this.assertEquals(555555555555L, DateTimeUtils.convertScale(555555555555L, 9, Long.MAX_VALUE));
        this.assertEquals(555555555560L, DateTimeUtils.convertScale(555555555555L, 8, Long.MAX_VALUE));
        this.assertEquals(555555555600L, DateTimeUtils.convertScale(555555555550L, 7, Long.MAX_VALUE));
        this.assertEquals(555555556000L, DateTimeUtils.convertScale(555555555500L, 6, Long.MAX_VALUE));
        this.assertEquals(555555560000L, DateTimeUtils.convertScale(555555555000L, 5, Long.MAX_VALUE));
        this.assertEquals(555555600000L, DateTimeUtils.convertScale(555555550000L, 4, Long.MAX_VALUE));
        this.assertEquals(555556000000L, DateTimeUtils.convertScale(555555500000L, 3, Long.MAX_VALUE));
        this.assertEquals(555560000000L, DateTimeUtils.convertScale(555555000000L, 2, Long.MAX_VALUE));
        this.assertEquals(555600000000L, DateTimeUtils.convertScale(555550000000L, 1, Long.MAX_VALUE));
        this.assertEquals(556000000000L, DateTimeUtils.convertScale(555500000000L, 0, Long.MAX_VALUE));
        this.assertEquals(100999999999L, DateTimeUtils.convertScale(100999999999L, 9, Long.MAX_VALUE));
        this.assertEquals(100999999999L, DateTimeUtils.convertScale(100999999999L, 9, 86400000000000L));
        this.assertEquals(86399999999999L, DateTimeUtils.convertScale(86399999999999L, 9, Long.MAX_VALUE));
        int i = 8;
        while (i >= 0) {
            this.assertEquals(101000000000L, DateTimeUtils.convertScale(100999999999L, i, Long.MAX_VALUE));
            this.assertEquals(101000000000L, DateTimeUtils.convertScale(100999999999L, i, 86400000000000L));
            this.assertEquals(86400000000000L, DateTimeUtils.convertScale(86399999999999L, i, Long.MAX_VALUE));
            --i;
        }
        this.assertEquals(86399999999999L, DateTimeUtils.convertScale(86399999999999L, 9, 86400000000000L));
        this.assertEquals(86399999999990L, DateTimeUtils.convertScale(86399999999999L, 8, 86400000000000L));
        this.assertEquals(86399999999900L, DateTimeUtils.convertScale(86399999999999L, 7, 86400000000000L));
        this.assertEquals(86399999999000L, DateTimeUtils.convertScale(86399999999999L, 6, 86400000000000L));
        this.assertEquals(86399999990000L, DateTimeUtils.convertScale(86399999999999L, 5, 86400000000000L));
        this.assertEquals(86399999900000L, DateTimeUtils.convertScale(86399999999999L, 4, 86400000000000L));
        this.assertEquals(86399999000000L, DateTimeUtils.convertScale(86399999999999L, 3, 86400000000000L));
        this.assertEquals(86399990000000L, DateTimeUtils.convertScale(86399999999999L, 2, 86400000000000L));
        this.assertEquals(86399900000000L, DateTimeUtils.convertScale(86399999999999L, 1, 86400000000000L));
        this.assertEquals(86399000000000L, DateTimeUtils.convertScale(86399999999999L, 0, 86400000000000L));
    }

    private void testParseInterval() {
        this.testParseIntervalSimple(IntervalQualifier.YEAR);
        this.testParseIntervalSimple(IntervalQualifier.MONTH);
        this.testParseIntervalSimple(IntervalQualifier.DAY);
        this.testParseIntervalSimple(IntervalQualifier.HOUR);
        this.testParseIntervalSimple(IntervalQualifier.MINUTE);
        this.testParseIntervalSimple(IntervalQualifier.SECOND);
        this.testParseInterval(IntervalQualifier.YEAR_TO_MONTH, 10L, 0L, "10", "10-0");
        this.testParseInterval(IntervalQualifier.YEAR_TO_MONTH, 10L, 11L, "10-11");
        this.testParseInterval(IntervalQualifier.DAY_TO_HOUR, 10L, 0L, "10", "10 00");
        this.testParseInterval(IntervalQualifier.DAY_TO_HOUR, 10L, 11L, "10 11");
        this.testParseInterval(IntervalQualifier.DAY_TO_MINUTE, 10L, 0L, "10", "10 00:00");
        this.testParseInterval(IntervalQualifier.DAY_TO_MINUTE, 10L, 660L, "10 11", "10 11:00");
        this.testParseInterval(IntervalQualifier.DAY_TO_MINUTE, 10L, 672L, "10 11:12");
        this.testParseInterval(IntervalQualifier.DAY_TO_SECOND, 10L, 0L, "10 00:00:00");
        this.testParseInterval(IntervalQualifier.DAY_TO_SECOND, 10L, 39600000000000L, "10 11", "10 11:00:00");
        this.testParseInterval(IntervalQualifier.DAY_TO_SECOND, 10L, 40320000000000L, "10 11:12", "10 11:12:00");
        this.testParseInterval(IntervalQualifier.DAY_TO_SECOND, 10L, 40333000000000L, "10 11:12:13");
        this.testParseInterval(IntervalQualifier.DAY_TO_SECOND, 10L, 40333123456789L, "10 11:12:13.123456789");
        this.testParseInterval(IntervalQualifier.HOUR_TO_MINUTE, 10L, 0L, "10", "10:00");
        this.testParseInterval(IntervalQualifier.HOUR_TO_MINUTE, 10L, 11L, "10:11");
        this.testParseInterval(IntervalQualifier.HOUR_TO_SECOND, 10L, 0L, "10", "10:00:00");
        this.testParseInterval(IntervalQualifier.HOUR_TO_SECOND, 10L, 660000000000L, "10:11", "10:11:00");
        this.testParseInterval(IntervalQualifier.HOUR_TO_SECOND, 10L, 672000000000L, "10:11:12");
        this.testParseInterval(IntervalQualifier.HOUR_TO_SECOND, 10L, 672123456789L, "10:11:12.123456789");
        this.testParseInterval(IntervalQualifier.MINUTE_TO_SECOND, 10L, 0L, "10", "10:00");
        this.testParseInterval(IntervalQualifier.MINUTE_TO_SECOND, 10L, 11000000000L, "10:11", "10:11");
        this.testParseInterval(IntervalQualifier.MINUTE_TO_SECOND, 10L, 11123456789L, "10:11.123456789");
    }

    private void testParseIntervalSimple(IntervalQualifier qualifier) {
        this.testParseInterval(qualifier, 10L, 0L, "10");
    }

    private void testParseInterval(IntervalQualifier qualifier, long leading, long remaining, String s) {
        this.testParseInterval(qualifier, leading, remaining, s, s);
    }

    private void testParseInterval(IntervalQualifier qualifier, long leading, long remaining, String s, String full) {
        this.testParseIntervalImpl(qualifier, false, leading, remaining, s, full);
        this.testParseIntervalImpl(qualifier, true, leading, remaining, s, full);
    }

    private void testParseIntervalImpl(IntervalQualifier qualifier, boolean negative, long leading, long remaining, String s, String full) {
        ValueInterval expected = ValueInterval.from(qualifier, negative, leading, remaining);
        this.assertEquals(expected, IntervalUtils.parseInterval(qualifier, negative, s));
        StringBuilder b = new StringBuilder();
        b.append("INTERVAL ").append('\'');
        if (negative) {
            b.append('-');
        }
        b.append(full).append("' ").append((Object)qualifier);
        this.assertEquals(b.toString(), expected.getString());
    }

    private void testGetTimeZoneOffset() {
        TimeZone old = TimeZone.getDefault();
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Paris");
        TimeZone.setDefault(timeZone);
        DateTimeUtils.resetCalendar();
        try {
            long n = -1111971600L;
            this.assertEquals(3600, DateTimeUtils.getTimeZone().getTimeZoneOffsetUTC(n - 1L));
            this.assertEquals(3600000, LegacyDateTimeUtils.getTimeZoneOffsetMillis(null, n * 1000L - 1L));
            this.assertEquals(0, DateTimeUtils.getTimeZone().getTimeZoneOffsetUTC(n));
            this.assertEquals(0, LegacyDateTimeUtils.getTimeZoneOffsetMillis(null, n * 1000L));
            this.assertEquals(0, DateTimeUtils.getTimeZone().getTimeZoneOffsetUTC(n + 1L));
            this.assertEquals(0, LegacyDateTimeUtils.getTimeZoneOffsetMillis(null, n * 1000L + 1L));
        }
        finally {
            TimeZone.setDefault(old);
            DateTimeUtils.resetCalendar();
        }
    }
}

