/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import java.sql.Connection;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.store.FileLockMethod;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestFileLock
extends TestDb
implements Runnable {
    private static volatile int locks;
    private static volatile boolean stop;
    private TestBase base;
    private int wait;
    private boolean allowSockets;

    public TestFileLock() {
    }

    TestFileLock(TestBase base, boolean allowSockets) {
        this.base = base;
        this.allowSockets = allowSockets;
    }

    private String getFile() {
        return this.getBaseDir() + "/test.lock";
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return this.getFile().startsWith("./data");
    }

    @Override
    public void test() throws Exception {
        this.testFsFileLock();
        this.testFutureModificationDate();
        this.testSimple();
        this.test(false);
        this.test(true);
    }

    private void testFsFileLock() throws Exception {
        this.deleteDb("fileLock");
        String url = "jdbc:h2:" + this.getBaseDir() + "/fileLock;FILE_LOCK=FS;OPEN_NEW=TRUE";
        Connection conn = this.getConnection(url);
        this.assertThrows(90020, () -> this.getConnection(url));
        conn.close();
    }

    private void testFutureModificationDate() throws Exception {
        File f = new File(this.getFile());
        f.delete();
        this.assertTrue(f.createNewFile());
        f.setLastModified(System.currentTimeMillis() + 10000L);
        FileLock lock = new FileLock(new TraceSystem(null), this.getFile(), 1000);
        lock.lock(FileLockMethod.FILE);
        lock.unlock();
    }

    private void testSimple() {
        String fileName = this.getFile();
        this.testSimple(fileName);
        this.testSimple("async:" + fileName);
    }

    private void testSimple(String fileName) {
        FileLock lock1 = new FileLock(new TraceSystem(null), fileName, 1000);
        FileLock lock2 = new FileLock(new TraceSystem(null), fileName, 1000);
        lock1.lock(FileLockMethod.FILE);
        this.assertThrows(90020, () -> lock2.lock(FileLockMethod.FILE));
        lock1.unlock();
        FileLock lock3 = new FileLock(new TraceSystem(null), fileName, 1000);
        lock3.lock(FileLockMethod.FILE);
        lock3.unlock();
    }

    private void test(boolean allowSocketsLock) throws Exception {
        int threadCount = this.getSize(3, 5);
        this.wait = this.getSize(20, 200);
        Thread[] threads = new Thread[threadCount];
        new File(this.getFile()).delete();
        int i = 0;
        while (i < threadCount) {
            threads[i] = new Thread(new TestFileLock(this, allowSocketsLock));
            threads[i].start();
            Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
            ++i;
        }
        this.trace("wait");
        Thread.sleep(500L);
        stop = true;
        this.trace("STOP file");
        i = 0;
        while (i < threadCount) {
            threads[i].join();
            ++i;
        }
        this.assertEquals(0, locks);
    }

    @Override
    public void run() {
        FileLock lock = null;
        while (!stop) {
            lock = new FileLock(new TraceSystem(null), this.getFile(), 100);
            try {
                lock.lock(this.allowSockets ? FileLockMethod.SOCKET : FileLockMethod.FILE);
                this.base.trace(String.valueOf(lock) + " locked");
                if (++locks > 1) {
                    System.err.println("ERROR! LOCKS=" + locks + " sockets=" + this.allowSockets);
                    stop = true;
                }
                Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
                this.base.trace(String.valueOf(lock) + " unlock");
                lock.unlock();
                if (--locks < 0) {
                    System.err.println("ERROR! LOCKS=" + locks);
                    stop = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (lock != null) {
            lock.unlock();
        }
    }
}

