/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import org.h2.Driver;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.SelfDestructor;

public class TestFileLockProcess
extends TestDb {
    public static void main(String ... args) throws Exception {
        SelfDestructor.startCountdown(60);
        if (args.length == 0) {
            TestBase.createCaller().init().testFromMain();
            return;
        }
        String url = args[0];
        TestFileLockProcess.execute(url);
    }

    private static void execute(String url) {
        Driver.load();
        try {
            Class.forName("org.h2.Driver");
            Connection conn = DriverManager.getConnection(url);
            System.out.println("!");
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.config.codeCoverage || this.config.networked) {
            return false;
        }
        return this.getBaseDir().indexOf(58) <= 0;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("lock");
        String url = "jdbc:h2:" + this.getBaseDir() + "/lock";
        this.println("socket");
        this.test(4, url + ";file_lock=socket");
        this.println("fs");
        this.test(4, url + ";file_lock=fs");
        this.println("default");
        this.test(50, url);
        this.deleteDb("lock");
    }

    private void test(int count, String url) throws Exception {
        Process proc;
        url = this.getURL(url, true);
        Connection conn = this.getConnection(url);
        String selfDestruct = SelfDestructor.getPropertyString(60);
        String[] procDef = new String[]{TestFileLockProcess.getJVM(), selfDestruct, "-cp", this.getClassPath(), this.getClass().getName(), url};
        ArrayList<Process> processes = new ArrayList<Process>(count);
        int i = 0;
        while (i < count) {
            Thread.sleep(100L);
            if (i % 10 == 0) {
                this.println(i + "/" + count);
            }
            proc = Runtime.getRuntime().exec(procDef);
            processes.add(proc);
            ++i;
        }
        i = 0;
        while (i < count) {
            int ch;
            proc = (Process)processes.get(i);
            StringBuilder buff = new StringBuilder();
            while ((ch = proc.getErrorStream().read()) >= 0) {
                System.out.print((char)ch);
                buff.append((char)ch);
            }
            while ((ch = proc.getInputStream().read()) >= 0) {
                System.out.print((char)ch);
                buff.append((char)ch);
            }
            proc.waitFor();
            String processOutput = buff.toString();
            processOutput = processOutput.replaceAll("Picked up _JAVA_OPTIONS: -Xmx2048m -Xms512m", "").trim();
            this.assertEquals(0, proc.exitValue());
            this.assertTrue(i + ": " + buff.toString(), processOutput.isEmpty());
            ++i;
        }
        Thread.sleep(100L);
        conn.close();
    }
}

