/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.dev.ftp.FtpClient;
import org.h2.dev.ftp.server.FtpEvent;
import org.h2.dev.ftp.server.FtpEventListener;
import org.h2.dev.ftp.server.FtpServer;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.tools.Server;

public class TestFtp
extends TestBase
implements FtpEventListener {
    private FtpEvent lastEvent;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return this.getBaseDir().indexOf(58) <= 0;
    }

    @Override
    public void test() throws Exception {
        FileUtils.delete(this.getBaseDir() + "/ftp");
        this.test(this.getBaseDir());
        FileUtils.delete(this.getBaseDir() + "/ftp");
    }

    private void test(String dir) throws Exception {
        Server server = FtpServer.createFtpServer("-ftpDir", dir, "-ftpPort", "8121").start();
        FtpServer ftp = (FtpServer)server.getService();
        ftp.setEventListener(this);
        FtpClient client = FtpClient.open("localhost:8121");
        client.login("sa", "sa");
        client.makeDirectory("ftp");
        client.changeWorkingDirectory("ftp");
        this.assertEquals("CWD", this.lastEvent.getCommand());
        client.makeDirectory("hello");
        client.changeWorkingDirectory("hello");
        client.changeDirectoryUp();
        this.assertEquals("CDUP", this.lastEvent.getCommand());
        client.nameList("hello");
        client.removeDirectory("hello");
        client.close();
        server.stop();
    }

    @Override
    public void beforeCommand(FtpEvent event) {
        this.lastEvent = event;
    }

    @Override
    public void afterCommand(FtpEvent event) {
        this.lastEvent = event;
    }

    @Override
    public void onUnsupportedCommand(FtpEvent event) {
        this.lastEvent = event;
    }
}

