/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.StringUtils;
import org.h2.util.geometry.EWKBUtils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.util.geometry.GeometryUtils;
import org.h2.util.geometry.JTSUtils;
import org.h2.value.ValueGeometry;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class TestGeometryUtils
extends TestBase {
    private static final byte[][] NON_FINITE = new byte[][]{StringUtils.convertHexToBytes("000000000100000000000000007ff8000000000000"), StringUtils.convertHexToBytes("00000000017ff80000000000000000000000000000"), StringUtils.convertHexToBytes("0080000001000000000000000000000000000000007ff8000000000000"), StringUtils.convertHexToBytes("0040000001000000000000000000000000000000007ff8000000000000")};
    private static final int[] NON_FINITE_DIMENSIONS;
    private static final String MIXED_WKT = "LINESTRING (1 2, 3 4 5)";
    private static final byte[] MIXED_WKB;

    static {
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 2;
        NON_FINITE_DIMENSIONS = nArray;
        MIXED_WKB = StringUtils.convertHexToBytes("0080000002000000023ff000000000000040000000000000007ff8000000000000400800000000000040100000000000004014000000000000");
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testPoint();
        this.testLineString();
        this.testPolygon();
        this.testMultiPoint();
        this.testMultiLineString();
        this.testMultiPolygon();
        this.testGeometryCollection();
        this.testEmptyPoint();
        this.testDimensionXY();
        this.testDimensionZ();
        this.testDimensionM();
        this.testDimensionZM();
        this.testFiniteOnly();
        this.testSRID();
        this.testIntersectionAndUnion();
        this.testMixedGeometries();
    }

    private void testPoint() throws Exception {
        this.testGeometry("POINT (1 2)", 2);
        this.testGeometry("POINT (-1.3 15)", 2);
        this.testGeometry("POINT (-1E32 1.000001)", "POINT (-1E32 1.000001)", "POINT (-100000000000000000000000000000000 1.000001)", 2, true);
        this.testGeometry("POINT Z (2.7 -3 34)", 3);
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("POINTZ(1 2 3)")));
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("pointz(1 2 3)")));
    }

    private void testLineString() throws Exception {
        this.testGeometry("LINESTRING (-1 -2, 10 1, 2 20)", 2);
        this.testGeometry("LINESTRING (1 2, 1 3)", 2);
        this.testGeometry("LINESTRING (1 2, 2 2)", 2);
        this.testGeometry("LINESTRING EMPTY", 2);
        this.testGeometry("LINESTRING Z (-1 -2 -3, 10 15.7 3)", 3);
    }

    private void testPolygon() throws Exception {
        this.testGeometry("POLYGON ((-1 -2, 10 1, 2 20, -1 -2))", 2);
        this.testGeometry("POLYGON EMPTY", "POLYGON EMPTY", "POLYGON EMPTY", 2, false);
        this.testGeometry("POLYGON ((-1 -2, 10 1, 2 20, -1 -2), (0.5 0.5, 1 0.5, 1 1, 0.5 0.5))", 2);
        this.testGeometry("POLYGON ((-1 -2, 10 1, 2 20, -1 -2), EMPTY)", 2);
        this.testGeometry("POLYGON Z ((-1 -2 7, 10 1 7, 2 20 7, -1 -2 7), (0.5 0.5 7, 1 0.5 7, 1 1 7, 0.5 0.5 7))", 3);
    }

    private void testMultiPoint() throws Exception {
        this.testGeometry("MULTIPOINT ((1 2), (3 4))", 2);
        this.testGeometry("MULTIPOINT (1 2, 3 4)", "MULTIPOINT ((1 2), (3 4))", "MULTIPOINT ((1 2), (3 4))", 2, true);
        this.testGeometry("MULTIPOINT (1 2)", "MULTIPOINT ((1 2))", "MULTIPOINT ((1 2))", 2, true);
        this.testGeometry("MULTIPOINT EMPTY", 2);
        this.testGeometry("MULTIPOINT Z ((1 2 0.5), (3 4 -3))", 3);
    }

    private void testMultiLineString() throws Exception {
        this.testGeometry("MULTILINESTRING ((1 2, 3 4, 5 7))", 2);
        this.testGeometry("MULTILINESTRING ((1 2, 3 4, 5 7), (-1 -1, 0 0, 2 2, 4 6.01))", 2);
        this.testGeometry("MULTILINESTRING EMPTY", 2);
        this.testGeometry("MULTILINESTRING Z ((1 2 0.5, 3 4 -3, 5 7 10))", 3);
    }

    private void testMultiPolygon() throws Exception {
        this.testGeometry("MULTIPOLYGON (((-1 -2, 10 1, 2 20, -1 -2)))", 2);
        this.testGeometry("MULTIPOLYGON (((-1 -2, 10 1, 2 20, -1 -2)), ((1 2, 2 2, 3 3, 1 2)))", 2);
        this.testGeometry("MULTIPOLYGON EMPTY", 2);
        this.testGeometry("MULTIPOLYGON (((-1 -2, 10 1, 2 20, -1 -2), (0.5 0.5, 1 0.5, 1 1, 0.5 0.5)))", 2);
        this.testGeometry("MULTIPOLYGON Z (((-1 -2 7, 10 1 7, 2 20 7, -1 -2 7), (0.5 1 7, 1 0.5 7, 1 1 7, 0.5 1 7)))", 3);
    }

    private void testGeometryCollection() throws Exception {
        this.testGeometry("GEOMETRYCOLLECTION (POINT (1 2))", 2);
        this.testGeometry("GEOMETRYCOLLECTION (POINT (1 2), MULTILINESTRING ((1 2, 3 4, 5 7), (-1 -1, 0 0, 2 2, 4 6.01)), POINT (100 130))", 2);
        this.testGeometry("GEOMETRYCOLLECTION EMPTY", 2);
        this.testGeometry("GEOMETRYCOLLECTION (GEOMETRYCOLLECTION (POINT (1 3)), MULTIPOINT ((4 8)), GEOMETRYCOLLECTION EMPTY)", 2);
        this.testGeometry("GEOMETRYCOLLECTION Z (POINT Z (1 2 3))", 3);
    }

    private void testGeometry(String wkt, int numOfDimensions) throws Exception {
        this.testGeometry(wkt, wkt, wkt, numOfDimensions, true);
    }

    private void testGeometry(String wkt, String h2Wkt, String jtsWkt, int numOfDimensions, boolean withEWKB) throws Exception {
        Geometry geometryFromH2;
        String got;
        Geometry geometryFromJTS = TestGeometryUtils.readWKT(wkt);
        byte[] wkbFromJTS = new WKBWriter(numOfDimensions).write(geometryFromJTS);
        this.assertEquals(h2Wkt, EWKTUtils.ewkb2ewkt(wkbFromJTS));
        if (withEWKB) {
            this.assertEquals(wkbFromJTS, EWKTUtils.ewkt2ewkb(wkt));
            this.assertEquals(wkbFromJTS, EWKBUtils.ewkb2ewkb(wkbFromJTS));
        }
        if (!jtsWkt.equals(got = new WKTWriter(numOfDimensions).write(geometryFromH2 = JTSUtils.ewkb2geometry(wkbFromJTS)))) {
            this.assertEquals(jtsWkt.replaceAll(" Z ", " Z"), got);
        }
        if (withEWKB) {
            this.assertEquals(wkbFromJTS, JTSUtils.geometry2ewkb(geometryFromJTS));
        }
        Envelope envelopeFromJTS = geometryFromJTS.getEnvelopeInternal();
        this.testEnvelope(envelopeFromJTS, GeometryUtils.getEnvelope(wkbFromJTS));
        GeometryUtils.EnvelopeTarget target = new GeometryUtils.EnvelopeTarget();
        EWKBUtils.parseEWKB(wkbFromJTS, target);
        this.testEnvelope(envelopeFromJTS, target.getEnvelope());
        int expectedDimensionSystem = numOfDimensions > 2 ? 1 : 0;
        this.testDimensions(expectedDimensionSystem, wkbFromJTS);
        this.testValueGeometryProperties(wkbFromJTS);
    }

    private void testEnvelope(Envelope envelopeFromJTS, double[] envelopeFromH2) {
        if (envelopeFromJTS.isNull()) {
            this.assertNull(envelopeFromH2);
            this.assertNull(EWKBUtils.envelope2wkb(envelopeFromH2));
        } else {
            this.assertEquals(envelopeFromJTS.getMinX(), envelopeFromH2[0]);
            this.assertEquals(envelopeFromJTS.getMaxX(), envelopeFromH2[1]);
            this.assertEquals(envelopeFromJTS.getMinY(), envelopeFromH2[2]);
            this.assertEquals(envelopeFromJTS.getMaxY(), envelopeFromH2[3]);
            this.assertEquals(new WKBWriter(2).write(new GeometryFactory().toGeometry(envelopeFromJTS)), EWKBUtils.envelope2wkb(envelopeFromH2));
        }
    }

    private void testEmptyPoint() {
        String ewkt = "POINT EMPTY";
        byte[] ewkb = EWKTUtils.ewkt2ewkb(ewkt);
        this.assertEquals(StringUtils.convertHexToBytes("00000000017ff80000000000007ff8000000000000"), ewkb);
        this.assertEquals(ewkt, EWKTUtils.ewkb2ewkt(ewkb));
        this.assertNull(GeometryUtils.getEnvelope(ewkb));
        Point p = (Point)JTSUtils.ewkb2geometry(ewkb);
        this.assertTrue(p.isEmpty());
        this.assertEquals(ewkt, new WKTWriter().write((Geometry)p));
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)p));
    }

    private void testDimensionXY() throws Exception {
        byte[] ewkb = EWKTUtils.ewkt2ewkb("POINT (1 2)");
        this.assertEquals("POINT (1 2)", EWKTUtils.ewkb2ewkt(ewkb));
        Point p = (Point)JTSUtils.ewkb2geometry(ewkb);
        CoordinateSequence cs = p.getCoordinateSequence();
        this.testDimensionXYCheckPoint(cs);
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)p));
        this.testDimensions(0, ewkb);
        this.testValueGeometryProperties(ewkb);
        p = (Point)TestGeometryUtils.readWKT("POINT (1 2)");
        cs = p.getCoordinateSequence();
        this.testDimensionXYCheckPoint(cs);
        ewkb = JTSUtils.geometry2ewkb((Geometry)p);
        this.assertEquals("POINT (1 2)", EWKTUtils.ewkb2ewkt(ewkb));
        p = (Point)JTSUtils.ewkb2geometry(ewkb);
        cs = p.getCoordinateSequence();
        this.testDimensionXYCheckPoint(cs);
    }

    private void testDimensionXYCheckPoint(CoordinateSequence cs) {
        this.assertEquals(2, cs.getDimension());
        this.assertEquals(0, cs.getMeasures());
        this.assertEquals(1.0, cs.getOrdinate(0, 0));
        this.assertEquals(2.0, cs.getOrdinate(0, 1));
        this.assertEquals(Double.NaN, cs.getZ(0));
    }

    private void testDimensionZ() throws Exception {
        byte[] ewkb = EWKTUtils.ewkt2ewkb("POINT Z (1 2 3)");
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(ewkb));
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("POINTZ(1 2 3)")));
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("pointz(1 2 3)")));
        Point p = (Point)JTSUtils.ewkb2geometry(ewkb);
        CoordinateSequence cs = p.getCoordinateSequence();
        this.testDimensionZCheckPoint(cs);
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)p));
        this.testDimensions(1, ewkb);
        this.testValueGeometryProperties(ewkb);
        p = (Point)TestGeometryUtils.readWKT("POINT Z (1 2 3)");
        cs = p.getCoordinateSequence();
        this.testDimensionZCheckPoint(cs);
        ewkb = JTSUtils.geometry2ewkb((Geometry)p);
        this.assertEquals("POINT Z (1 2 3)", EWKTUtils.ewkb2ewkt(ewkb));
        p = (Point)JTSUtils.ewkb2geometry(ewkb);
        cs = p.getCoordinateSequence();
        this.testDimensionZCheckPoint(cs);
    }

    private void testDimensionZCheckPoint(CoordinateSequence cs) {
        this.assertEquals(3, cs.getDimension());
        this.assertEquals(0, cs.getMeasures());
        this.assertEquals(1.0, cs.getOrdinate(0, 0));
        this.assertEquals(2.0, cs.getOrdinate(0, 1));
        this.assertEquals(3.0, cs.getOrdinate(0, 2));
        this.assertEquals(3.0, cs.getZ(0));
    }

    private void testDimensionM() throws Exception {
        byte[] ewkb = EWKTUtils.ewkt2ewkb("POINT M (1 2 3)");
        this.assertEquals("POINT M (1 2 3)", EWKTUtils.ewkb2ewkt(ewkb));
        this.assertEquals("POINT M (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("POINTM(1 2 3)")));
        this.assertEquals("POINT M (1 2 3)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("pointm(1 2 3)")));
        Point p = (Point)JTSUtils.ewkb2geometry(ewkb);
        CoordinateSequence cs = p.getCoordinateSequence();
        this.testDimensionMCheckPoint(cs);
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)p));
        this.testDimensions(2, ewkb);
        this.testValueGeometryProperties(ewkb);
        p = (Point)TestGeometryUtils.readWKT("POINT M (1 2 3)");
        cs = p.getCoordinateSequence();
        this.testDimensionMCheckPoint(cs);
        ewkb = JTSUtils.geometry2ewkb((Geometry)p);
        this.assertEquals("POINT M (1 2 3)", EWKTUtils.ewkb2ewkt(ewkb));
        p = (Point)JTSUtils.ewkb2geometry(ewkb);
        cs = p.getCoordinateSequence();
        this.testDimensionMCheckPoint(cs);
    }

    private void testDimensionMCheckPoint(CoordinateSequence cs) {
        this.assertEquals(3, cs.getDimension());
        this.assertEquals(1, cs.getMeasures());
        this.assertEquals(1.0, cs.getOrdinate(0, 0));
        this.assertEquals(2.0, cs.getOrdinate(0, 1));
        this.assertEquals(3.0, cs.getOrdinate(0, 2));
        this.assertEquals(3.0, cs.getM(0));
    }

    private void testDimensionZM() throws Exception {
        byte[] ewkb = EWKTUtils.ewkt2ewkb("POINT ZM (1 2 3 4)");
        this.assertEquals("POINT ZM (1 2 3 4)", EWKTUtils.ewkb2ewkt(ewkb));
        this.assertEquals("POINT ZM (1 2 3 4)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("POINTZM(1 2 3 4)")));
        this.assertEquals("POINT ZM (1 2 3 4)", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb("pointzm(1 2 3 4)")));
        Point p = (Point)JTSUtils.ewkb2geometry(ewkb);
        CoordinateSequence cs = p.getCoordinateSequence();
        this.testDimensionZMCheckPoint(cs);
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)p));
        this.testDimensions(3, ewkb);
        this.testValueGeometryProperties(ewkb);
        p = (Point)TestGeometryUtils.readWKT("POINT ZM (1 2 3 4)");
        cs = p.getCoordinateSequence();
        this.testDimensionZMCheckPoint(cs);
        ewkb = JTSUtils.geometry2ewkb((Geometry)p);
        this.assertEquals("POINT ZM (1 2 3 4)", EWKTUtils.ewkb2ewkt(ewkb));
        p = (Point)JTSUtils.ewkb2geometry(ewkb);
        cs = p.getCoordinateSequence();
        this.testDimensionZMCheckPoint(cs);
    }

    private void testDimensionZMCheckPoint(CoordinateSequence cs) {
        this.assertEquals(4, cs.getDimension());
        this.assertEquals(1, cs.getMeasures());
        this.assertEquals(1.0, cs.getOrdinate(0, 0));
        this.assertEquals(2.0, cs.getOrdinate(0, 1));
        this.assertEquals(3.0, cs.getOrdinate(0, 2));
        this.assertEquals(3.0, cs.getZ(0));
        this.assertEquals(4.0, cs.getOrdinate(0, 3));
        this.assertEquals(4.0, cs.getM(0));
    }

    private void testValueGeometryProperties(byte[] ewkb) {
        ValueGeometry vg = ValueGeometry.getFromEWKB(ewkb);
        GeometryUtils.DimensionSystemTarget target = new GeometryUtils.DimensionSystemTarget();
        EWKBUtils.parseEWKB(ewkb, target);
        int dimensionSystem = target.getDimensionSystem();
        this.assertEquals(dimensionSystem, vg.getDimensionSystem());
        String formattedType = EWKTUtils.formatGeometryTypeAndDimensionSystem(new StringBuilder(), vg.getTypeAndDimensionSystem()).toString();
        this.assertTrue(EWKTUtils.ewkb2ewkt(ewkb).startsWith(formattedType));
        switch (dimensionSystem) {
            case 0: {
                this.assertTrue(formattedType.indexOf(32) < 0);
                break;
            }
            case 1: {
                this.assertTrue(formattedType.endsWith(" Z"));
                break;
            }
            case 2: {
                this.assertTrue(formattedType.endsWith(" M"));
                break;
            }
            case 3: {
                this.assertTrue(formattedType.endsWith(" ZM"));
            }
        }
        this.assertEquals(vg.getTypeAndDimensionSystem(), vg.getGeometryType() + vg.getDimensionSystem() * 1000);
        this.assertEquals(0, vg.getSRID());
    }

    private void testFiniteOnly() {
        int i = 0;
        while (i < NON_FINITE.length) {
            this.testFiniteOnly(NON_FINITE[i], new EWKBUtils.EWKBTarget(new ByteArrayOutputStream(), NON_FINITE_DIMENSIONS[i]));
            ++i;
        }
        i = 0;
        while (i < NON_FINITE.length) {
            this.testFiniteOnly(NON_FINITE[i], new EWKTUtils.EWKTTarget(new StringBuilder(), NON_FINITE_DIMENSIONS[i]));
            ++i;
        }
        i = 0;
        while (i < NON_FINITE.length) {
            this.testFiniteOnly(NON_FINITE[i], new JTSUtils.GeometryTarget(NON_FINITE_DIMENSIONS[i]));
            ++i;
        }
    }

    private void testFiniteOnly(byte[] ewkb, GeometryUtils.Target target) {
        this.assertThrows(IllegalArgumentException.class, () -> EWKBUtils.parseEWKB(ewkb, target));
    }

    private void testSRID() throws Exception {
        byte[] ewkb = EWKTUtils.ewkt2ewkb("SRID=10;GEOMETRYCOLLECTION (POINT (1 2))");
        this.assertEquals(StringUtils.convertHexToBytes("00200000070000000a0000000100000000013ff00000000000004000000000000000"), ewkb);
        this.assertEquals("SRID=10;GEOMETRYCOLLECTION (POINT (1 2))", EWKTUtils.ewkb2ewkt(ewkb));
        GeometryCollection gc = (GeometryCollection)JTSUtils.ewkb2geometry(ewkb);
        this.assertEquals(10, gc.getSRID());
        this.assertEquals(10, gc.getGeometryN(0).getSRID());
        this.assertEquals(ewkb, JTSUtils.geometry2ewkb((Geometry)gc));
        ValueGeometry vg = ValueGeometry.getFromEWKB(ewkb);
        this.assertEquals(10, vg.getSRID());
        this.assertEquals(7, vg.getTypeAndDimensionSystem());
        this.assertEquals("SRID=-1;POINT EMPTY", EWKTUtils.ewkb2ewkt(EWKTUtils.ewkt2ewkb(" srid=-1  ; POINT  EMPTY ")));
    }

    private void testDimensions(int expected, byte[] ewkb) {
        GeometryUtils.DimensionSystemTarget dst = new GeometryUtils.DimensionSystemTarget();
        EWKBUtils.parseEWKB(ewkb, dst);
        this.assertEquals(expected, dst.getDimensionSystem());
    }

    private void testIntersectionAndUnion() {
        double[] zero = new double[4];
        this.assertFalse(GeometryUtils.intersects(null, null));
        this.assertFalse(GeometryUtils.intersects(null, zero));
        this.assertFalse(GeometryUtils.intersects(zero, null));
        this.assertNull(GeometryUtils.union(null, null));
        this.assertEquals((Object)zero, (Object)GeometryUtils.union(null, zero));
        this.assertEquals((Object)zero, (Object)GeometryUtils.union(zero, null));
        Random r = new Random(0L);
        int i = 0;
        while (i < 30) {
            double[] envelope1 = TestGeometryUtils.getEnvelope(r);
            double[] envelope2 = TestGeometryUtils.getEnvelope(r);
            Envelope e1 = TestGeometryUtils.convert(envelope1);
            Envelope e2 = TestGeometryUtils.convert(envelope2);
            this.assertEquals(e1.intersects(e2), GeometryUtils.intersects(envelope1, envelope2));
            e1.expandToInclude(e2);
            this.assertEquals(e1, TestGeometryUtils.convert(GeometryUtils.union(envelope1, envelope2)));
            ++i;
        }
    }

    private static Envelope convert(double[] envelope) {
        return new Envelope(envelope[0], envelope[1], envelope[2], envelope[3]);
    }

    private static double[] getEnvelope(Random r) {
        double maxY;
        double minY;
        double maxX;
        double minX = r.nextDouble();
        if (minX > (maxX = r.nextDouble())) {
            double t = minX;
            minX = maxX;
            maxX = t;
        }
        if ((minY = r.nextDouble()) > (maxY = r.nextDouble())) {
            double t = minY;
            minY = maxY;
            maxY = t;
        }
        return new double[]{minX, maxX, minY, maxY};
    }

    private void testMixedGeometries() throws Exception {
        this.assertThrows(IllegalArgumentException.class, () -> EWKTUtils.ewkt2ewkb(MIXED_WKT));
        this.assertThrows(IllegalArgumentException.class, () -> EWKTUtils.ewkb2ewkt(MIXED_WKB));
        this.assertThrows(IllegalArgumentException.class, () -> JTSUtils.ewkb2geometry(MIXED_WKB));
        Geometry g = new WKTReader().read(MIXED_WKT);
        this.assertThrows(IllegalArgumentException.class, () -> JTSUtils.geometry2ewkb(g));
    }

    private static Geometry readWKT(String text) throws ParseException {
        WKTReader reader = new WKTReader();
        reader.setIsOldJtsCoordinateSyntaxAllowed(false);
        return reader.read(text);
    }
}

