/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.IntArray;

public class TestIntArray
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        TestIntArray.testInit();
        this.testRandom();
        this.testRemoveRange();
    }

    private void testRemoveRange() {
        IntArray array = new IntArray(new int[]{1, 2, 3, 4, 5});
        array.removeRange(1, 3);
        this.assertEquals(3, array.size());
        this.assertEquals(1, array.get(0));
        this.assertEquals(4, array.get(1));
        this.assertEquals(5, array.get(2));
    }

    private static void testInit() {
        IntArray array = new IntArray(new int[0]);
        array.add(10);
    }

    private void testRandom() {
        IntArray array = new IntArray();
        int[] test = new int[]{};
        Random random = new Random(1L);
        int i = 0;
        while (i < 10000) {
            int idx = test.length == 0 ? 0 : random.nextInt(test.length);
            int v = random.nextInt(100);
            int op = random.nextInt(4);
            switch (op) {
                case 0: {
                    array.add(v);
                    test = TestIntArray.add(test, v);
                    break;
                }
                case 1: {
                    if (test.length <= idx) break;
                    this.assertEquals(TestIntArray.get(test, idx), array.get(idx));
                    break;
                }
                case 2: {
                    if (test.length <= 0) break;
                    array.remove(idx);
                    test = TestIntArray.remove(test, idx);
                    break;
                }
                case 3: {
                    this.assertEquals(test.length, array.size());
                }
            }
            this.assertEquals(test.length, array.size());
            int j = 0;
            while (j < test.length) {
                this.assertEquals(test[j], array.get(j));
                ++j;
            }
            ++i;
        }
    }

    private static int[] add(int[] array, int i, int value) {
        int[] a2 = new int[array.length + 1];
        System.arraycopy(array, 0, a2, 0, array.length);
        if (i < array.length) {
            System.arraycopy(a2, i, a2, i + 1, a2.length - i - 1);
        }
        array = a2;
        array[i] = value;
        return array;
    }

    private static int[] add(int[] array, int value) {
        return TestIntArray.add(array, array.length, value);
    }

    private static int get(int[] array, int i) {
        return array[i];
    }

    private static int[] remove(int[] array, int i) {
        int[] a2 = new int[array.length - 1];
        System.arraycopy(array, 0, a2, 0, i);
        if (i < a2.length) {
            System.arraycopy(array, i + 1, a2, i, array.length - i - 1);
        }
        return a2;
    }
}

