/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.h2.dev.hash.IntPerfectHash;
import org.h2.test.TestBase;

public class TestIntPerfectHash
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestIntPerfectHash test = (TestIntPerfectHash)TestBase.createCaller().init();
        test.measure();
        test.test();
        test.measure();
    }

    public void measure() {
        int size = 10000;
        this.test(size / 10);
        long time = System.nanoTime();
        int s = this.test(size);
        time = System.nanoTime() - time;
        System.out.println((double)s / (double)size + " bits/key in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
    }

    @Override
    public void test() {
        this.testBitArray();
        int i = 0;
        while (i < 100) {
            this.test(i);
            ++i;
        }
        i = 100;
        while (i <= 10000) {
            this.test(i);
            i *= 10;
        }
    }

    private void testBitArray() {
        byte[] data = new byte[]{};
        BitSet set = new BitSet();
        int i = 100;
        while (i >= 0) {
            data = IntPerfectHash.BitArray.setBit(data, i, true);
            set.set(i);
            --i;
        }
        Random r = new Random(1L);
        int i2 = 0;
        while (i2 < 10000) {
            int pos = r.nextInt(100);
            boolean s = r.nextBoolean();
            data = IntPerfectHash.BitArray.setBit(data, pos, s);
            set.set(pos, s);
            pos = r.nextInt(100);
            this.assertTrue(IntPerfectHash.BitArray.getBit(data, pos) == set.get(pos));
            ++i2;
        }
        this.assertTrue(IntPerfectHash.BitArray.countBits(data) == set.cardinality());
    }

    private int test(int size) {
        Random r = new Random(size);
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(r.nextInt());
        }
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        byte[] desc = IntPerfectHash.generate(list);
        int max = this.test(desc, set);
        this.assertEquals(size - 1, max);
        return desc.length * 8;
    }

    private int test(byte[] desc, Set<Integer> set) {
        int max = -1;
        HashSet<Integer> test = new HashSet<Integer>();
        IntPerfectHash hash = new IntPerfectHash(desc);
        for (int x : set) {
            int h = hash.get(x);
            this.assertTrue(h >= 0);
            this.assertTrue(h <= set.size() * 3);
            max = Math.max(max, h);
            this.assertFalse(test.contains(h));
            test.add(h);
        }
        return max;
    }
}

