/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.h2.server.web.JakartaDbStarter;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestJakartaServlet
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked && !this.config.memory;
    }

    @Override
    public void test() throws SQLException {
        JakartaDbStarter listener = new JakartaDbStarter();
        TestServletContext context = new TestServletContext();
        String url = this.getURL("servlet", true);
        context.setInitParameter("db.url", url);
        context.setInitParameter("db.user", this.getUser());
        context.setInitParameter("db.password", this.getPassword());
        context.setInitParameter("db.tcpServer", "-tcpPort 8888");
        ServletContextEvent event = new ServletContextEvent((ServletContext)context);
        listener.contextInitialized(event);
        Connection conn1 = listener.getConnection();
        Connection conn1a = (Connection)context.getAttribute("connection");
        this.assertTrue(conn1 == conn1a);
        Statement stat1 = conn1.createStatement();
        stat1.execute("CREATE TABLE T(ID INT)");
        Object u2 = url.substring(url.indexOf("servlet"));
        u2 = "jdbc:h2:tcp://localhost:8888/" + this.getBaseDir() + "/" + (String)u2;
        Connection conn2 = DriverManager.getConnection((String)u2, this.getUser(), this.getPassword());
        Statement stat2 = conn2.createStatement();
        stat2.execute("SELECT * FROM T");
        stat2.execute("DROP TABLE T");
        this.assertThrows(42104, stat1).execute("SELECT * FROM T");
        conn2.close();
        listener.contextDestroyed(event);
        this.assertThrows(90067, () -> this.getConnection("jdbc:h2:tcp://localhost:8888/" + this.getBaseDir() + "/servlet", this.getUser(), this.getPassword()));
        this.assertThrows(90007, stat1).execute("SELECT * FROM DUAL");
        this.deleteDb("servlet");
    }

    static class TestServletContext
    implements ServletContext {
        private final Properties initParams = new Properties();
        private final HashMap<String, Object> attributes = new HashMap();

        TestServletContext() {
        }

        public void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        public boolean setInitParameter(String key, String value) {
            this.initParams.setProperty(key, value);
            return true;
        }

        public String getInitParameter(String key) {
            return this.initParams.getProperty(key);
        }

        public Enumeration<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public ServletContext getContext(String string) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getInitParameterNames() {
            throw new UnsupportedOperationException();
        }

        public int getMajorVersion() {
            throw new UnsupportedOperationException();
        }

        public String getMimeType(String string) {
            throw new UnsupportedOperationException();
        }

        public int getMinorVersion() {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            throw new UnsupportedOperationException();
        }

        public String getRealPath(String string) {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            throw new UnsupportedOperationException();
        }

        public URL getResource(String string) {
            throw new UnsupportedOperationException();
        }

        public InputStream getResourceAsStream(String string) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getResourcePaths(String string) {
            throw new UnsupportedOperationException();
        }

        public String getServerInfo() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Servlet getServlet(String string) {
            throw new UnsupportedOperationException();
        }

        public String getServletContextName() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Enumeration<String> getServletNames() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Enumeration<Servlet> getServlets() {
            throw new UnsupportedOperationException();
        }

        public void log(String string) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public void log(Exception exception, String string) {
            throw new UnsupportedOperationException();
        }

        public void log(String string, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
            throw new UnsupportedOperationException();
        }

        public void addListener(String arg0) {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> void addListener(T arg0) {
            throw new UnsupportedOperationException();
        }

        public void addListener(Class<? extends EventListener> arg0) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
            throw new UnsupportedOperationException();
        }

        public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public void declareRoles(String ... arg0) {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException();
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration getFilterRegistration(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException();
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration getServletRegistration(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException();
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException();
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
            throw new UnsupportedOperationException();
        }

        public String getVirtualServerName() {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
            throw new UnsupportedOperationException();
        }

        public int getSessionTimeout() {
            throw new UnsupportedOperationException();
        }

        public void setSessionTimeout(int sessionTimeout) {
            throw new UnsupportedOperationException();
        }

        public String getRequestCharacterEncoding() {
            throw new UnsupportedOperationException();
        }

        public void setRequestCharacterEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }

        public String getResponseCharacterEncoding() {
            throw new UnsupportedOperationException();
        }

        public void setResponseCharacterEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }
    }
}

