/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import org.h2.test.TestBase;
import org.h2.tools.DeleteDbFiles;

public class TestMVTempResult
extends TestBase {
    private static final int MEMORY = 64;
    private static final int ROWS = 1000000;

    public static void main(String ... a) throws Exception {
        TestMVTempResult test = (TestMVTempResult)TestBase.createCaller().init();
        if (a.length == 0) {
            test.test();
        } else {
            test.runTest();
        }
    }

    @Override
    public void test() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.command(TestMVTempResult.getJVM(), "-Xmx64M", "-cp", this.getClassPath(), "-ea", this.getClass().getName(), "dummy");
        this.assertEquals(0, pb.start().waitFor());
    }

    private void runTest() throws SQLException {
        String dir = this.getBaseDir();
        String name = "testResultExternal";
        DeleteDbFiles.execute(dir, name, true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection c = DriverManager.getConnection("jdbc:h2:" + dir + "/" + name);){
            Statement s = c.createStatement();
            s.execute("CREATE TABLE TEST(I BIGINT, E ENUM('a', 'b')) AS SELECT X, 'a' FROM SYSTEM_RANGE(1, 1000000)");
            Throwable throwable2 = null;
            Throwable throwable3 = null;
            try (ResultSet rs = s.executeQuery("SELECT I, E FROM TEST ORDER BY I DESC");){
                int i = 1000000;
                while (i > 0) {
                    this.assertTrue(rs.next());
                    this.assertEquals((long)i, rs.getLong(1));
                    this.assertEquals("a", rs.getString(2));
                    --i;
                }
                this.assertFalse(rs.next());
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            BitSet set = new BitSet(1000000);
            throwable3 = null;
            Object var9_14 = null;
            try (ResultSet rs = s.executeQuery("SELECT I, E FROM TEST");){
                int i = 1;
                while (i <= 1000000) {
                    this.assertTrue(rs.next());
                    set.set((int)rs.getLong(1));
                    this.assertEquals("a", rs.getString(2));
                    ++i;
                }
                this.assertFalse(rs.next());
                this.assertEquals(1000000, set.cardinality());
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        DeleteDbFiles.execute(dir, name, true);
    }
}

