/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.test.TestBase;
import org.h2.util.MemoryEstimator;

public class TestMemoryEstimator
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testEstimator();
        this.testPageEstimator();
    }

    private void testEstimator() {
        Random random = new Random();
        AtomicLong stat = new AtomicLong();
        TestDataType dataType = new TestDataType();
        int sum = 0;
        int sum2 = 0;
        int err2 = 0;
        int size = 10000;
        int i = 0;
        while (i < size) {
            int x = (int)Math.abs(100.0 + random.nextGaussian() * 30.0);
            int y = MemoryEstimator.estimateMemory(stat, dataType, x);
            sum += x;
            sum2 += x * x;
            err2 += (x - y) * (x - y);
            ++i;
        }
        int avg = sum / size;
        double err = Math.sqrt(1.0 * (double)err2 / (double)sum2);
        int pct = MemoryEstimator.samplingPct(stat);
        String msg = "Avg=" + avg + ", err=" + err + ", pct=" + pct + " " + dataType.getCount() * 100 / size;
        this.assertTrue(msg, err < 0.3);
        this.assertTrue(msg, pct <= 7);
    }

    private void testPageEstimator() {
        Random random = new Random();
        AtomicLong stat = new AtomicLong();
        TestDataType dataType = new TestDataType();
        long sum = 0L;
        long sum2 = 0L;
        long err2 = 0L;
        int size = 10000;
        int i = 0;
        while (i < size) {
            int pageSz = random.nextInt(48) + 1;
            Integer[] storage = dataType.createStorage(pageSz);
            int x = 0;
            int k = 0;
            while (k < pageSz) {
                storage[k] = (int)Math.abs(100.0 + random.nextGaussian() * 30.0);
                x += storage[k].intValue();
                ++k;
            }
            int y = MemoryEstimator.estimateMemory(stat, dataType, storage, pageSz);
            sum += (long)x;
            sum2 += (long)(x * x);
            err2 += (long)((x - y) * (x - y));
            i += pageSz;
        }
        long avg = sum / (long)size;
        double err = Math.sqrt(1.0 * (double)err2 / (double)sum2);
        int pct = MemoryEstimator.samplingPct(stat);
        String msg = "Avg=" + avg + ", err=" + err + ", pct=" + pct + " " + dataType.getCount() * 100 / size;
        this.assertTrue(msg, err < 0.12);
        this.assertTrue(msg, pct <= 4);
    }

    private static class TestDataType
    extends BasicDataType<Integer> {
        private int count;

        TestDataType() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int getMemory(Integer obj) {
            ++this.count;
            return obj;
        }

        @Override
        public void write(WriteBuffer buff, Integer obj) {
        }

        @Override
        public Integer read(ByteBuffer buff) {
            return null;
        }

        public Integer[] createStorage(int size) {
            return new Integer[size];
        }
    }
}

