/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.test.TestBase;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class TestObjectDeserialization
extends TestBase {
    private static final String CLAZZ = "org.h2.test.unit.SampleObject";
    private static final String OBJECT = "aced00057372001d6f72672e68322e746573742e756e69742e53616d706c654f626a65637400000000000000010200007870";
    protected boolean usesThreadContextClassLoader;

    public static void main(String ... a) throws Exception {
        System.setProperty("h2.useThreadContextClassLoader", "true");
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testThreadContextClassLoader();
    }

    private void testThreadContextClassLoader() {
        this.usesThreadContextClassLoader = false;
        Thread.currentThread().setContextClassLoader(new TestClassLoader());
        this.assertThrows(90027, () -> JdbcUtils.deserialize(StringUtils.convertHexToBytes(OBJECT), null));
        this.assertTrue(this.usesThreadContextClassLoader);
    }

    private class TestClassLoader
    extends ClassLoader {
        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.equals(TestObjectDeserialization.CLAZZ)) {
                TestObjectDeserialization.this.usesThreadContextClassLoader = true;
            }
            return super.loadClass(name, resolve);
        }
    }
}

