/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

public class TestOverflow
extends TestBase {
    private ArrayList<Value> values;
    private int dataType;
    private BigInteger min;
    private BigInteger max;
    private boolean successExpected;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.test(9, -128L, 127L);
        this.test(11, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.test(12, Long.MIN_VALUE, Long.MAX_VALUE);
        this.test(10, -32768L, 32767L);
    }

    private void test(int type, long minValue, long maxValue) {
        this.values = new ArrayList();
        this.dataType = type;
        this.min = new BigInteger("" + minValue);
        this.max = new BigInteger("" + maxValue);
        this.add(0L);
        this.add(minValue);
        this.add(maxValue);
        this.add(maxValue - 1L);
        this.add(minValue + 1L);
        this.add(1L);
        this.add(-1L);
        Random random = new Random(1L);
        int i = 0;
        while (i < 40) {
            if (maxValue > Integer.MAX_VALUE) {
                this.add(random.nextLong());
            } else {
                this.add((random.nextBoolean() ? 1 : -1) * random.nextInt((int)maxValue));
            }
            ++i;
        }
        for (Value va : this.values) {
            for (Value vb : this.values) {
                this.testValues(va, vb);
            }
        }
    }

    private void checkIfExpected(String a, String b) {
        if (this.successExpected) {
            this.assertEquals(a, b);
        }
    }

    private void onSuccess() {
        if (!this.successExpected) {
            this.fail();
        }
    }

    private void onError() {
        if (this.successExpected) {
            this.fail();
        }
    }

    private void testValues(Value va, Value vb) {
        BigInteger a = new BigInteger(va.getString());
        BigInteger b = new BigInteger(vb.getString());
        this.successExpected = this.inRange(a.negate());
        try {
            this.checkIfExpected(va.negate().getString(), a.negate().toString());
            this.onSuccess();
        }
        catch (Exception e) {
            this.onError();
        }
        this.successExpected = this.inRange(a.add(b));
        try {
            this.checkIfExpected(va.add(vb).getString(), a.add(b).toString());
            this.onSuccess();
        }
        catch (Exception e) {
            this.onError();
        }
        this.successExpected = this.inRange(a.subtract(b));
        try {
            this.checkIfExpected(va.subtract(vb).getString(), a.subtract(b).toString());
            this.onSuccess();
        }
        catch (Exception e) {
            this.onError();
        }
        this.successExpected = this.inRange(a.multiply(b));
        try {
            this.checkIfExpected(va.multiply(vb).getString(), a.multiply(b).toString());
            this.onSuccess();
        }
        catch (Exception e) {
            this.onError();
        }
    }

    private boolean inRange(BigInteger v) {
        return v.compareTo(this.min) >= 0 && v.compareTo(this.max) <= 0;
    }

    private void add(long l) {
        this.values.add(ValueVarchar.get("" + l).convertTo(this.dataType));
    }
}

