/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Restore;

public class TestPageStoreCoverage
extends TestDb {
    private static final String URL = "pageStoreCoverage;PAGE_SIZE=64;CACHE_SIZE=16;MAX_LOG_SIZE=1";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("pageStoreCoverage");
        this.testMoveRoot();
        this.testBasic();
        this.testReadOnly();
        this.testBackupRestore();
        this.testTrim();
        this.testLongTransaction();
        this.testRecoverTemp();
        this.deleteDb("pageStoreCoverage");
    }

    private void testMoveRoot() throws SQLException {
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key) as select x from system_range(1, 20)");
        int i = 0;
        while (i < 10) {
            stat.execute("create memory table test" + i + "(id int primary key) as select x from system_range(1, 2)");
            ++i;
        }
        stat.execute("drop table test");
        conn.close();
        conn = this.getConnection(URL);
        stat = conn.createStatement();
        stat.execute("drop all objects delete files");
        conn.close();
        conn = this.getConnection(URL);
        stat = conn.createStatement();
        stat.execute("create table test(id int primary key) as select x from system_range(1, 100)");
        i = 0;
        while (i < 10) {
            stat.execute("create table test" + i + "(id int primary key) as select x from system_range(1, 2)");
            ++i;
        }
        stat.execute("drop table test");
        conn.close();
        conn = this.getConnection(URL);
        stat = conn.createStatement();
        i = 0;
        while (i < 10) {
            ResultSet rs = stat.executeQuery("select * from test" + i);
            while (rs.next()) {
            }
            ++i;
        }
        stat.execute("drop all objects delete files");
        conn.close();
    }

    private void testRecoverTemp() throws SQLException {
        Statement stat;
        Connection conn;
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            conn = this.getConnection(URL);
            try {
                stat = conn.createStatement();
                stat.execute("create cached temporary table test(id identity, name varchar)");
                stat.execute("create index idx_test_name on test(name)");
                stat.execute("create index idx_test_name2 on test(name, id)");
                stat.execute("create table test2(id identity, name varchar)");
                stat.execute("create index idx_test2_name on test2(name desc)");
                stat.execute("create index idx_test2_name2 on test2(name, id)");
                stat.execute("insert into test2(name) select space(10) from system_range(1, 10)");
                stat.execute("create table test3(id identity, name varchar)");
                stat.execute("checkpoint");
                conn.setAutoCommit(false);
                stat.execute("create table test4(id identity, name varchar)");
                stat.execute("create index idx_test4_name2 on test(name, id)");
                stat.execute("insert into test(name) select space(10) from system_range(1, 10)");
                stat.execute("insert into test3(name) select space(10) from system_range(1, 10)");
                stat.execute("insert into test4(name) select space(10) from system_range(1, 10)");
                stat.execute("truncate table test2");
                stat.execute("drop index idx_test_name");
                stat.execute("drop index idx_test2_name");
                stat.execute("drop table test2");
                stat.execute("insert into test(name) select space(10) from system_range(1, 10)");
                stat.execute("shutdown immediately");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(URL);
            try {
                stat = conn.createStatement();
                stat.execute("drop all objects");
                int i = 0;
                while (i < 10) {
                    stat.execute("create table test" + i + "(id identity, name varchar)");
                    ++i;
                }
                stat.execute("checkpoint");
                i = 0;
                while (i < 10) {
                    stat.execute("drop table test" + i);
                    ++i;
                }
                i = 0;
                while (i < 10) {
                    stat.execute("create table test" + i + "(id identity, name varchar)");
                    ++i;
                }
                stat.execute("shutdown immediately");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(URL);
            try {
                conn.createStatement().execute("drop all objects");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testLongTransaction() throws SQLException {
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity, name varchar)");
        conn.setAutoCommit(false);
        stat.execute("insert into test(name) select space(10) from system_range(1, 10)");
        Connection conn2 = this.getConnection(URL);
        Statement stat2 = conn2.createStatement();
        stat2.execute("checkpoint");
        stat2.execute("create table test2(id identity, name varchar)");
        stat2.execute("create index idx_test2_name on test2(name)");
        stat2.execute("insert into test2(name) select x || space(10000) from system_range(1, 100)");
        stat2.execute("drop table test2");
        conn2.close();
        stat.execute("drop table test");
        conn.close();
    }

    private void testTrim() throws SQLException {
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create index idx_name on test(name, id)");
        stat.execute("insert into test select x, x || space(10) from system_range(1, 20)");
        stat.execute("create table test2(id int primary key, name varchar)");
        stat.execute("create index idx_test2_name on test2(name, id)");
        stat.execute("insert into test2 select x, x || space(10) from system_range(1, 20)");
        stat.execute("create table test3(id int primary key, name varchar)");
        stat.execute("create index idx_test3_name on test3(name, id)");
        stat.execute("insert into test3 select x, x || space(3) from system_range(1, 3)");
        stat.execute("delete from test");
        stat.execute("checkpoint");
        stat.execute("checkpoint sync");
        stat.execute("shutdown compact");
        conn.close();
        conn = this.getConnection(URL);
        conn.createStatement().execute("drop all objects");
        conn.close();
    }

    private void testBasic() throws Exception {
        Connection conn = this.getConnection(URL);
        conn.close();
        conn = this.getConnection(URL);
        conn.close();
    }

    private void testReadOnly() throws Exception {
        Connection conn = this.getConnection(URL);
        conn.createStatement().execute("shutdown compact");
        conn.close();
        conn = this.getConnection("pageStoreCoverage;PAGE_SIZE=64;CACHE_SIZE=16;MAX_LOG_SIZE=1;access_mode_data=r");
        conn.close();
    }

    private void testBackupRestore() throws Exception {
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create index idx_name on test(name, id)");
        stat.execute("insert into test select x, x || space(200 * x) from system_range(1, 10)");
        conn.setAutoCommit(false);
        stat.execute("delete from test where id > 5");
        stat.execute("backup to '" + this.getBaseDir() + "/backup.zip'");
        conn.rollback();
        Restore.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir(), "pageStore2");
        Connection conn2 = this.getConnection("pageStore2");
        Statement stat2 = conn2.createStatement();
        this.assertEqualDatabases(stat, stat2);
        conn.createStatement().execute("drop table test");
        conn2.close();
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/backup.zip");
        this.deleteDb("pageStore2");
    }
}

