/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.expression.condition.CompareLike;
import org.h2.test.TestBase;
import org.h2.value.CompareMode;

public class TestPattern
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testCompareModeReuse();
        this.testPattern();
    }

    private void testCompareModeReuse() {
        CompareMode mode2;
        CompareMode mode1 = CompareMode.getInstance(null, 0);
        this.assertTrue(mode1 == (mode2 = CompareMode.getInstance(null, 0)));
        mode1 = CompareMode.getInstance("DE", 1);
        this.assertFalse(mode1 == mode2);
        mode2 = CompareMode.getInstance("DE", 1);
        this.assertTrue(mode1 == mode2);
    }

    private void testPattern() {
        CompareMode mode = CompareMode.getInstance(null, 0);
        CompareLike comp = new CompareLike(mode, "\\", null, false, false, null, null, CompareLike.LikeType.LIKE);
        this.test(comp, "B", "%_");
        this.test(comp, "A", "A%");
        this.test(comp, "A", "A%%");
        this.test(comp, "A_A", "%\\_%");
        int i = 0;
        while (i < 10000) {
            String pattern = TestPattern.getRandomPattern();
            String value = TestPattern.getRandomValue();
            this.test(comp, value, pattern);
            ++i;
        }
    }

    private void test(CompareLike comp, String value, String pattern) {
        String regexp = this.initPatternRegexp(pattern, '\\');
        boolean resultRegexp = value.matches(regexp);
        boolean result = comp.test(pattern, value, '\\');
        if (result != resultRegexp) {
            this.fail("Error: >" + value + "< LIKE >" + pattern + "< result=" + result + " resultReg=" + resultRegexp);
        }
    }

    private static String getRandomValue() {
        StringBuilder buff = new StringBuilder();
        int len = (int)(Math.random() * 10.0);
        String s = "AB_%\\";
        int i = 0;
        while (i < len) {
            buff.append(s.charAt((int)(Math.random() * (double)s.length())));
            ++i;
        }
        return buff.toString();
    }

    private static String getRandomPattern() {
        StringBuilder buff = new StringBuilder();
        int len = (int)(Math.random() * 4.0);
        String s = "A%_\\";
        int i = 0;
        while (i < len) {
            char c = s.charAt((int)(Math.random() * (double)s.length()));
            if ((c == '_' || c == '%') && Math.random() > 0.5) {
                buff.append('\\');
            } else if (c == '\\') {
                buff.append(c);
            }
            buff.append(c);
            ++i;
        }
        return buff.toString();
    }

    private String initPatternRegexp(String pattern, char escape) {
        int len = pattern.length();
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = pattern.charAt(i);
            if (escape == c) {
                if (i >= len - 1) {
                    this.fail("escape can't be last char");
                }
                c = pattern.charAt(++i);
                buff.append('\\');
                buff.append(c);
            } else if (c == '%') {
                buff.append(".*");
            } else if (c == '_') {
                buff.append('.');
            } else if (c == '\\') {
                buff.append("\\\\");
            } else {
                buff.append(c);
            }
            ++i;
        }
        String regexp = buff.toString();
        return regexp;
    }
}

