/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;

public class TestRecovery
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws Exception {
        this.testRecoverClob();
        this.testRecoverFulltext();
        this.testCompressedAndUncompressed();
        this.testRunScript();
        this.testRunScript2();
    }

    private void testRecoverClob() throws Exception {
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        Connection conn = this.getConnection("recovery");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data clob)");
        stat.execute("insert into test values(1, space(100000))");
        conn.close();
        Recover.main("-dir", this.getBaseDir(), "-db", "recovery");
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        conn = this.getConnection("recovery;init=runscript from '" + this.getBaseDir() + "/recovery.h2.sql'");
        stat = conn.createStatement();
        stat.execute("select * from test");
        conn.close();
    }

    private void testRecoverFulltext() throws Exception {
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        Connection conn = this.getConnection("recovery");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_INIT FOR 'org.h2.fulltext.FullTextLucene.init'");
        stat.execute("CALL FTL_INIT()");
        stat.execute("create table test(id int primary key, name varchar) as select 1, 'Hello'");
        stat.execute("CALL FTL_CREATE_INDEX('PUBLIC', 'TEST', 'NAME')");
        conn.close();
        Recover.main("-dir", this.getBaseDir(), "-db", "recovery");
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        conn = this.getConnection("recovery;init=runscript from '" + this.getBaseDir() + "/recovery.h2.sql'");
        conn.close();
    }

    private void testCompressedAndUncompressed() throws SQLException {
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        DeleteDbFiles.execute(this.getBaseDir(), "recovery2", true);
        Driver.load();
        Connection conn = this.getConnection("recovery");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data clob)");
        stat.execute("insert into test values(1, space(10000))");
        stat.execute("insert into test values(2, space(10000))");
        conn.close();
        Recover rec = new Recover();
        rec.runTool("-dir", this.getBaseDir(), "-db", "recovery");
        Connection conn2 = this.getConnection("recovery2");
        Statement stat2 = conn2.createStatement();
        String name = "recovery.h2.sql";
        stat2.execute("runscript from '" + this.getBaseDir() + "/" + name + "'");
        stat2.execute("select * from test");
        conn2.close();
        conn = this.getConnection("recovery");
        stat = conn.createStatement();
        conn2 = this.getConnection("recovery2");
        stat2 = conn2.createStatement();
        this.assertEqualDatabases(stat, stat2);
        conn.close();
        conn2.close();
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        DeleteDbFiles.execute(this.getBaseDir(), "recovery2", true);
    }

    private void testRunScript() throws Exception {
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        DeleteDbFiles.execute(this.getBaseDir(), "recovery2", true);
        Driver.load();
        Connection conn = this.getConnection("recovery");
        Statement stat = conn.createStatement();
        stat.execute("create table \"Joe\"\"s Table\" as select 1");
        stat.execute("create table test as select * from system_range(1, 100)");
        stat.execute("create view \"TEST VIEW OF TABLE TEST\" as select * from test");
        stat.execute("create table a(id int primary key) as select * from system_range(1, 100)");
        stat.execute("create table b(id int primary key references a(id)) as select * from system_range(1, 100)");
        stat.execute("create table lob(c clob, b blob) as select space(10000) || 'end', SECURE_RAND(10000)");
        stat.execute("create table d(d varchar) as select space(10000) || 'end'");
        stat.execute("alter table a add foreign key(id) references b(id)");
        stat.execute("create table e(id varchar) as select space(10) from system_range(1, 1000)");
        stat.execute("create index idx_e_id on e(id)");
        conn.close();
        Recover rec = new Recover();
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        rec.setOut(new PrintStream((OutputStream)buff, false, "UTF-8"));
        rec.runTool("-dir", this.getBaseDir(), "-db", "recovery", "-trace");
        String out = buff.toString(StandardCharsets.UTF_8);
        this.assertContains(out, "Created file");
        Connection conn2 = this.getConnection("recovery2");
        Statement stat2 = conn2.createStatement();
        String name = "recovery.h2.sql";
        stat2.execute("runscript from '" + this.getBaseDir() + "/" + name + "'");
        stat2.execute("select * from test");
        conn2.close();
        conn = this.getConnection("recovery");
        stat = conn.createStatement();
        conn2 = this.getConnection("recovery2");
        stat2 = conn2.createStatement();
        this.assertEqualDatabases(stat, stat2);
        conn.close();
        conn2.close();
        Recover.execute(this.getBaseDir(), "recovery");
        this.deleteDb("recovery");
        this.deleteDb("recovery2");
        FileUtils.delete(this.getBaseDir() + "/recovery.h2.sql");
        String dir = this.getBaseDir() + "/recovery.lobs.db";
        FileUtils.deleteRecursive(dir, false);
    }

    private void testRunScript2() throws Exception {
        DeleteDbFiles.execute(this.getBaseDir(), "recovery", true);
        DeleteDbFiles.execute(this.getBaseDir(), "recovery2", true);
        Driver.load();
        Connection conn = this.getConnection("recovery");
        Statement stat = conn.createStatement();
        stat.execute("SET COLLATION EN");
        stat.execute("CREATE TABLE TEST(A VARCHAR)");
        conn.close();
        Recover recover = new Recover();
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        recover.setOut(new PrintStream((OutputStream)buff, false, "UTF-8"));
        recover.runTool("-dir", this.getBaseDir(), "-db", "recovery", "-trace");
        String consoleOut = buff.toString(StandardCharsets.UTF_8);
        this.assertContains(consoleOut, "Created file");
        Connection conn2 = this.getConnection("recovery2");
        Statement stat2 = conn2.createStatement();
        stat2.execute("runscript from '" + this.getBaseDir() + "/recovery.h2.sql'");
        stat2.execute("select * from test");
        conn2.close();
        conn = this.getConnection("recovery");
        stat = conn.createStatement();
        conn2 = this.getConnection("recovery2");
        stat2 = conn2.createStatement();
        this.assertEqualDatabases(stat, stat2);
        conn.close();
        conn2.close();
        this.deleteDb("recovery");
        this.deleteDb("recovery2");
        FileUtils.delete(this.getBaseDir() + "/recovery.h2.sql");
        String dir = this.getBaseDir() + "/recovery.lobs.db";
        FileUtils.deleteRecursive(dir, false);
    }
}

