/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.Recorder;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.test.TestBase;
import org.h2.test.unit.TestPageStoreCoverage;
import org.h2.tools.Recover;
import org.h2.util.IOUtils;
import org.h2.util.Profiler;
import org.h2.util.Utils;

public class TestReopen
extends TestBase
implements Recorder {
    private String testDatabase = "memFS:./data/reopen";
    private int writeCount = Utils.getProperty("h2.reopenOffset", 0);
    private final int testEvery = 1 << Utils.getProperty("h2.reopenShift", 6);
    private final long maxFileSize = (long)Utils.getProperty("h2.reopenMaxFileSize", Integer.MAX_VALUE) * 1024L * 1024L;
    private int verifyCount;
    private final HashSet<String> knownErrors = new HashSet();
    private volatile boolean testing;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        System.setProperty("h2.delayWrongPasswordMin", "0");
        FilePathRec.register();
        FilePathRec.setRecorder(this);
        this.config.reopen = true;
        long time = System.nanoTime();
        Profiler p = new Profiler();
        p.startCollecting();
        new TestPageStoreCoverage().init(this.config).test();
        System.out.println(p.getTop(3));
        System.out.println(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        System.out.println("counter: " + this.writeCount);
    }

    @Override
    public void log(int op, String fileName, byte[] data, long x) {
        if (op != 8 && op != 7) {
            return;
        }
        if (!fileName.endsWith(".mv.db")) {
            return;
        }
        if (this.testing) {
            return;
        }
        this.testing = true;
        try {
            this.logDb(fileName);
        }
        finally {
            this.testing = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void logDb(String fileName) {
        block20: {
            ++this.writeCount;
            if ((this.writeCount & this.testEvery - 1) != 0) {
                return;
            }
            if (FileUtils.size(fileName) > this.maxFileSize) {
                return;
            }
            System.out.println("+ write #" + this.writeCount + " verify #" + this.verifyCount);
            try {
                IOUtils.copyFiles(fileName, this.testDatabase + ".mv.db");
                ++this.verifyCount;
                url = "jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO;TRACE_LEVEL_FILE=0";
                ci = new ConnectionInfo(url, null, this.getUser(), this.getPassword());
                database = new Database(ci, null);
                session = database.getSystemSession();
                session.prepare("script to '" + this.testDatabase + ".sql'").query(0L);
                session.prepare("shutdown immediately").update();
                database.removeSession(null);
                return;
            }
            catch (DbException e) {
                e2 = DbException.toSQLException(e);
                errorCode = e2.getErrorCode();
                if (errorCode == 28000) {
                    return;
                }
                if (errorCode == 90049) {
                    return;
                }
                e.printStackTrace(System.out);
                throw e;
            }
            catch (Exception e) {
                errorCode = 0;
                if (e instanceof SQLException) {
                    errorCode = ((SQLException)e).getErrorCode();
                }
                if (errorCode == 28000) {
                    return;
                }
                if (errorCode == 90049) {
                    return;
                }
                e.printStackTrace(System.out);
                System.out.println("begin ------------------------------ " + this.writeCount);
                try {
                    Recover.execute(fileName.substring(0, fileName.lastIndexOf(47)), null);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.testDatabase = String.valueOf(this.testDatabase) + "X";
                try {
                    IOUtils.copyFiles(fileName, this.testDatabase + ".mv.db");
                    url = "jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO";
                    ci = new ConnectionInfo(url, null, null, null);
                    database = new Database(ci, null);
                    database.removeSession(null);
                    break block20;
                }
                catch (Exception e) {
                    errorCode = 0;
                    if (e instanceof DbException) {
                        e = ((DbException)e).getSQLException();
                        errorCode = e.getErrorCode();
                    }
                    if (errorCode == 28000) {
                        return;
                    }
                    if (errorCode == 90049) {
                        return;
                    }
                    buff = new StringBuilder();
                    list = e.getStackTrace();
                    i = 0;
                    ** while (i < 10 && i < list.length)
                }
            }
lbl-1000:
            // 1 sources

            {
                buff.append(list[i].toString()).append('\n');
                ++i;
                continue;
            }
lbl69:
            // 1 sources

            s = buff.toString();
            if (!this.knownErrors.contains(s)) {
                System.out.println(this.writeCount + " code: " + errorCode + " " + e.toString());
                e.printStackTrace(System.out);
                this.knownErrors.add(s);
            } else {
                System.out.println(this.writeCount + " code: " + errorCode);
            }
        }
    }
}

