/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.StringReader;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.ScriptReader;

public class TestScriptReader
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testCommon();
        this.testRandom();
    }

    private void testRandom() {
        int len = this.getSize(1000, 10000);
        Random random = new Random(10L);
        int i = 0;
        while (i < len) {
            int l = random.nextInt(10);
            String[] sql = new String[l];
            StringBuilder buff = new StringBuilder();
            int j = 0;
            while (j < l) {
                sql[j] = TestScriptReader.randomStatement(random);
                buff.append(sql[j]);
                if (j < l - 1) {
                    buff.append(";");
                }
                ++j;
            }
            String s = buff.toString();
            StringReader reader = new StringReader(s);
            Throwable throwable = null;
            Object var10_12 = null;
            try (ScriptReader source = new ScriptReader(reader);){
                int j2 = 0;
                while (j2 < l) {
                    String e = source.readStatement();
                    String c = sql[j2];
                    if (c.length() == 0 && j2 == l - 1) {
                        c = null;
                    }
                    this.assertEquals(c, e);
                    ++j2;
                }
                this.assertEquals(null, source.readStatement());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    private static String randomStatement(Random random) {
        StringBuilder buff = new StringBuilder();
        int len = random.nextInt(5);
        int i = 0;
        while (i < len) {
            switch (random.nextInt(10)) {
                case 0: {
                    int l = random.nextInt(4);
                    String[] ch = new String[]{"\n", "\r", " ", "*", "a", "0", "$ "};
                    int j = 0;
                    while (j < l) {
                        buff.append(ch[random.nextInt(ch.length)]);
                        ++j;
                    }
                    break;
                }
                case 1: {
                    buff.append('\'');
                    int l = random.nextInt(4);
                    String[] ch = new String[]{";", "\n", "\r", "--", "//", "/", "-", "*", "/*", "*/", "\"", "$ "};
                    int j = 0;
                    while (j < l) {
                        buff.append(ch[random.nextInt(ch.length)]);
                        ++j;
                    }
                    buff.append('\'');
                    break;
                }
                case 2: {
                    buff.append('\"');
                    int l = random.nextInt(4);
                    String[] ch = new String[]{";", "\n", "\r", "--", "//", "/", "-", "*", "/*", "*/", "'", "$"};
                    int j = 0;
                    while (j < l) {
                        buff.append(ch[random.nextInt(ch.length)]);
                        ++j;
                    }
                    buff.append('\"');
                    break;
                }
                case 3: {
                    int j;
                    buff.append('-');
                    if (random.nextBoolean()) {
                        String[] ch = new String[]{"\n", "\r", "*", "a", " ", "$ "};
                        int l = 1 + random.nextInt(4);
                        j = 0;
                        while (j < l) {
                            buff.append(ch[random.nextInt(ch.length)]);
                            ++j;
                        }
                        break;
                    }
                    buff.append('-');
                    String[] ch = new String[]{";", "-", "//", "/*", "*/", "a", "$"};
                    int l = random.nextInt(4);
                    j = 0;
                    while (j < l) {
                        buff.append(ch[random.nextInt(ch.length)]);
                        ++j;
                    }
                    buff.append('\n');
                    break;
                }
                case 4: {
                    int j;
                    buff.append('/');
                    if (random.nextBoolean()) {
                        String[] ch = new String[]{"\n", "\r", "a", " ", "- ", "$ "};
                        int l = 1 + random.nextInt(4);
                        j = 0;
                        while (j < l) {
                            buff.append(ch[random.nextInt(ch.length)]);
                            ++j;
                        }
                    } else {
                        buff.append('*');
                        String[] ch = new String[]{";", "-", "//", "/* ", "--", "\n", "\r", "a", "$"};
                        int l = random.nextInt(4);
                        int comments = 0;
                        int j2 = 0;
                        while (j2 < l) {
                            String s = ch[random.nextInt(ch.length)];
                            buff.append(s);
                            if (s.equals("/* ")) {
                                ++comments;
                            }
                            ++j2;
                        }
                        while (comments-- >= 0) {
                            buff.append("*/");
                        }
                    }
                    break;
                }
                case 5: {
                    int j;
                    if (buff.length() > 0) {
                        buff.append(" ");
                    }
                    buff.append("$");
                    if (random.nextBoolean()) {
                        String[] ch = new String[]{"\n", "\r", "a", " ", "- ", "/ "};
                        int l = 1 + random.nextInt(4);
                        j = 0;
                        while (j < l) {
                            buff.append(ch[random.nextInt(ch.length)]);
                            ++j;
                        }
                        break;
                    }
                    buff.append("$");
                    String[] ch = new String[]{";", "-", "//", "/* ", "--", "\n", "\r", "a", "$ "};
                    int l = random.nextInt(4);
                    j = 0;
                    while (j < l) {
                        buff.append(ch[random.nextInt(ch.length)]);
                        ++j;
                    }
                    buff.append("$$");
                }
            }
            ++i;
        }
        return buff.toString();
    }

    private void testCommon() {
        String s = "$$;$$;";
        ScriptReader source = new ScriptReader(new StringReader(s));
        this.assertEquals("$$;$$", source.readStatement());
        this.assertEquals(null, source.readStatement());
        source.close();
        s = "a;';';\";\";--;\n;/*;\n*/;//;\na;";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("a", source.readStatement());
        this.assertEquals("';'", source.readStatement());
        this.assertEquals("\";\"", source.readStatement());
        this.assertEquals("--;\n", source.readStatement());
        this.assertEquals("/*;\n*/", source.readStatement());
        this.assertEquals("//;\na", source.readStatement());
        this.assertEquals(null, source.readStatement());
        source.close();
        s = "/\n$ \n\n $';$$a$$ $\n;'";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/\n$ \n\n $';$$a$$ $\n;'", source.readStatement());
        this.assertEquals(null, source.readStatement());
        source.close();
        s = "//";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("//", source.readStatement());
        this.assertTrue(source.isInsideRemark());
        this.assertFalse(source.isBlockRemark());
        source.close();
        s = "/*xxx";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/*xxx", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
        s = "/*xxx*";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/*xxx*", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
        s = "/*xxx* ";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/*xxx* ", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
        s = "/*xxx/";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/*xxx/", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
        s = "/*/**/SCRIPT;*/";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/*/**/SCRIPT;*/", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
        s = "/* /* */ SCRIPT; */";
        source = new ScriptReader(new StringReader(s));
        this.assertEquals("/* /* */ SCRIPT; */", source.readStatement());
        this.assertTrue(source.isBlockRemark());
        source.close();
    }
}

