/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.h2.compress.LZFInputStream;
import org.h2.compress.LZFOutputStream;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;

public class TestStreams
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws IOException {
        this.testLZFStreams();
        this.testLZFStreamClose();
    }

    private static byte[] getRandomBytes(Random random) {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = random.nextInt(1000);
        nArray[3] = random.nextInt(100000);
        nArray[4] = random.nextInt(1000000);
        int[] sizes = nArray;
        int size = sizes[random.nextInt(sizes.length)];
        byte[] buffer = new byte[size];
        if (random.nextInt(5) == 1) {
            random.nextBytes(buffer);
        } else if (random.nextBoolean()) {
            int patternLen = random.nextInt(100) + 1;
            int j = 0;
            while (j < size) {
                buffer[j] = (byte)(j % patternLen);
                ++j;
            }
        }
        return buffer;
    }

    private void testLZFStreamClose() throws IOException {
        String fileName = this.getBaseDir() + "/temp";
        FileUtils.createDirectories(FileUtils.getParent(fileName));
        OutputStream fo = FileUtils.newOutputStream(fileName, false);
        LZFOutputStream out = new LZFOutputStream(fo);
        out.write("Hello".getBytes());
        out.close();
        InputStream fi = FileUtils.newInputStream(fileName);
        LZFInputStream in = new LZFInputStream(fi);
        byte[] buff = new byte[100];
        this.assertEquals(5, in.read(buff));
        in.read();
        in.close();
        FileUtils.delete(this.getBaseDir() + "/temp");
    }

    private void testLZFStreams() throws IOException {
        Random random = new Random(1L);
        int max = this.getSize(100, 1000);
        int i = 0;
        while (i < max) {
            byte[] buffer = TestStreams.getRandomBytes(random);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LZFOutputStream comp = new LZFOutputStream(out);
            if (random.nextInt(10) == 1) {
                comp.write(buffer);
            } else {
                int j = 0;
                while (j < buffer.length) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = random.nextInt(100);
                    nArray[3] = random.nextInt(100000);
                    int[] sizes = nArray;
                    int size = sizes[random.nextInt(sizes.length)];
                    if ((size = Math.min(size, buffer.length - j)) == 1) {
                        comp.write(buffer[j]);
                    } else {
                        comp.write(buffer, j, size);
                    }
                    j += size;
                }
            }
            comp.close();
            byte[] compressed = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            LZFInputStream decompress = new LZFInputStream(in);
            byte[] test = new byte[buffer.length];
            int j = 0;
            while (j < buffer.length) {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = random.nextInt(100);
                nArray[3] = random.nextInt(100000);
                int[] sizes = nArray;
                int size = sizes[random.nextInt(sizes.length)];
                if (size == 1) {
                    int x = decompress.read();
                    if (x < 0) break;
                    test[j++] = (byte)x;
                    continue;
                }
                int l = decompress.read(test, j, size = Math.min(size, test.length - j));
                if (l < 0) break;
                j += l;
            }
            decompress.close();
            this.assertEquals(buffer, test);
            i += 3;
        }
    }
}

