/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.awt.Button;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.h2.Driver;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.trace.Player;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.Console;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.GUIConsole;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.Server;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.Task;
import org.h2.value.ValueUuid;

public class TestTools
extends TestDb {
    private static String lastUrl;
    private Server server;
    private List<Server> remainingServers = new ArrayList<Server>(3);

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked;
    }

    @Override
    public void test() throws Exception {
        DeleteDbFiles.execute(this.getBaseDir(), null, true);
        Driver.load();
        this.testSimpleResultSet();
        this.testTcpServerWithoutPort();
        this.testConsole();
        this.testJdbcDriverUtils();
        this.testWrongServer();
        this.testDeleteFiles();
        this.testScriptRunscriptLob();
        this.testServerMain();
        this.testConvertTraceFile();
        this.testManagementDb();
        this.testChangeFileEncryption(false);
        if (!this.config.splitFileSystem) {
            this.testChangeFileEncryption(true);
        }
        this.testChangeFileEncryptionWithWrongPassword();
        this.testServer();
        this.testScriptRunscript();
        this.testBackupRestore();
        this.testRecover();
        FileUtils.delete(this.getBaseDir() + "/b2.sql");
        FileUtils.delete(this.getBaseDir() + "/b2.sql.txt");
        FileUtils.delete(this.getBaseDir() + "/b2.zip");
    }

    private void testTcpServerWithoutPort() throws Exception {
        Server s1 = null;
        try {
            s1 = Server.createTcpServer(new String[0]).start();
            Server s2 = null;
            try {
                s2 = Server.createTcpServer(new String[0]).start();
                this.assertTrue(s1.getPort() != s2.getPort());
            }
            finally {
                if (s2 != null) {
                    s2.stop();
                }
            }
        }
        finally {
            if (s1 != null) {
                s1.stop();
            }
        }
        try {
            s1 = Server.createTcpServer("-tcpPort", "9123").start();
            this.assertEquals(9123, s1.getPort());
            this.assertThrows(90061, () -> Server.createTcpServer("-tcpPort", "9123").start());
        }
        finally {
            if (s1 != null) {
                s1.stop();
            }
        }
    }

    private void testConsole() throws Exception {
        String old = System.getProperty("h2.browser");
        GUIConsole c = new GUIConsole();
        c.setOut(new PrintStream(new ByteArrayOutputStream()));
        try {
            lastUrl = "-";
            System.setProperty("h2.browser", "call:" + TestTools.class.getName() + ".openBrowser");
            c.runTool("-web", "-webPort", "9002", "-tool", "-browser", "-tcp", "-tcpPort", "9003", "-pg", "-pgPort", "9004");
            this.assertContains(lastUrl, ":9002");
            TestTools.shutdownConsole(c);
            c.runTool("-web", "-webPort", "9002", "-tool");
            lastUrl = "-";
            c.actionPerformed(new ActionEvent(this, 0, "console"));
            this.assertContains(lastUrl, ":9002");
            lastUrl = "-";
            Thread.sleep(200L);
            try {
                MouseEvent me = new MouseEvent(new Button(), 0, 0L, 0, 0, 0, 0, false, 1);
                c.mouseClicked(me);
                this.assertContains(lastUrl, ":9002");
                lastUrl = "-";
                c.mouseClicked(me);
                this.assertEquals("-", lastUrl);
                c.actionPerformed(new ActionEvent(this, 0, "status"));
                c.actionPerformed(new ActionEvent(this, 0, "exit"));
                c.runTool("-webPort", "9002");
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            TestTools.shutdownConsole(c);
            this.assertThrows(90061, () -> c.runTool("-web", "-webPort", "9002", "-tcp", "-tcpPort", "9002"));
            c.runTool("-web", "-webPort", "9002");
        }
        finally {
            if (old != null) {
                System.setProperty("h2.browser", old);
            } else {
                System.clearProperty("h2.browser");
            }
            TestTools.shutdownConsole(c);
        }
    }

    private static void shutdownConsole(Console c) {
        c.shutdown();
        if (Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void openBrowser(String url) {
        lastUrl = url;
    }

    private void testSimpleResultSet() throws Exception {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn(null, 0, 0, 0);
        rs.addRow(1);
        SimpleResultSet r = rs;
        this.assertThrows(IllegalStateException.class, () -> r.addColumn(null, 0, 0, 0));
        this.assertEquals(1003, rs.getType());
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("1", rs.getString("C1"));
        this.assertFalse(rs.wasNull());
        this.assertEquals("C1", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("C1", rs.getColumnName(1));
        this.assertEquals(2, rs.getMetaData().isNullable(1));
        this.assertFalse(rs.getMetaData().isAutoIncrement(1));
        this.assertTrue(rs.getMetaData().isCaseSensitive(1));
        this.assertFalse(rs.getMetaData().isCurrency(1));
        this.assertFalse(rs.getMetaData().isDefinitelyWritable(1));
        this.assertTrue(rs.getMetaData().isReadOnly(1));
        this.assertTrue(rs.getMetaData().isSearchable(1));
        this.assertTrue(rs.getMetaData().isSigned(1));
        this.assertFalse(rs.getMetaData().isWritable(1));
        this.assertEquals("", rs.getMetaData().getCatalogName(1));
        this.assertEquals(Void.class.getName(), rs.getMetaData().getColumnClassName(1));
        this.assertEquals("NULL", rs.getMetaData().getColumnTypeName(1));
        this.assertEquals("", rs.getMetaData().getSchemaName(1));
        this.assertEquals("", rs.getMetaData().getTableName(1));
        this.assertEquals(1, rs.getHoldability());
        this.assertEquals(1, rs.getColumnCount());
        rs = new SimpleResultSet();
        rs.setAutoClose(false);
        rs.addColumn("a", -5, 0, 0);
        rs.addColumn("b", -2, 0, 0);
        rs.addColumn("c", 16, 0, 0);
        rs.addColumn("d", 91, 0, 0);
        rs.addColumn("e", 3, 0, 0);
        rs.addColumn("f", 6, 0, 0);
        rs.addColumn("g", 12, 0, 0);
        rs.addColumn("h", 2003, 0, 0);
        rs.addColumn("i", 92, 0, 0);
        rs.addColumn("j", 93, 0, 0);
        rs.addColumn("k", 2005, 0, 0);
        rs.addColumn("l", 2004, 0, 0);
        Date d = Date.valueOf("2001-02-03");
        byte[] b = new byte[]{-85};
        Object[] a = new Object[]{1, 2};
        Time t = Time.valueOf("10:20:30");
        Timestamp ts = Timestamp.valueOf("2002-03-04 10:20:30");
        SimpleClob clob = new SimpleClob("Hello World");
        SimpleBlob blob = new SimpleBlob(new byte[]{1, 2});
        rs.addRow(1, b, true, d, "10.3", Math.PI, "-3", a, t, ts, clob, blob);
        rs.addRow(BigInteger.ONE, null, true, null, BigDecimal.ONE, 1.0, null, null, null, null, null);
        rs.addRow(BigInteger.ZERO, null, false, null, BigDecimal.ZERO, 0.0, null, null, null, null, null);
        rs.addRow(null, null, null, null, null, null, null, null, null, null, null);
        rs.addRow(null, null, true, null, null, null, null, null, null, null, null);
        rs.next();
        this.assertEquals(1L, rs.getLong(1));
        this.assertEquals(1, rs.getByte(1));
        this.assertEquals(1, rs.getShort(1));
        this.assertEquals(1L, rs.getLong("a"));
        this.assertEquals(1, rs.getByte("a"));
        this.assertEquals(1, rs.getInt("a"));
        this.assertEquals(1, rs.getShort("a"));
        this.assertTrue(rs.getObject(1).getClass() == Integer.class);
        this.assertTrue(rs.getObject("a").getClass() == Integer.class);
        this.assertTrue(rs.getBoolean(1));
        this.assertEquals(b, rs.getBytes(2));
        this.assertEquals(b, rs.getBytes("b"));
        this.assertTrue(rs.getBoolean(3));
        this.assertTrue(rs.getBoolean("c"));
        this.assertEquals(d.getTime(), rs.getDate(4).getTime());
        this.assertEquals(d.getTime(), rs.getDate("d").getTime());
        this.assertTrue(new BigDecimal("10.3").equals(rs.getBigDecimal(5)));
        this.assertTrue(new BigDecimal("10.3").equals(rs.getBigDecimal("e")));
        this.assertEquals(10.3, rs.getDouble(5));
        this.assertEquals(10.3f, rs.getFloat(5));
        this.assertTrue(Math.PI == rs.getDouble(6));
        this.assertTrue(Math.PI == rs.getDouble("f"));
        this.assertTrue((float)Math.PI == rs.getFloat(6));
        this.assertTrue((float)Math.PI == rs.getFloat("f"));
        this.assertTrue(rs.getBoolean(6));
        this.assertEquals(-3, rs.getInt(7));
        this.assertEquals(-3, rs.getByte(7));
        this.assertEquals(-3, rs.getShort(7));
        this.assertEquals(-3L, rs.getLong(7));
        Object[] a2 = (Object[])rs.getArray(8).getArray();
        this.assertEquals(2, a2.length);
        this.assertTrue(a == a2);
        SimpleResultSet.SimpleArray array = (SimpleResultSet.SimpleArray)rs.getArray("h");
        this.assertEquals(0, array.getBaseType());
        this.assertEquals("NULL", array.getBaseTypeName());
        a2 = (Object[])array.getArray();
        array.free();
        this.assertEquals(2, a2.length);
        this.assertTrue(a == a2);
        this.assertTrue(t == rs.getTime("i"));
        this.assertTrue(t == rs.getTime(9));
        this.assertTrue(ts == rs.getTimestamp("j"));
        this.assertTrue(ts == rs.getTimestamp(10));
        this.assertTrue(clob == rs.getClob("k"));
        this.assertTrue(clob == rs.getClob(11));
        this.assertEquals("Hello World", rs.getString("k"));
        this.assertEquals("Hello World", rs.getString(11));
        this.assertTrue(blob == rs.getBlob("l"));
        this.assertTrue(blob == rs.getBlob(12));
        ((ResultSet)this.assertThrows(90008, rs)).getString(13);
        ((ResultSet)this.assertThrows(42122, rs)).getString("NOT_FOUND");
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        this.assertTrue(rs.getBoolean(3));
        this.assertTrue(rs.getBoolean(5));
        this.assertTrue(rs.getBoolean(6));
        rs.next();
        this.assertFalse(rs.getBoolean(1));
        this.assertFalse(rs.getBoolean(3));
        this.assertFalse(rs.getBoolean(5));
        this.assertFalse(rs.getBoolean(6));
        rs.next();
        this.assertEquals(0L, rs.getLong(1));
        this.assertTrue(rs.wasNull());
        this.assertEquals((byte[])null, rs.getBytes(2));
        this.assertTrue(rs.wasNull());
        this.assertFalse(rs.getBoolean(3));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getDate(4));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getBigDecimal(5));
        this.assertTrue(rs.wasNull());
        this.assertEquals(0.0, rs.getDouble(5));
        this.assertTrue(rs.wasNull());
        this.assertEquals(0.0, rs.getDouble(6));
        this.assertTrue(rs.wasNull());
        this.assertEquals(0.0, (double)rs.getFloat(6));
        this.assertTrue(rs.wasNull());
        this.assertEquals(0, rs.getInt(7));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getArray(8));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getTime(9));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getTimestamp(10));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getClob(11));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getCharacterStream(11));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getBlob(12));
        this.assertTrue(rs.wasNull());
        this.assertNull(rs.getBinaryStream(12));
        this.assertTrue(rs.wasNull());
        this.assertTrue(rs.next());
        this.assertTrue(rs.getBoolean(3));
        this.assertFalse(rs.wasNull());
        this.assertNull(rs.getObject(6, Float.class));
        this.assertTrue(rs.wasNull());
        Method[] methodArray = rs.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("update") && !m.getName().equals("updateRow")) {
                Class<?> p3;
                int len = m.getParameterTypes().length;
                if (!m.getName().equals("updateObject") || m.getParameterTypes().length <= 2 || (p3 = m.getParameterTypes()[2]).toString().indexOf("SQLType") < 0) {
                    Object[] params = new Object[len];
                    int i = 0;
                    String expectedValue = null;
                    Class<?>[] classArray = m.getParameterTypes();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object o;
                        Class<?> type = classArray[n4];
                        String e = null;
                        if (type == Integer.TYPE) {
                            o = 1;
                            e = "1";
                        } else if (type == Byte.TYPE) {
                            o = (byte)2;
                            e = "2";
                        } else if (type == Double.TYPE) {
                            o = 3.0;
                            e = "3.0";
                        } else if (type == Float.TYPE) {
                            o = Float.valueOf(4.0f);
                            e = "4.0";
                        } else if (type == Long.TYPE) {
                            o = 5L;
                            e = "5";
                        } else if (type == Short.TYPE) {
                            o = (short)6;
                            e = "6";
                        } else if (type == Boolean.TYPE) {
                            o = false;
                            e = "false";
                        } else if (type == String.class) {
                            o = "a";
                            e = "a";
                        } else {
                            o = null;
                        }
                        if (i == 1) {
                            expectedValue = e;
                        }
                        params[i] = o;
                        ++i;
                        ++n4;
                    }
                    m.invoke((Object)rs, params);
                    if (params.length == 1) {
                        this.assertEquals(null, rs.getString(1));
                    } else {
                        this.assertEquals(expectedValue, rs.getString(1));
                    }
                    Object invalidColumn = m.getParameterTypes()[0] == String.class ? "x" : Integer.valueOf(0);
                    params[0] = invalidColumn;
                    try {
                        m.invoke((Object)rs, params);
                        this.fail();
                    }
                    catch (InvocationTargetException e) {
                        SQLException e2 = (SQLException)e.getTargetException();
                        if (invalidColumn instanceof String) {
                            this.assertEquals(42122, e2.getErrorCode());
                        }
                        this.assertEquals(90008, e2.getErrorCode());
                    }
                }
            }
            ++n2;
        }
        this.assertEquals(1000, rs.getFetchDirection());
        this.assertEquals(0, rs.getFetchSize());
        this.assertEquals(1004, rs.getType());
        this.assertNull(rs.getStatement());
        this.assertFalse(rs.isClosed());
        rs.beforeFirst();
        this.assertEquals(0, rs.getRow());
        this.assertTrue(rs.next());
        this.assertFalse(rs.isClosed());
        this.assertEquals(1, rs.getRow());
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        ((ResultSet)this.assertThrows(2000, rs)).getInt(1);
        this.assertEquals(0, rs.getRow());
        this.assertFalse(rs.isClosed());
        rs.close();
        this.assertTrue(rs.isClosed());
        rs = new SimpleResultSet();
        rs.addColumn("TEST", -2, 0, 0);
        UUID uuid = UUID.randomUUID();
        rs.addRow(uuid);
        rs.next();
        this.assertEquals(uuid, rs.getObject(1));
        this.assertEquals(uuid, ValueUuid.get(rs.getBytes(1)).getUuid());
        this.assertTrue(rs.isWrapperFor(Object.class));
        this.assertTrue(rs.isWrapperFor(ResultSet.class));
        this.assertTrue(rs.isWrapperFor(rs.getClass()));
        this.assertFalse(rs.isWrapperFor(Integer.class));
        this.assertTrue(rs == rs.unwrap(Object.class));
        this.assertTrue(rs == rs.unwrap(ResultSet.class));
        this.assertTrue(rs == rs.unwrap(rs.getClass()));
        SimpleResultSet rs2 = rs;
        this.assertThrows(90008, () -> rs2.unwrap(Integer.class));
    }

    private void testJdbcDriverUtils() {
        this.assertEquals("org.h2.Driver", JdbcUtils.getDriver("jdbc:h2:~/test"));
        this.assertEquals("org.postgresql.Driver", JdbcUtils.getDriver("jdbc:postgresql:test"));
        this.assertEquals(null, JdbcUtils.getDriver("jdbc:unknown:test"));
        try {
            JdbcUtils.getConnection("org.h2.Driver", "jdbc:h2x:test", "sa", "");
            this.fail("Expected SQLException: 08001");
        }
        catch (SQLException e) {
            this.assertEquals("08001", e.getSQLState());
        }
        try {
            JdbcUtils.getConnection("javax.naming.InitialContext", "ldap://localhost/ds", "sa", "");
            this.fail("Expected SQLException: 08001");
        }
        catch (SQLException e) {
            this.assertEquals("08001", e.getSQLState());
            this.assertEquals("Only java scheme is supported for JNDI lookups", e.getMessage());
        }
        try {
            JdbcUtils.getConnection("org.h2.Driver", "jdbc:h2:mem:", "sa", "", null, true);
            this.fail("Expected SQLException: 90149");
        }
        catch (SQLException e) {
            this.assertEquals(90149, e.getErrorCode());
        }
    }

    private void testWrongServer() throws Exception {
        this.assertThrows(90067, () -> this.getConnection("jdbc:h2:tcp://localhost:9001/test"));
        final ServerSocket serverSocket = new ServerSocket(9001);
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    Socket socket = serverSocket.accept();
                    byte[] data = new byte[1024];
                    data[0] = 120;
                    OutputStream out = socket.getOutputStream();
                    out.write(data);
                    out.close();
                    socket.close();
                }
            }
        };
        try {
            task.execute();
            Thread.sleep(100L);
            this.assertThrows(90067, () -> this.getConnection("jdbc:h2:tcp://localhost:9001/test"));
        }
        finally {
            serverSocket.close();
            task.getException();
        }
    }

    private void testDeleteFiles() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("testDeleteFiles");
        Connection conn = this.getConnection("testDeleteFiles");
        Statement stat = conn.createStatement();
        stat.execute("create table test(c clob) as select space(10000) from dual");
        conn.close();
        DeleteDbFiles.execute(this.getBaseDir(), "testDelete", true);
        conn = this.getConnection("testDeleteFiles");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        rs.getString(1);
        conn.close();
        this.deleteDb("testDeleteFiles");
    }

    private void testServerMain() throws Exception {
        this.testNonSSL();
        if (!this.config.ci) {
            this.testSSL();
        }
    }

    private void testNonSSL() throws Exception {
        try {
            String result = this.runServer(0, "-?");
            this.assertContains(result, "Starts the H2 Console");
            this.assertTrue(result.indexOf("Unknown option") < 0);
            result = this.runServer(1, "-xy");
            this.assertContains(result, "Starts the H2 Console");
            this.assertContains(result, "Feature not supported");
            result = this.runServer(0, "-ifNotExists", "-tcp", "-tcpPort", "9001", "-tcpPassword", "abc");
            this.assertContains(result, "tcp://");
            this.assertContains(result, ":9001");
            this.assertContains(result, "only local");
            this.assertTrue(result.indexOf("Starts the H2 Console") < 0);
            Connection conn = this.getConnection("jdbc:h2:tcp://localhost:9001/mem:", "sa", "sa");
            conn.close();
            result = this.runServer(0, "-tcpShutdown", "tcp://localhost:9001", "-tcpPassword", "abc", "-tcpShutdownForce");
            this.assertContains(result, "Shutting down");
        }
        finally {
            this.shutdownServers();
        }
    }

    private void testSSL() throws Exception {
        try {
            String result = this.runServer(0, "-ifNotExists", "-tcp", "-tcpAllowOthers", "-tcpPort", "9001", "-tcpPassword", "abcdef", "-tcpSSL");
            this.assertContains(result, "ssl://");
            this.assertContains(result, ":9001");
            this.assertContains(result, "others can");
            this.assertTrue(result.indexOf("Starts the H2 Console") < 0);
            Connection conn = this.getConnection("jdbc:h2:ssl://localhost:9001/mem:", "sa", "sa");
            conn.close();
            result = this.runServer(0, "-tcpShutdown", "ssl://localhost:9001", "-tcpPassword", "abcdef");
            this.assertContains(result, "Shutting down");
            this.assertThrows(90067, () -> this.getConnection("jdbc:h2:ssl://localhost:9001/mem:", "sa", "sa"));
            result = this.runServer(0, "-ifNotExists", "-web", "-webPort", "9002", "-webAllowOthers", "-webSSL", "-pg", "-pgAllowOthers", "-pgPort", "9003", "-tcp", "-tcpAllowOthers", "-tcpPort", "9006", "-tcpPassword", "abc");
            Server stop = this.server;
            this.assertContains(result, "https://");
            this.assertContains(result, ":9002");
            this.assertContains(result, "pg://");
            this.assertContains(result, ":9003");
            this.assertContains(result, "others can");
            this.assertTrue(result.indexOf("only local") < 0);
            this.assertContains(result, "tcp://");
            this.assertContains(result, ":9006");
            conn = this.getConnection("jdbc:h2:tcp://localhost:9006/mem:", "sa", "sa");
            conn.close();
            result = this.runServer(0, "-tcpShutdown", "tcp://localhost:9006", "-tcpPassword", "abc", "-tcpShutdownForce");
            this.assertContains(result, "Shutting down");
            stop.shutdown();
            this.assertThrows(90067, () -> this.getConnection("jdbc:h2:tcp://localhost:9006/mem:", "sa", "sa"));
        }
        finally {
            this.shutdownServers();
        }
    }

    private String runServer(int exitCode, String ... args) throws Exception {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)buff, false, "UTF-8");
        if (this.server != null) {
            this.remainingServers.add(this.server);
        }
        this.server = new Server();
        this.server.setOut(ps);
        int result = 0;
        try {
            this.server.runTool(args);
        }
        catch (SQLException e) {
            result = 1;
            e.printStackTrace(ps);
        }
        this.assertEquals(exitCode, result);
        ps.flush();
        return buff.toString(StandardCharsets.UTF_8);
    }

    private void shutdownServers() {
        for (Server remainingServer : this.remainingServers) {
            if (remainingServer == null) continue;
            remainingServer.shutdown();
        }
        this.remainingServers.clear();
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void testConvertTraceFile() throws Exception {
        this.deleteDb("toolsConvertTraceFile");
        Driver.load();
        Object url = "jdbc:h2:" + this.getBaseDir() + "/toolsConvertTraceFile";
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url + ";TRACE_LEVEL_FILE=3", "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar, amount decimal(4, 2))");
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "Hello \\'Joe\n\\'");
        prep.setBigDecimal(3, new BigDecimal("10.20"));
        prep.executeUpdate();
        stat.execute("create table test2(id int primary key,\na real, b double, c bigint,\nd smallint, e boolean, f varbinary, g date, h time, i timestamp)", 2);
        prep = conn.prepareStatement("insert into test2 values(1, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        prep.setFloat(1, Float.MIN_VALUE);
        prep.setDouble(2, Double.MIN_VALUE);
        prep.setLong(3, Long.MIN_VALUE);
        prep.setShort(4, (short)Short.MIN_VALUE);
        prep.setBoolean(5, false);
        prep.setBytes(6, new byte[]{10, 20});
        prep.setDate(7, Date.valueOf("2007-12-31"));
        prep.setTime(8, Time.valueOf("23:59:59"));
        prep.setTimestamp(9, Timestamp.valueOf("2007-12-31 23:59:59"));
        prep.executeUpdate();
        conn.close();
        ConvertTraceFile.main("-traceFile", this.getBaseDir() + "/toolsConvertTraceFile.trace.db", "-javaClass", this.getBaseDir() + "/Test", "-script", this.getBaseDir() + "/test.sql");
        FileUtils.delete(this.getBaseDir() + "/Test.java");
        String trace = this.getBaseDir() + "/toolsConvertTraceFile.trace.db";
        this.assertTrue(FileUtils.exists(trace));
        String newTrace = this.getBaseDir() + "/test.trace.db";
        FileUtils.delete(newTrace);
        this.assertFalse(FileUtils.exists(newTrace));
        FileUtils.move(trace, newTrace);
        this.deleteDb("toolsConvertTraceFile");
        Player.main(this.getBaseDir() + "/test.trace.db");
        this.testTraceFile((String)url);
        this.deleteDb("toolsConvertTraceFile");
        RunScript.main(new String[]{"-url", url, "-user", "sa", "-script", this.getBaseDir() + "/test.sql"});
        this.testTraceFile((String)url);
        this.deleteDb("toolsConvertTraceFile");
        FileUtils.delete(this.getBaseDir() + "/toolsConvertTraceFile.h2.sql");
        FileUtils.delete(this.getBaseDir() + "/test.sql");
    }

    private void testTraceFile(String url) throws SQLException {
        Recover.main("-dir", this.getBaseDir(), "-db", "toolsConvertTraceFile");
        Connection conn = this.getConnection(url, "sa", "");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello \\'Joe\n\\'", rs.getString(2));
        this.assertEquals("10.20", rs.getBigDecimal(3).toString());
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from test2");
        rs.next();
        this.assertEquals(Float.MIN_VALUE, rs.getFloat("a"));
        this.assertEquals((double)Double.MIN_VALUE, rs.getDouble("b"));
        this.assertEquals(Long.MIN_VALUE, rs.getLong("c"));
        this.assertEquals(Short.MIN_VALUE, rs.getShort("d"));
        this.assertFalse(rs.getBoolean("e"));
        this.assertEquals(new byte[]{10, 20}, rs.getBytes("f"));
        this.assertEquals("2007-12-31", rs.getString("g"));
        this.assertEquals("23:59:59", rs.getString("h"));
        this.assertEquals("2007-12-31 23:59:59", rs.getString("i"));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testRecover() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("toolsRecover");
        Driver.load();
        String url = this.getURL("toolsRecover", true);
        Connection conn = this.getConnection(url, "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar, b blob, c clob)");
        stat.execute("create table \"test 2\"(id int primary key, name varchar)");
        stat.execute("comment on table test is ';-)'");
        stat.execute("insert into test values(1, 'Hello', SECURE_RAND(4100), '\u00e4' || space(4100))");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        byte[] b1 = rs.getBytes(3);
        String s1 = rs.getString(4);
        conn.close();
        Recover.main("-dir", this.getBaseDir(), "-db", "toolsRecover");
        ArrayList<String> list = FileLister.getDatabaseFiles(this.getBaseDir(), "toolsRecover", true);
        for (String fileName : list) {
            if (FileUtils.isDirectory(fileName)) continue;
            FileUtils.delete(fileName);
        }
        conn = this.getConnection(url);
        stat = conn.createStatement();
        String suffix = ".h2.sql";
        stat.execute("runscript from '" + this.getBaseDir() + "/toolsRecover" + suffix + "'");
        rs = stat.executeQuery("select * from \"test 2\"");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        byte[] b2 = rs.getBytes(3);
        String s2 = rs.getString(4);
        this.assertEquals("\u00e4 ", s2.substring(0, 2));
        this.assertEquals(4100, b2.length);
        this.assertEquals(4101, s2.length());
        this.assertEquals(b1, b2);
        this.assertEquals(s1, s2);
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("toolsRecover");
        FileUtils.delete(this.getBaseDir() + "/toolsRecover.h2.sql");
        String dir = this.getBaseDir() + "/toolsRecover.lobs.db";
        FileUtils.deleteRecursive(dir, false);
    }

    private void testManagementDb() throws SQLException {
        int count = this.getSize(2, 10);
        int i = 0;
        while (i < count) {
            Server tcpServer = Server.createTcpServer(new String[0]).start();
            tcpServer.stop();
            tcpServer = Server.createTcpServer("-tcpPassword", "abc").start();
            tcpServer.stop();
            ++i;
        }
    }

    private void testScriptRunscriptLob() throws Exception {
        String url = this.getURL("jdbc:h2:" + this.getBaseDir() + "/testScriptRunscriptLob", true);
        String user = "sa";
        String password = "abc";
        String fileName = this.getBaseDir() + "/b2.sql";
        Connection conn = this.getConnection(url, user, password);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, BDATA BLOB, CDATA CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        prep.setInt(1, 1);
        prep.setNull(2, 2004);
        prep.setNull(3, 2005);
        prep.execute();
        prep.setInt(1, 2);
        prep.setString(2, "face");
        prep.setString(3, "face");
        prep.execute();
        Random random = new Random(1L);
        prep.setInt(1, 3);
        byte[] large = new byte[this.getSize(10240, 102400)];
        random.nextBytes(large);
        prep.setBytes(2, large);
        String largeText = new String(large, StandardCharsets.ISO_8859_1);
        prep.setString(3, largeText);
        prep.execute();
        int i = 0;
        while (i < 2) {
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
            rs.next();
            this.assertEquals(1, rs.getInt(1));
            this.assertNull(rs.getString(2));
            this.assertNull(rs.getString(3));
            rs.next();
            this.assertEquals(2, rs.getInt(1));
            this.assertEquals("face", rs.getString(2));
            this.assertEquals("face", rs.getString(3));
            rs.next();
            this.assertEquals(3, rs.getInt(1));
            this.assertEquals(large, rs.getBytes(2));
            this.assertEquals(largeText, rs.getString(3));
            this.assertFalse(rs.next());
            conn.close();
            Script.main("-url", url, "-user", user, "-password", password, "-script", fileName);
            DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testScriptRunscriptLob", "-quiet");
            RunScript.main("-url", url, "-user", user, "-password", password, "-script", fileName);
            conn = this.getConnection("jdbc:h2:" + this.getBaseDir() + "/testScriptRunscriptLob", "sa", "abc");
            ++i;
        }
        conn.close();
    }

    private void testScriptRunscript() throws Exception {
        String url = this.getURL("jdbc:h2:" + this.getBaseDir() + "/testScriptRunscript", true);
        String user = "sa";
        String password = "abc";
        String fileName = this.getBaseDir() + "/b2.sql";
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testScriptRunscript", "-quiet");
        Connection conn = this.getConnection(url, user, password);
        conn.createStatement().execute("CREATE TABLE \u00f6()");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        conn.createStatement().execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.close();
        Script.main("-url", url, "-user", user, "-password", password, "-script", fileName, "-options", "nodata", "compression", "lzf", "cipher", "aes", "password", "'123'", "charset", "'utf-8'");
        Script.main("-url", url, "-user", user, "-password", password, "-script", fileName + ".txt");
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testScriptRunscript", "-quiet");
        RunScript.main("-url", url, "-user", user, "-password", password, "-script", fileName, "-options", "compression", "lzf", "cipher", "aes", "password", "'123'", "charset", "'utf-8'");
        conn = this.getConnection("jdbc:h2:" + this.getBaseDir() + "/testScriptRunscript", "sa", "abc");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertFalse(rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM \u00f6");
        this.assertFalse(rs.next());
        conn.close();
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testScriptRunscript", "-quiet");
        RunScript tool = new RunScript();
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        tool.setOut(new PrintStream((OutputStream)buff, false, "UTF-8"));
        tool.runTool("-url", url, "-user", user, "-password", password, "-script", fileName + ".txt", "-showResults");
        this.assertContains(buff.toString(StandardCharsets.UTF_8), "Hello");
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testScriptRunscript", "-quiet");
        conn = this.getConnection(url, user, password);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        conn.close();
        Script.main("-url", url, "-user", user, "-password", password, "-script", fileName, "-options", "simple", "blocksize", "8192");
    }

    private void testBackupRestore() throws SQLException {
        Driver.load();
        String url = "jdbc:h2:" + this.getBaseDir() + "/testBackupRestore";
        String user = "sa";
        String password = "abc";
        String fileName = this.getBaseDir() + "/b2.zip";
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testBackupRestore", "-quiet");
        Connection conn = this.getConnection(url, user, password);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        conn.createStatement().execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.close();
        Backup.main("-file", fileName, "-dir", this.getBaseDir(), "-db", "testBackupRestore", "-quiet");
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testBackupRestore", "-quiet");
        Restore.main("-file", fileName, "-dir", this.getBaseDir(), "-db", "testBackupRestore", "-quiet");
        conn = this.getConnection("jdbc:h2:" + this.getBaseDir() + "/testBackupRestore", "sa", "abc");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        this.assertThrows(90133, () -> Backup.main("-file", fileName, "-dir", this.getBaseDir(), "-db", "testBackupRestore"));
        conn.close();
        DeleteDbFiles.main("-dir", this.getBaseDir(), "-db", "testBackupRestore", "-quiet");
    }

    private void testChangeFileEncryption(boolean split) throws SQLException {
        Driver.load();
        String dir = (split ? "split:19:" : "") + this.getBaseDir();
        String url = "jdbc:h2:" + dir + "/testChangeFileEncryption;CIPHER=AES";
        DeleteDbFiles.execute(dir, "testChangeFileEncryption", true);
        Connection conn = this.getConnection(url, "sa", "abc 123");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA CLOB) AS SELECT X, SPACE(3000) FROM SYSTEM_RANGE(1, 300)");
        conn.close();
        String[] args = new String[]{"-dir", dir, "-db", "testChangeFileEncryption", "-cipher", "AES", "-decrypt", "abc", "-quiet"};
        new ChangeFileEncryption().runTool(args);
        args = new String[]{"-dir", dir, "-db", "testChangeFileEncryption", "-cipher", "AES", "-encrypt", "def", "-quiet"};
        new ChangeFileEncryption().runTool(args);
        conn = this.getConnection(url, "sa", "def 123");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        this.assertThrows(90133, () -> new ChangeFileEncryption().runTool("-dir", dir, "-db", "testChangeFileEncryption", "-cipher", "AES", "-decrypt", "def", "-quiet"));
        conn.close();
        args = new String[]{"-dir", dir, "-db", "testChangeFileEncryption", "-quiet"};
        DeleteDbFiles.main(args);
    }

    private void testChangeFileEncryptionWithWrongPassword() throws SQLException {
        Driver.load();
        String dir = this.getBaseDir();
        String url = "jdbc:h2:" + dir + "/testChangeFileEncryption;CIPHER=AES";
        DeleteDbFiles.execute(dir, "testChangeFileEncryption", true);
        Connection conn = this.getConnection(url, "sa", "abc 123");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA CLOB) AS SELECT X, SPACE(3000) FROM SYSTEM_RANGE(1, 300)");
        conn.close();
        this.assertThrows(SQLException.class, () -> ChangeFileEncryption.execute(dir, "testChangeFileEncryption", "AES", "wrong".toCharArray(), "def".toCharArray(), true));
        ChangeFileEncryption.execute(dir, "testChangeFileEncryption", "AES", "abc".toCharArray(), "def".toCharArray(), true);
        conn = this.getConnection(url, "sa", "def 123");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        conn.close();
        String[] args = new String[]{"-dir", dir, "-db", "testChangeFileEncryption", "-quiet"};
        DeleteDbFiles.main(args);
    }

    private void testServer() throws SQLException {
        try {
            this.deleteDb("test");
            Server tcpServer = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir(), "-tcpAllowOthers").start();
            this.remainingServers.add(tcpServer);
            int port = tcpServer.getPort();
            Connection conn = this.getConnection("jdbc:h2:tcp://localhost:" + port + "/test", "sa", "");
            conn.close();
            this.assertThrows(90028, () -> this.getConnection("jdbc:h2:tcp://localhost:" + port + "/../test", "sa", ""));
            this.assertThrows(90028, () -> this.getConnection("jdbc:h2:tcp://localhost:" + port + "/../test2/test", "sa", ""));
            this.assertThrows(28000, () -> Server.shutdownTcpServer("tcp://localhost:" + port, "", true, false));
            tcpServer.stop();
            Server tcpServerWithPassword = Server.createTcpServer("-ifExists", "-tcpPassword", "abc", "-baseDir", this.getBaseDir()).start();
            int prt = tcpServerWithPassword.getPort();
            this.remainingServers.add(tcpServerWithPassword);
            this.assertThrows(90149, () -> this.getConnection("jdbc:h2:tcp://localhost:" + prt + "/test2", "sa", ""));
            this.assertThrows(90149, () -> this.getConnection("jdbc:h2:tcp://localhost:" + prt + "/test2;ifexists=false", "sa", ""));
            conn = this.getConnection("jdbc:h2:tcp://localhost:" + prt + "/test", "sa", "");
            conn.close();
            this.assertThrows(28000, () -> Server.shutdownTcpServer("tcp://localhost:" + prt, "", true, false));
            conn = this.getConnection("jdbc:h2:tcp://localhost:" + prt + "/test", "sa", "");
            Server.shutdownTcpServer("tcp://localhost:" + prt, "abc", true, false);
            this.deleteDb("test");
            this.assertThrows(90067, () -> this.getConnection("jdbc:h2:tcp://localhost:" + prt + "/test", "sa", ""));
            JdbcUtils.closeSilently(conn);
            this.deleteDb("testSplit");
            this.server = Server.createTcpServer("-ifNotExists", "-baseDir", this.getBaseDir(), "-tcpAllowOthers").start();
            int p = this.server.getPort();
            conn = this.getConnection("jdbc:h2:tcp://localhost:" + p + "/split:testSplit", "sa", "");
            conn.close();
            this.assertThrows(90028, () -> this.getConnection("jdbc:h2:tcp://localhost:" + p + "/../test", "sa", ""));
            this.server.stop();
            this.deleteDb("testSplit");
        }
        finally {
            this.shutdownServers();
        }
    }

    static class SimpleBlob
    implements Blob {
        private final byte[] data;

        SimpleBlob(byte[] data) {
            this.data = data;
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() throws SQLException {
            return this.data.length;
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void truncate(long len) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }

    static class SimpleClob
    implements Clob {
        private final String data;

        SimpleClob(String data) {
            this.data = data;
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return this.data;
        }

        @Override
        public long length() throws SQLException {
            return this.data.length();
        }

        @Override
        public long position(String search, long start) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position(Clob search, long start) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void truncate(long len) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }
}

