/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import org.h2.store.fs.FileBaseDefault;
import org.h2.test.utils.FilePathReorderWrites;

class FileReorderWrites
extends FileBaseDefault {
    private final FilePathReorderWrites file;
    private final FileChannel base;
    private final FileChannel readBase;
    private boolean closed;
    private ArrayList<FileWriteOperation> notAppliedList = new ArrayList();
    private int id;

    FileReorderWrites(FilePathReorderWrites file, FileChannel base, FileChannel readBase) {
        this.file = file;
        this.base = base;
        this.readBase = readBase;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.base.close();
        this.readBase.close();
        this.closed = true;
    }

    @Override
    public long size() throws IOException {
        return this.readBase.size();
    }

    @Override
    public int read(ByteBuffer dst, long pos) throws IOException {
        return this.readBase.read(dst, pos);
    }

    @Override
    protected void implTruncate(long newSize) throws IOException {
        long oldSize = this.readBase.size();
        if (oldSize <= newSize) {
            return;
        }
        this.addOperation(new FileWriteOperation(this.id++, newSize, null));
    }

    private int addOperation(FileWriteOperation op) throws IOException {
        FileReorderWrites.trace("op " + String.valueOf(op));
        this.checkError();
        this.notAppliedList.add(op);
        long now = op.getTime();
        int i = 0;
        while (i < this.notAppliedList.size() - 1) {
            FileWriteOperation old = this.notAppliedList.get(i);
            boolean applyOld = false;
            if (old.getTime() + 45000L < now) {
                applyOld = true;
            } else if (old.overlaps(op)) {
                applyOld = true;
            } else if (this.file.getRandom().nextInt(100) < 10) {
                applyOld = true;
            }
            if (applyOld) {
                FileReorderWrites.trace("op apply " + String.valueOf(op));
                old.apply(this.base);
                this.notAppliedList.remove(i);
                --i;
            }
            ++i;
        }
        return op.apply(this.readBase);
    }

    private void applyAll() throws IOException {
        FileReorderWrites.trace("applyAll");
        for (FileWriteOperation op : this.notAppliedList) {
            op.apply(this.base);
        }
        this.notAppliedList.clear();
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.checkError();
        this.readBase.force(metaData);
        this.applyAll();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (FilePathReorderWrites.isPartialWrites() && src.remaining() > 2) {
            ByteBuffer buf1 = src.slice();
            ByteBuffer buf2 = src.slice();
            int len1 = src.remaining() / 2;
            int len2 = src.remaining() - len1;
            buf1.limit(buf1.limit() - len2);
            buf2.position(buf2.position() + len1);
            int x = this.addOperation(new FileWriteOperation(this.id++, position, buf1));
            src.position(src.position() + (x += this.addOperation(new FileWriteOperation(this.id++, position + (long)len1, buf2))));
            return x;
        }
        return this.addOperation(new FileWriteOperation(this.id++, position, src));
    }

    private void checkError() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        this.file.checkError();
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.readBase.tryLock(position, size, shared);
    }

    public String toString() {
        return this.file.getScheme() + ":" + this.file.toString();
    }

    private static void trace(String message) {
    }

    static class FileWriteOperation {
        private final int id;
        private final long time;
        private final ByteBuffer buffer;
        private final long position;

        FileWriteOperation(int id, long position, ByteBuffer src) {
            this.id = id;
            this.time = System.currentTimeMillis();
            if (src == null) {
                this.buffer = null;
            } else {
                int len = src.limit() - src.position();
                this.buffer = ByteBuffer.allocate(len);
                this.buffer.put(src);
                this.buffer.flip();
            }
            this.position = position;
        }

        public long getTime() {
            return this.time;
        }

        boolean overlaps(FileWriteOperation other) {
            if (this.isTruncate() && other.isTruncate()) {
                return true;
            }
            if (this.isTruncate()) {
                return this.position < other.getEndPosition();
            }
            if (other.isTruncate()) {
                return this.getEndPosition() > other.position;
            }
            return this.position < other.getEndPosition() && this.getEndPosition() > other.position;
        }

        private boolean isTruncate() {
            return this.buffer == null;
        }

        private long getEndPosition() {
            return this.position + (long)this.getLength();
        }

        private int getLength() {
            return this.buffer == null ? 0 : this.buffer.limit() - this.buffer.position();
        }

        int apply(FileChannel channel) throws IOException {
            if (this.isTruncate()) {
                channel.truncate(this.position);
                return -1;
            }
            int len = channel.write(this.buffer, this.position);
            this.buffer.flip();
            return len;
        }

        public String toString() {
            String s = "[" + this.id + "]: @" + this.position + (String)(this.isTruncate() ? "-truncate" : "+" + this.getLength());
            return s;
        }
    }
}

