/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.sql.Timestamp;
import org.h2.util.ThreadDeadlockDetector;

public class SelfDestructor {
    private static final String PROPERTY_NAME = "h2.selfDestruct";

    public static void startCountdown(int defaultMinutes) {
        final int minutes = Integer.parseInt(System.getProperty(PROPERTY_NAME, "" + defaultMinutes));
        if (minutes == 0) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                int i = minutes;
                while (i >= 0) {
                    while (true) {
                        try {
                            String name = "SelfDestructor " + i + " min";
                            this.setName(name);
                        }
                        catch (OutOfMemoryError name) {
                            continue;
                        }
                        break;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException name) {
                        // empty catch block
                    }
                    --i;
                }
                try {
                    String time = new Timestamp(System.currentTimeMillis()).toString();
                    System.out.println(time + " Killing the process after " + minutes + " minute(s)");
                    try {
                        ThreadDeadlockDetector.dumpAllThreadsAndLocks("SelfDestructor timed out", System.err);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        int activeCount = Thread.activeCount();
                        Thread[] threads = new Thread[activeCount + 100];
                        int len = Thread.enumerate(threads);
                        int i2 = 0;
                        while (i2 < len) {
                            Thread t = threads[i2];
                            if (t != Thread.currentThread()) {
                                t.interrupt();
                            }
                            ++i2;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("Killing the process now");
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace(System.out);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Runtime.getRuntime().halt(1);
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static String getPropertyString(int minutes) {
        return "-Dh2.selfDestruct=" + minutes;
    }
}

