/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.h2.jdbc.JdbcConnection;
import org.h2.tools.RunScript;
import org.h2.util.Tool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateCluster
extends Tool {
    public static void main(String ... args) throws SQLException {
        new CreateCluster().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String urlSource = null;
        String urlTarget = null;
        String user = "";
        String password = "";
        String serverList = null;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-urlSource")) {
                urlSource = args[++i];
            } else if (arg.equals("-urlTarget")) {
                urlTarget = args[++i];
            } else if (arg.equals("-user")) {
                user = args[++i];
            } else if (arg.equals("-password")) {
                password = args[++i];
            } else if (arg.equals("-serverList")) {
                serverList = args[++i];
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        if (urlSource == null || urlTarget == null || serverList == null) {
            this.showUsage();
            throw new SQLException("Source URL, target URL, or server list not set");
        }
        CreateCluster.process(urlSource, urlTarget, user, password, serverList);
    }

    public void execute(String urlSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        CreateCluster.process(urlSource, urlTarget, user, password, serverList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void process(String urlSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            JdbcConnection connSource = new JdbcConnection(urlSource + ";CLUSTER=''", null, user, password, false);
            try {
                try (Statement statSource = connSource.createStatement();){
                    statSource.execute("SET EXCLUSIVE 2");
                    try {
                        CreateCluster.performTransfer(statSource, urlTarget, user, password, serverList);
                    }
                    finally {
                        statSource.execute("SET EXCLUSIVE FALSE");
                    }
                }
                if (connSource == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (connSource == null) throw throwable;
                connSource.close();
                throw throwable;
            }
            connSource.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void performTransfer(Statement statSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        Object var6_9;
        Throwable throwable;
        block37: {
            throwable = null;
            var6_9 = null;
            try {
                JdbcConnection connTarget = new JdbcConnection(urlTarget + ";CLUSTER=''", null, user, password, false);
                try {
                    try (Statement statTarget = connTarget.createStatement();){
                        statTarget.execute("DROP ALL OBJECTS DELETE FILES");
                    }
                    if (connTarget == null) break block37;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (connTarget == null) throw throwable;
                    connTarget.close();
                    throw throwable;
                }
                connTarget.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        try {
            throwable = null;
            var6_9 = null;
            try (PipedReader pipeReader = new PipedReader();){
                Future<?> threadFuture = CreateCluster.startWriter(pipeReader, statSource);
                Throwable throwable4 = null;
                Object var10_17 = null;
                try {
                    JdbcConnection connTarget = new JdbcConnection(urlTarget, null, user, password, false);
                    try {
                        try (Statement statTarget = connTarget.createStatement();){
                            RunScript.execute(connTarget, pipeReader);
                            try {
                                threadFuture.get();
                            }
                            catch (ExecutionException ex) {
                                throw new SQLException(ex.getCause());
                            }
                            catch (InterruptedException ex) {
                                throw new SQLException(ex);
                            }
                            statSource.executeUpdate("SET CLUSTER '" + serverList + "'");
                            statTarget.executeUpdate("SET CLUSTER '" + serverList + "'");
                        }
                        if (connTarget == null) return;
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        if (connTarget == null) throw throwable4;
                        connTarget.close();
                        throw throwable4;
                    }
                    connTarget.close();
                    return;
                }
                catch (Throwable throwable6) {
                    if (throwable4 == null) {
                        throwable4 = throwable6;
                        throw throwable4;
                    }
                    if (throwable4 == throwable6) throw throwable4;
                    throwable4.addSuppressed(throwable6);
                    throw throwable4;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    private static Future<?> startWriter(PipedReader pipeReader, Statement statSource) throws IOException {
        ExecutorService thread = Executors.newFixedThreadPool(1);
        PipedWriter pipeWriter = new PipedWriter(pipeReader);
        Future<?> threadFuture = thread.submit(() -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    PipedWriter writer = pipeWriter;
                    try {
                        try (ResultSet rs = statSource.executeQuery("SCRIPT");){
                            while (rs.next()) {
                                writer.write(rs.getString(1) + "\n");
                            }
                        }
                        if (writer == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (writer == null) throw throwable;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | SQLException ex) {
                throw new IllegalStateException("Producing script from the source DB is failing.", ex);
            }
        });
        thread.shutdown();
        return threadFuture;
    }
}

