/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.h2.engine.MetaRecord;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.db.LobStorageMap;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.StringDataType;
import org.h2.result.Row;
import org.h2.store.DataHandler;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.LobStorageInterface;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueLob;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private HashMap<String, String> columnTypeMap;
    private boolean lobMaps;

    public static void main(String ... args) throws SQLException {
        new Recover().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String dir = ".";
        String db = null;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if ("-dir".equals(arg)) {
                dir = args[++i];
            } else if ("-db".equals(arg)) {
                db = args[++i];
            } else if ("-trace".equals(arg)) {
                this.trace = true;
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        this.process(dir, db);
    }

    public static InputStream readBlobMap(Connection conn, long lobId, long precision) throws SQLException {
        final PreparedStatement prep = conn.prepareStatement("SELECT DATA FROM INFORMATION_SCHEMA.LOB_BLOCKS WHERE LOB_ID = ? AND SEQ = ? AND ? > 0");
        prep.setLong(1, lobId);
        prep.setLong(3, precision);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private int seq;
            private byte[] data = this.fetch();

            private byte[] fetch() {
                try {
                    prep.setInt(2, this.seq++);
                    ResultSet rs = prep.executeQuery();
                    if (rs.next()) {
                        return rs.getBytes(1);
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.data != null;
            }

            @Override
            public InputStream nextElement() {
                ByteArrayInputStream in = new ByteArrayInputStream(this.data);
                this.data = this.fetch();
                return in;
            }
        });
    }

    public static Reader readClobMap(Connection conn, long lobId, long precision) throws Exception {
        InputStream in = Recover.readBlobMap(conn, lobId, precision);
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    private void trace(String message) {
        if (this.trace) {
            this.out.println(message);
        }
    }

    private void traceError(String message, Throwable t) {
        this.out.println(message + ": " + t.toString());
        if (this.trace) {
            t.printStackTrace(this.out);
        }
    }

    public static void execute(String dir, String db) throws SQLException {
        try {
            new Recover().process(dir, db);
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    private void process(String dir, String db) {
        ArrayList<String> list = FileLister.getDatabaseFiles(dir, db, true);
        if (list.isEmpty()) {
            this.printNoDatabaseFilesFound(dir, db);
        }
        for (String fileName : list) {
            PrintWriter writer;
            if (!fileName.endsWith(".mv.db")) continue;
            String f = fileName.substring(0, fileName.length() - ".mv.db".length());
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                writer = this.getWriter(fileName, ".txt");
                try {
                    MVStoreTool.dump(fileName, writer, true);
                    MVStoreTool.info(fileName, writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var8_10 = null;
            try {
                writer = this.getWriter(f + ".h2.db", ".sql");
                try {
                    this.dumpMVStoreFile(writer, fileName);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private PrintWriter getWriter(String fileName, String suffix) {
        fileName = fileName.substring(0, fileName.length() - 3);
        String outputFile = fileName + suffix;
        this.trace("Created file: " + outputFile);
        try {
            return new PrintWriter(IOUtils.getBufferedWriter(FileUtils.newOutputStream(outputFile, false)));
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private void getSQL(StringBuilder builder, String column, Value v) {
        ValueLob lob;
        LobData lobData;
        if (v instanceof ValueLob && (lobData = (lob = (ValueLob)v).getLobData()) instanceof LobDataDatabase) {
            String columnType;
            long precision;
            LobDataDatabase lobDataDatabase = (LobDataDatabase)lobData;
            int type = v.getValueType();
            long id = lobDataDatabase.getLobId();
            if (type == 7) {
                precision = lob.octetLength();
                columnType = "BLOB";
                builder.append("READ_BLOB");
            } else {
                precision = lob.charLength();
                columnType = "CLOB";
                builder.append("READ_CLOB");
            }
            if (this.lobMaps) {
                builder.append("_MAP");
            } else {
                builder.append("_DB");
            }
            this.columnTypeMap.put(column, columnType);
            builder.append('(').append(id).append(", ").append(precision).append(')');
            return;
        }
        v.getSQL(builder, 4);
    }

    private void setDatabaseName(String name) {
        this.databaseName = name;
    }

    private void dumpMVStoreFile(PrintWriter writer, String fileName) {
        writer.println("-- MVStore");
        String className = this.getClass().getName();
        writer.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_MAP FOR '" + className + ".readBlobMap';");
        writer.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_MAP FOR '" + className + ".readClobMap';");
        this.resetSchema();
        this.setDatabaseName(fileName.substring(0, fileName.length() - ".mv.db".length()));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (MVStore mv = new MVStore.Builder().fileName(fileName).recoveryMode().readOnly().open();){
                Iterator<Object> dataIt;
                TransactionMap dataMap;
                String tableId;
                this.dumpLobMaps(writer, mv);
                writer.println("-- Layout");
                Recover.dumpLayout(writer, mv);
                writer.println("-- Meta");
                Recover.dumpMeta(writer, mv);
                writer.println("-- Types");
                Recover.dumpTypes(writer, mv);
                writer.println("-- Tables");
                TransactionStore store = new TransactionStore(mv, new ValueDataType());
                try {
                    store.init();
                }
                catch (Throwable e) {
                    this.writeError(writer, e);
                }
                for (String mapName : mv.getMapNames()) {
                    if (!mapName.startsWith("table.") || Integer.parseInt(tableId = mapName.substring("table.".length())) != 0) continue;
                    dataMap = store.begin().openMap(mapName);
                    dataIt = dataMap.keyIterator(null);
                    while (dataIt.hasNext()) {
                        Long rowId = dataIt.next();
                        Row row = (Row)dataMap.get(rowId);
                        try {
                            this.writeMetaRow(row);
                        }
                        catch (Throwable t) {
                            this.writeError(writer, t);
                        }
                    }
                }
                this.writeSchemaSET(writer);
                writer.println("---- Table Data ----");
                for (String mapName : mv.getMapNames()) {
                    if (!mapName.startsWith("table.") || Integer.parseInt(tableId = mapName.substring("table.".length())) == 0) continue;
                    dataMap = store.begin().openMap(mapName);
                    dataIt = dataMap.keyIterator(null);
                    boolean init = false;
                    while (dataIt.hasNext()) {
                        String columnName;
                        Value[] values;
                        Object rowId = dataIt.next();
                        Object value = dataMap.get(rowId);
                        if (value instanceof Row) {
                            values = ((Row)value).getValueList();
                            this.recordLength = values.length;
                        } else {
                            values = ((ValueCollectionBase)value).getList();
                            this.recordLength = values.length - 1;
                        }
                        if (!init) {
                            this.setStorage(Integer.parseInt(tableId));
                            StringBuilder builder = new StringBuilder();
                            this.valueId = 0;
                            while (this.valueId < this.recordLength) {
                                columnName = this.storageName + "." + this.valueId;
                                builder.setLength(0);
                                this.getSQL(builder, columnName, values[this.valueId]);
                                ++this.valueId;
                            }
                            this.createTemporaryTable(writer);
                            init = true;
                        }
                        StringBuilder buff = new StringBuilder();
                        buff.append("INSERT INTO O_").append(tableId).append(" VALUES(");
                        this.valueId = 0;
                        while (this.valueId < this.recordLength) {
                            if (this.valueId > 0) {
                                buff.append(", ");
                            }
                            columnName = this.storageName + "." + this.valueId;
                            this.getSQL(buff, columnName, values[this.valueId]);
                            ++this.valueId;
                        }
                        buff.append(");");
                        writer.println(buff.toString());
                    }
                }
                this.writeSchema(writer);
                writer.println("DROP ALIAS READ_BLOB_MAP;");
                writer.println("DROP ALIAS READ_CLOB_MAP;");
                writer.println("DROP TABLE IF EXISTS INFORMATION_SCHEMA.LOB_BLOCKS;");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            this.writeError(writer, e);
        }
    }

    private static void dumpLayout(PrintWriter writer, MVStore mv) {
        Map<String, String> layout = mv.getLayoutMap();
        for (Map.Entry<String, String> e : layout.entrySet()) {
            writer.println("-- " + e.getKey() + " = " + e.getValue());
        }
    }

    private static void dumpMeta(PrintWriter writer, MVStore mv) {
        MVMap<String, String> meta = mv.getMetaMap();
        for (Map.Entry<String, String> e : meta.entrySet()) {
            writer.println("-- " + e.getKey() + " = " + e.getValue());
        }
    }

    private static void dumpTypes(PrintWriter writer, MVStore mv) {
        MVMap.BasicBuilder builder = ((MVMap.Builder)new MVMap.Builder().keyType((DataType)StringDataType.INSTANCE)).valueType(new MetaType<Object>(null, null));
        Object map = mv.openMap("_", builder);
        for (Map.Entry e : ((MVMap)map).entrySet()) {
            writer.println("-- " + (String)e.getKey() + " = " + String.valueOf(e.getValue()));
        }
    }

    private void dumpLobMaps(PrintWriter writer, MVStore mv) {
        this.lobMaps = mv.hasMap("lobData");
        if (!this.lobMaps) {
            return;
        }
        TransactionStore txStore = new TransactionStore(mv);
        MVMap<Long, byte[]> lobData = LobStorageMap.openLobDataMap(txStore);
        StreamStore streamStore = new StreamStore(lobData);
        MVMap<Long, LobStorageMap.BlobMeta> lobMap = LobStorageMap.openLobMap(txStore);
        writer.println("-- LOB");
        writer.println("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_BLOCKS(LOB_ID BIGINT, SEQ INT, DATA VARBINARY, PRIMARY KEY(LOB_ID, SEQ));");
        boolean hasErrors = false;
        block2: for (Map.Entry<Long, LobStorageMap.BlobMeta> e : lobMap.entrySet()) {
            long lobId = e.getKey();
            LobStorageMap.BlobMeta value = e.getValue();
            byte[] streamStoreId = value.streamStoreId;
            InputStream in = streamStore.get(streamStoreId);
            int len = 8192;
            byte[] block = new byte[len];
            try {
                int seq = 0;
                while (true) {
                    int l;
                    if ((l = IOUtils.readFully(in, block, block.length)) > 0) {
                        writer.print("INSERT INTO INFORMATION_SCHEMA.LOB_BLOCKS VALUES(" + lobId + ", " + seq + ", X'");
                        writer.print(StringUtils.convertBytesToHex(block, l));
                        writer.println("');");
                    }
                    if (l != len) continue block2;
                    ++seq;
                }
            }
            catch (IOException ex) {
                this.writeError(writer, ex);
                hasErrors = true;
            }
        }
        writer.println("-- lobMap.size: " + lobMap.sizeAsLong());
        writer.println("-- lobData.size: " + lobData.sizeAsLong());
        if (hasErrors) {
            writer.println("-- lobMap");
            for (Long k : lobMap.keyList()) {
                LobStorageMap.BlobMeta value = lobMap.get(k);
                byte[] streamStoreId = value.streamStoreId;
                writer.println("--     " + String.valueOf(k) + " " + StreamStore.toString(streamStoreId));
            }
            writer.println("-- lobData");
            for (Long k : lobData.keyList()) {
                writer.println("--     " + String.valueOf(k) + " len " + lobData.get(k).length);
            }
        }
    }

    private String setStorage(int storageId) {
        this.storageId = storageId;
        this.storageName = "O_" + Integer.toString(storageId).replace('-', 'M');
        return this.storageName;
    }

    private void writeMetaRow(Row r) {
        MetaRecord meta = new MetaRecord(r);
        int objectType = meta.getObjectType();
        if (objectType == 1 && meta.getSQL().startsWith("CREATE PRIMARY KEY ")) {
            return;
        }
        this.schema.add(meta);
        if (objectType == 0) {
            this.tableMap.put(meta.getId(), Recover.extractTableOrViewName(meta.getSQL()));
        }
    }

    private void resetSchema() {
        this.schema = new ArrayList();
        this.objectIdSet = new HashSet();
        this.tableMap = new HashMap();
        this.columnTypeMap = new HashMap();
    }

    private void writeSchemaSET(PrintWriter writer) {
        writer.println("---- Schema SET ----");
        for (MetaRecord m : this.schema) {
            if (m.getObjectType() != 6) continue;
            String sql = m.getSQL();
            writer.println(sql + ";");
        }
    }

    private void writeSchema(PrintWriter writer) {
        String name;
        Integer objectId;
        writer.println("---- Schema ----");
        Collections.sort(this.schema);
        for (MetaRecord m : this.schema) {
            if (m.getObjectType() == 6 || Recover.isSchemaObjectTypeDelayed(m)) continue;
            String string = m.getSQL();
            writer.println(string + ";");
        }
        boolean deleteLobs = false;
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            objectId = entry.getKey();
            name = entry.getValue();
            if (!this.objectIdSet.contains(objectId) || !Recover.isLobTable(name)) continue;
            this.setStorage(objectId);
            writer.println("DELETE FROM " + name + ";");
            writer.println("INSERT INTO " + name + " SELECT * FROM " + this.storageName + ";");
            if (!name.equals("INFORMATION_SCHEMA.LOBS") && !name.equalsIgnoreCase("\"INFORMATION_SCHEMA\".\"LOBS\"")) continue;
            writer.println("UPDATE " + name + " SET `TABLE` = -2;");
            deleteLobs = true;
        }
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            objectId = entry.getKey();
            name = entry.getValue();
            if (!this.objectIdSet.contains(objectId)) continue;
            this.setStorage(objectId);
            if (Recover.isLobTable(name)) continue;
            writer.println("INSERT INTO " + name + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer objectId2 : this.objectIdSet) {
            this.setStorage(objectId2);
            writer.println("DROP TABLE " + this.storageName + ";");
        }
        if (deleteLobs) {
            writer.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE `TABLE` = -2;");
        }
        ArrayList<String> referentialConstraints = new ArrayList<String>();
        for (MetaRecord metaRecord : this.schema) {
            if (!Recover.isSchemaObjectTypeDelayed(metaRecord)) continue;
            String sql = metaRecord.getSQL();
            if (metaRecord.getObjectType() == 5 && sql.endsWith("NOCHECK") && sql.contains(" FOREIGN KEY") && sql.contains("REFERENCES ")) {
                referentialConstraints.add(sql);
                continue;
            }
            writer.println(sql + ";");
        }
        for (String string : referentialConstraints) {
            writer.println(string + ";");
        }
    }

    private static boolean isLobTable(String name) {
        return name.startsWith("INFORMATION_SCHEMA.LOB") || name.startsWith("\"INFORMATION_SCHEMA\".\"LOB") || name.startsWith("\"information_schema\".\"lob");
    }

    private static boolean isSchemaObjectTypeDelayed(MetaRecord m) {
        switch (m.getObjectType()) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void createTemporaryTable(PrintWriter writer) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            writer.write("CREATE TABLE ");
            writer.write(this.storageName);
            writer.write(40);
            int i = 0;
            while (i < this.recordLength) {
                if (i > 0) {
                    writer.print(", ");
                }
                writer.write(67);
                writer.print(i);
                writer.write(32);
                String columnType = this.columnTypeMap.get(this.storageName + "." + i);
                writer.write(columnType == null ? "VARCHAR" : columnType);
                ++i;
            }
            writer.println(");");
            writer.flush();
        }
    }

    private static String extractTableOrViewName(String sql) {
        int indexTable = sql.indexOf(" TABLE ");
        int indexView = sql.indexOf(" VIEW ");
        if (indexTable > 0 && indexView > 0) {
            if (indexTable < indexView) {
                indexView = -1;
            } else {
                indexTable = -1;
            }
        }
        if (indexView > 0) {
            sql = sql.substring(indexView + " VIEW ".length());
        } else if (indexTable > 0) {
            sql = sql.substring(indexTable + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (sql.startsWith("IF NOT EXISTS ")) {
            sql = sql.substring("IF NOT EXISTS ".length());
        }
        boolean ignore = false;
        int i = 0;
        while (i < sql.length()) {
            char ch = sql.charAt(i);
            if (ch == '\"') {
                ignore = !ignore;
            } else if (!(ignore || ch > ' ' && ch != '(')) {
                sql = sql.substring(0, i);
                return sql;
            }
            ++i;
        }
        return "UNKNOWN";
    }

    private void writeError(PrintWriter writer, Throwable e) {
        if (writer != null) {
            writer.println("// error: " + String.valueOf(e));
        }
        this.traceError("Error", e);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        return FileStore.open(this, name, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.getInternalError();
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageInterface getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.getInternalError();
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }
}

