/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RunScript
extends Tool {
    private boolean showResults;
    private boolean checkResults;

    public static void main(String ... args) throws SQLException {
        new RunScript().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        String script = "backup.sql";
        String options = null;
        boolean continueOnError = false;
        boolean showTime = false;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
            } else if (arg.equals("-user")) {
                user = args[++i];
            } else if (arg.equals("-password")) {
                password = args[++i];
            } else if (arg.equals("-continueOnError")) {
                continueOnError = true;
            } else if (arg.equals("-checkResults")) {
                this.checkResults = true;
            } else if (arg.equals("-showResults")) {
                this.showResults = true;
            } else if (arg.equals("-script")) {
                script = args[++i];
            } else if (arg.equals("-time")) {
                showTime = true;
            } else if (arg.equals("-driver")) {
                String driver = args[++i];
                JdbcUtils.loadUserClass(driver);
            } else if (arg.equals("-options")) {
                StringBuilder buff = new StringBuilder();
                ++i;
                while (i < args.length) {
                    buff.append(' ').append(args[i]);
                    ++i;
                }
                options = buff.toString();
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        if (url == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        long time = System.nanoTime();
        if (options != null) {
            RunScript.processRunscript(url, user, password, script, options);
        } else {
            this.process(url, user, password, script, null, continueOnError);
        }
        if (showTime) {
            time = System.nanoTime() - time;
            this.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        }
    }

    public static ResultSet execute(Connection conn, Reader reader) throws SQLException {
        String sql;
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            boolean resultSet;
            if (StringUtils.isWhitespaceOrEmpty(sql) || !(resultSet = stat.execute(sql))) continue;
            if (rs != null) {
                rs.close();
                rs = null;
            }
            rs = stat.getResultSet();
        }
        return rs;
    }

    private void process(Connection conn, String fileName, boolean continueOnError, Charset charset) throws SQLException, IOException {
        BufferedReader reader = FileUtils.newBufferedReader(fileName, charset);
        try {
            this.process(conn, continueOnError, FileUtils.getParent(fileName), reader, charset);
        }
        finally {
            IOUtils.closeSilently(reader);
        }
    }

    private void process(Connection conn, boolean continueOnError, String path, Reader reader, Charset charset) throws SQLException, IOException {
        Object sql;
        Statement stat = conn.createStatement();
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            String trim = ((String)sql).trim();
            if (trim.isEmpty()) continue;
            if (trim.startsWith("@") && StringUtils.toUpperEnglish(trim).startsWith("@INCLUDE")) {
                if (!FileUtils.isAbsolute((String)(sql = StringUtils.trimSubstring((String)sql, "@INCLUDE".length())))) {
                    sql = path + File.separatorChar + (String)sql;
                }
                this.process(conn, (String)sql, continueOnError, charset);
                continue;
            }
            try {
                if (this.showResults && !trim.startsWith("-->")) {
                    this.out.print((String)sql + ";");
                }
                if (this.showResults || this.checkResults) {
                    boolean query = stat.execute((String)sql);
                    if (!query) continue;
                    ResultSet rs = stat.getResultSet();
                    int columns = rs.getMetaData().getColumnCount();
                    StringBuilder buff = new StringBuilder();
                    while (rs.next()) {
                        buff.append("\n-->");
                        int i = 0;
                        while (i < columns) {
                            String s = rs.getString(i + 1);
                            if (s != null) {
                                s = StringUtils.replaceAll(s, "\r\n", "\n");
                                s = StringUtils.replaceAll(s, "\n", "\n-->    ");
                                s = StringUtils.replaceAll(s, "\r", "\r-->    ");
                            }
                            buff.append(' ').append(s);
                            ++i;
                        }
                    }
                    buff.append("\n;");
                    String result = buff.toString();
                    if (this.showResults) {
                        this.out.print(result);
                    }
                    if (!this.checkResults) continue;
                    Object expected = r.readStatement() + ";";
                    expected = StringUtils.replaceAll((String)expected, "\r\n", "\n");
                    if (((String)(expected = StringUtils.replaceAll((String)expected, "\r", "\n"))).equals(result)) continue;
                    expected = StringUtils.replaceAll((String)expected, " ", "+");
                    result = StringUtils.replaceAll(result, " ", "+");
                    throw new SQLException("Unexpected output for:\n" + ((String)sql).trim() + "\nGot:\n" + result + "\nExpected:\n" + (String)expected);
                }
                stat.execute((String)sql);
            }
            catch (Exception e) {
                if (continueOnError) {
                    e.printStackTrace(this.out);
                    continue;
                }
                throw DbException.toSQLException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processRunscript(String url, String user, String password, String fileName, String options) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Connection conn = JdbcUtils.getConnection(null, url, user, password);
            try {
                try (Statement stat = conn.createStatement();){
                    String sql = "RUNSCRIPT FROM '" + fileName + "' " + options;
                    stat.execute(sql);
                }
                if (conn == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            conn.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void execute(String url, String user, String password, String fileName, Charset charset, boolean continueOnError) throws SQLException {
        new RunScript().process(url, user, password, fileName, charset, continueOnError);
    }

    void process(String url, String user, String password, String fileName, Charset charset, boolean continueOnError) throws SQLException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection conn = JdbcUtils.getConnection(null, url, user, password);){
                this.process(conn, fileName, continueOnError, charset);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, fileName);
        }
    }
}

