/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AbbaLockingDetector
implements Runnable {
    private final int tickIntervalMs = 2;
    private volatile boolean stop;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private Thread thread;
    private final Map<String, Map<String, String>> lockOrdering = new WeakHashMap<String, Map<String, String>>();
    private final Set<String> knownDeadlocks = new HashSet<String>();

    public AbbaLockingDetector startCollecting() {
        this.thread = new Thread((Runnable)this, "AbbaLockingDetector");
        this.thread.setDaemon(true);
        this.thread.start();
        return this;
    }

    public synchronized void reset() {
        this.lockOrdering.clear();
        this.knownDeadlocks.clear();
    }

    public AbbaLockingDetector stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        return this;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable t) {
                break;
            }
        }
    }

    private void tick() {
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ThreadInfo[] list = this.threadMXBean.dumpAllThreads(true, false);
        this.processThreadList(list);
    }

    private void processThreadList(ThreadInfo[] threadInfoList) {
        ArrayList<String> lockOrder = new ArrayList<String>();
        ThreadInfo[] threadInfoArray = threadInfoList;
        int n = threadInfoList.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            lockOrder.clear();
            AbbaLockingDetector.generateOrdering(lockOrder, threadInfo);
            if (lockOrder.size() > 1) {
                this.markHigher(lockOrder, threadInfo);
            }
            ++n2;
        }
    }

    private static void generateOrdering(List<String> lockOrder, ThreadInfo info) {
        MonitorInfo[] lockedMonitors = info.getLockedMonitors();
        Arrays.sort(lockedMonitors, (a, b) -> b.getLockedStackDepth() - a.getLockedStackDepth());
        MonitorInfo[] monitorInfoArray = lockedMonitors;
        int n = lockedMonitors.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorInfo mi = monitorInfoArray[n2];
            String lockName = AbbaLockingDetector.getObjectName(mi);
            if (!lockName.equals("sun.misc.Launcher$AppClassLoader") && !lockOrder.contains(lockName)) {
                lockOrder.add(lockName);
            }
            ++n2;
        }
    }

    private synchronized void markHigher(List<String> lockOrder, ThreadInfo threadInfo) {
        String topLock = lockOrder.get(lockOrder.size() - 1);
        Map<String, String> map = this.lockOrdering.get(topLock);
        if (map == null) {
            map = new WeakHashMap<String, String>();
            this.lockOrdering.put(topLock, map);
        }
        String oldException = null;
        int i = 0;
        while (i < lockOrder.size() - 1) {
            String e;
            String olderLock = lockOrder.get(i);
            Map<String, String> oldMap = this.lockOrdering.get(olderLock);
            boolean foundDeadLock = false;
            if (oldMap != null && (e = oldMap.get(topLock)) != null) {
                foundDeadLock = true;
                String deadlockType = topLock + " " + olderLock;
                if (!this.knownDeadlocks.contains(deadlockType)) {
                    System.out.println(topLock + " synchronized after \n " + olderLock + ", but in the past before\nAFTER\n" + AbbaLockingDetector.getStackTraceForThread(threadInfo) + "BEFORE\n" + e);
                    this.knownDeadlocks.add(deadlockType);
                }
            }
            if (!foundDeadLock && !map.containsKey(olderLock)) {
                if (oldException == null) {
                    oldException = AbbaLockingDetector.getStackTraceForThread(threadInfo);
                }
                map.put(olderLock, oldException);
            }
            ++i;
        }
    }

    private static String getStackTraceForThread(ThreadInfo info) {
        StringBuilder sb = new StringBuilder().append('\"').append(info.getThreadName()).append("\" Id=").append(info.getThreadId()).append(' ').append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        MonitorInfo[] lockedMonitors = info.getLockedMonitors();
        boolean startDumping = false;
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement e = stackTrace[i];
            if (startDumping) {
                AbbaLockingDetector.dumpStackTraceElement(info, sb, i, e);
            }
            MonitorInfo[] monitorInfoArray = lockedMonitors;
            int n = lockedMonitors.length;
            int n2 = 0;
            while (n2 < n) {
                MonitorInfo mi = monitorInfoArray[n2];
                if (mi.getLockedStackDepth() == i) {
                    if (!startDumping) {
                        AbbaLockingDetector.dumpStackTraceElement(info, sb, i, e);
                        startDumping = true;
                    }
                    sb.append("\t-  locked ").append(mi);
                    sb.append('\n');
                }
                ++n2;
            }
            ++i;
        }
        return sb.toString();
    }

    private static void dumpStackTraceElement(ThreadInfo info, StringBuilder sb, int i, StackTraceElement e) {
        sb.append('\t').append("at ").append(e).append('\n');
        if (i == 0 && info.getLockInfo() != null) {
            Thread.State ts = info.getThreadState();
            switch (ts) {
                case BLOCKED: {
                    sb.append("\t-  blocked on ").append(info.getLockInfo()).append('\n');
                    break;
                }
                case WAITING: {
                    sb.append("\t-  waiting on ").append(info.getLockInfo()).append('\n');
                    break;
                }
                case TIMED_WAITING: {
                    sb.append("\t-  waiting on ").append(info.getLockInfo()).append('\n');
                }
            }
        }
    }

    private static String getObjectName(MonitorInfo info) {
        return info.getClassName() + "@" + Integer.toHexString(info.getIdentityHashCode());
    }
}

