/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ByteStack {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int size;
    private byte[] array = Utils.EMPTY_BYTES;

    public void push(byte item) {
        int index = this.size;
        int oldLength = this.array.length;
        if (index >= oldLength) {
            this.grow(oldLength);
        }
        this.array[index] = item;
        this.size = index + 1;
    }

    public byte pop() {
        int index = this.size - 1;
        if (index < 0) {
            throw new NoSuchElementException();
        }
        this.size = index;
        return this.array[index];
    }

    public int poll(int defaultValue) {
        int index = this.size - 1;
        if (index < 0) {
            return defaultValue;
        }
        this.size = index;
        return this.array[index];
    }

    public int peek(int defaultValue) {
        int index = this.size - 1;
        if (index < 0) {
            return defaultValue;
        }
        return this.array[index];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void grow(int length) {
        if (length == 0) {
            length = 16;
        } else {
            if (length >= 0x7FFFFFF7) {
                throw new OutOfMemoryError();
            }
            if ((length <<= 1) < 0) {
                length = 0x7FFFFFF7;
            }
        }
        this.array = Arrays.copyOf(this.array, length);
    }
}

