/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CloseWatcher
extends PhantomReference<Object> {
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Set<CloseWatcher> refs = Collections.synchronizedSet(new HashSet());
    private String openStackTrace;
    private AutoCloseable closeable;

    public CloseWatcher(Object referent, ReferenceQueue<Object> q, AutoCloseable closeable) {
        super(referent, q);
        this.closeable = closeable;
    }

    public static CloseWatcher pollUnclosed() {
        CloseWatcher cw;
        do {
            if ((cw = (CloseWatcher)queue.poll()) == null) {
                return null;
            }
            if (refs == null) continue;
            refs.remove(cw);
        } while (cw.closeable == null);
        return cw;
    }

    public static CloseWatcher register(Object o, AutoCloseable closeable, boolean stackTrace) {
        CloseWatcher cw = new CloseWatcher(o, queue, closeable);
        if (stackTrace) {
            Exception e = new Exception("Open Stack Trace");
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            cw.openStackTrace = s.toString();
        }
        refs.add(cw);
        return cw;
    }

    public static void unregister(CloseWatcher w) {
        w.closeable = null;
        refs.remove(w);
    }

    public String getOpenStackTrace() {
        return this.openStackTrace;
    }

    public AutoCloseable getCloseable() {
        return this.closeable;
    }
}

